/***************************************************************************/
/*  C:\cbproj\SoundUtl\utility1.h :                                        */
/*  - Some small string conversion functions etc     by DL4YHF.            */
/*  - dynamic memory allocation with "housekeeping" for debugging purposes */
/*  - MODULE PREFIX "UTL" ..   for historic reasons                        */
/*  - Copies exist in C:\cbproj\WSQ2 (to have 'all files in one place')    */
/* Note: Depending on the project type (*.C or *.CPP), the functions       */
/*       declared in this header may actually be implemented               */
/*       in C:\cbproj\SoundUtl\utility1.cpp (contains EVERYTHING)          */
/*       or C:\cbproj\SoundUtl\utility1.c   (just a small subset) !        */
/*  In more recent projects (like C:\cbproj\WSQ2), the availability        */
/*  of DL4YHF's "Utility One" is defined in the project settings           */
/*  via 'UseUtility1'. For example, the Audio-I/O-DLL-Host (AudioIO.C)     */
/*  can be compiled WITH or WITHOUT "Utility One".                         */
/***************************************************************************/

#ifndef  _UTILITY1_H_
 #define _UTILITY1_H_

#ifndef  _SWITCHES_H_
# include "SWITCHES.H" // project specific compiler switches ("options")
#endif                 // like SWI_FLOAT_PRECISION (1:T_Float=float, 2:T_Float=double).
                       // Must be included before anything else !

#ifndef T_Float /* T_Float also defined in SoundTab.h, SoundMaths.h, Sound.h, WaveIO.h,.. */
#if SWI_FLOAT_PRECISION==1 /* "float" instead of "double" saves CPU power on stoneage PCs */
 #define T_Float float
#else
 #define T_Float double
#endif
#endif // ndef T_Float


//#include <float.h>  /* we often need _finite() and _fpclass() ! */
// CAUTION: The inclusion of "FLOAT.H" can have a devastating effect;
//          see notes in TWatchForm::EnterPlotData() !

#ifndef CPROT
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

#ifdef BUILDING_THE_DLL
# define DLLIMPEX __declspec(dllexport)  /* here: DLLIMPEX = DLL EXPORT */
#endif
// Because __declspec(dllimport) cause problems with [wx]DevC++
//         (when NEITHER "building" NOR "importing" a DLL) :
#ifdef IMPORTING_A_DLL    
# define DLLIMPEX __declspec(dllimport)  /* here: DLLIMPEX = DLL IMPORT */
#endif

#ifndef DLLIMPEX   /* NEITHER "building" NOR "importing" a DLL : */
# define DLLIMPEX  /* kein dummer Deckelspeck ! */
#endif

// Data types which are usually defined in WINDOWS.H (or elsewhere)
#ifndef BOOL
 #define BOOL int /* no idea why wtypes.h uses "typedef long(!) BOOL" but anyway... */
#endif
#ifndef BYTE
 #define BYTE unsigned char
#endif
#ifndef WORD
 #define WORD unsigned short
#endif
#ifndef DWORD
 #define DWORD unsigned long
#endif

// Macro to avoid annoying warnings about 'assigned a value that is never used':
#ifndef UNREFERENCED
# ifdef __BORLANDC__
#  define UNREFERENCED(x)  (void)x
# else
#  define UNREFERENCED(x)  x=x
# endif
#endif // ndef UNREFERENCED ?


// Scaling units for T_SPECTRUM.iScaleUnit and others, so no module prefix here.
//   A copy of the more frequently used scale units is in FFT_FILTER_DLL.H ,
//   so that plugin developers don't need to include UTILITY1.H as well .
//   The same applies to DL4YHF's RigControl/RigControl.h .
#define SCALE_UNIT_BLANK   -2  // for UTL_FloatToTechNotation(): tech exponent but a BLANK unit (appended as string by caller)
#define SCALE_UNIT_NONE    -1
#define SCALE_UNIT_UNKNOWN  0  // in FiltCtrl.cpp : "amplitude unit as currently configured for the display" (dB or linear scale)
  // Voltages, Power units ...
#define SCALE_UNIT_NORM_V   1  // normalized ADC units (voltage), +/- 1.0  for full A/D converter input range
#define SCALE_UNIT_PERCENT  2  // linear, reference is "full scale" (100 % = ADC clipping)
#define SCALE_UNIT_VOLT     3  // voltage (V), 'calibrated' using UTL_dblAdcMaxInputVoltage
#define SCALE_UNIT_WATT     4  // power (W), 'calibrated' with UTL_dblAdcMaxInputVoltage + UTL_dblAdcInputImpedance
#define SCALE_UNIT_NORM_PWR 5  // power, normalized to 0...1 for full A/D converter input range
#define SCALE_UNIT_AMPERE   6  // current (A), just for completeness.. and CLI_ParseTechUnit()

  // Logarithmic units, dB, relative to "something" ...
#define SCALE_UNIT_MASK_dB 0x18  // mask to detect unit "dB" in all of its flavours..
#define SCALE_UNIT_dB      0x08  // dB , unknown reference level (using UTL_dblAdcMaxInputVoltage as user-defined reference)
#define SCALE_UNIT_dBfs    0x09  // dB , reference level is  "full scale" (0 dBfs = clipping point)
#define SCALE_UNIT_dBV     0x0A  // dB , reference level is 1 volt
#define SCALE_UNIT_dBuV    0x0B  // dB , reference level is 1 microvolt rms across any impedance (dBV)
#define SCALE_UNIT_dBm     0x0C  // dB , reference level is 1 milliwatt (often across 50 or 600 ohms)
  // Other UNIT CODES, which are NO amplitudes/magnitudes ...
#define SCALE_UNIT_DEGREE  0x10
#define SCALE_UNIT_HERTZ   0x11
#define SCALE_UNIT_SECONDS 0x12
#define SCALE_UNIT_TIME    0x13  // almost the same as SCALE_UNIT_SECONDS, but UTL_FloatToTechNotation() may decide to use MINUTES or HOURS for the display
#define SCALE_UNIT_SAMPLES_PER_SECOND 0x14 // technically the same as 'Hz' but used for SAMPLING RATES in combo lists

#ifndef DEBUG_LEVEL_ALL
# define DEBUG_LEVEL_ALL     0
# define DEBUG_LEVEL_INFO    5
# define DEBUG_LEVEL_WARNING 10
# define DEBUG_LEVEL_ERROR   20
# define DEBUG_LEVEL_FATAL   50
#endif

#define UTL_FMT_OPTION_SPACE_BEFORE_UNIT      0x0100
#define UTL_FMT_OPTION_REMOVE_TRAILING_ZEROES 0x0200

#define UTL_UNINITIALIZED_ARRAY_VALUE -99999.0 /* usually ZERO, other to debug */
   /* ( equal definitions exist in UTILITY1.H and TSpectrum.h ! ) */



//---------- GLOBAL variables -------------------------------------------
//  (not really nice but sometimes unavoidable)

extern DLLIMPEX char   UTL_sz255LogFile[256];     // optional name of DEBUG-LOG-FILE (""=don't log)
extern DLLIMPEX BOOL   UTL_fRunLog_UseOutputDebugString; // .. in UTL_WriteRunLogEntry(), BESIDES the logfile
extern DLLIMPEX double UTL_dblAdcMaxInputVoltage; // can be used for ABSOLUTE displays, like "100 mV"
extern DLLIMPEX double UTL_dblAdcInputImpedance;  // required for certain VOLTAGE / POWER conversions

extern int UTL_iWindowsMajorVersion; // 0=unknown, 5=Win2003 or XP, 6=Vista or Win7 (!), and the story goes on...
#   define WINDOWS_MAJOR_VERSION_XP   5 /* possible values for UTL_iWindowsMajorVersion .. */
#   define WINDOWS_MAJOR_VERSION_WIN7 6 /* better forget about "Vista" */
    /* (or whats the reason for NOT using number '7' for 'Windows 7' ? */


/***************************************************************************/
CPROT DLLIMPEX void UTL_Init(void); // should be called "EARLY" ON STARTUP

CPROT DLLIMPEX BOOL UTL_IsCPUIDAvailable(void);  // -> TRUE when the "CPUID" instruction is available
CPROT DLLIMPEX void UTL_GetCPUID( DWORD dwEAX, DWORD *pFourDWORDs ); // reads four DWORDS from "CPUID", for example with EAX=1 : "Processor Info and Feature Bits"

CPROT DLLIMPEX float UTL_GetCPULoad(void); // Call PERIODICALLY(!) at regular intervals (*) !


/***************************************************************************/
CPROT DLLIMPEX void UTL_OpenRunLongFile( char *pszLogFileName );
CPROT DLLIMPEX void UTL_WriteRunLogEntry( char * pszFormatString, ... );
      // About DEBUG_EnterErrorHistory() vs UTL_WriteRunLogEntry() :
      //       DEBUG_EnterErrorHistory() calls UTL_WriteRunLogEntry(),
      //       not vice versa.



/***************************************************************************/
CPROT DLLIMPEX void DEBUG_EnterErrorHistory(  // Located 'somewhere else' !!!
        int  debug_level,   // importance of the message (to be entered or not)
        int  options,       // reserved for future extensions
     double time_of_occurrence,  // fractional GMT SECONDS since Jan.1970
        #define UTL_USE_CURRENT_TIME       -1.0 /* frequently used as time_of_occurrence */
        #define UTL_DONT_SHOW_CURRENT_TIME -2.0 /* used if this line is a 'continuation' */
        char *message_fmt, // pointer to null-terminated format string (source)
                   ... );  // optional argument list (printf-style)


/***************************************************************************/
#ifndef BUILDING_THE_DLL
CPROT void DEBUG_Breakpoint( void );  // common breakpoint for all "self detected errors"
  // Only called through macro DEBUGGER_BREAK() in 'beta releases' !
  // Replaces the non-functional assert()-stuff .
  // When used for spectrum lab, implemented in C:\cbproj\SpecLab\DebugU1.cpp .
#define DEBUGGER_BREAK() DEBUG_Breakpoint()
#endif // ndef BUILDING_THE_DLL

/***************************************************************************/
// Dynamic memory allocation with additional housekeeping for debugging purposes:
CPROT DLLIMPEX void *UTL_malloc(DWORD size);
CPROT DLLIMPEX void *UTL_NamedMalloc( char *pszMemoryBlockName/*8*/, DWORD size);
   // Like malloc(), but this function allows the additional definition
   // of a NAME for the allocated memory; which can help to track down
   // non-freed memory blocks (when an application terminates, it can
   // list the names of all erroneously NON-FREED memory blocks
   // in the error log). The maximum length of the name is 8 characters !
   // Besides that, AND IN CONTRAST TO BORLAND C++BUILDER V6's "malloc()",
   // UTL_malloc() and UTL_NamedMalloc() guarantee 8-byte aligned blocks.
   // NEVER, EVER try to free blocks allocated that way by the standard "free()" !
CPROT DLLIMPEX void UTL_free(void *block);
CPROT DLLIMPEX long UTL_GetAllocdMemTotal(void);     // statistic of "own allocations"..
CPROT DLLIMPEX long UTL_GetAllocdMemNumBlocks(void);
CPROT DLLIMPEX BOOL UTL_CheckMemoryNodes(void);  // FALSE=error detected

#if( SWI_ALLOW_TESTING )
 CPROT DLLIMPEX BOOL UTL_IsMallocBlockValid( void * block );
#endif



/***************************************************************************/
CPROT DLLIMPEX int  UTL_SafeStrlen( char * pszSource, int iMaxLen );
CPROT DLLIMPEX void UTL_CopyShortenedString( char *pszDest, char *pszSource, int iMaxLen, int iWordBreakAfter);

/***************************************************************************/
CPROT DLLIMPEX void UTL_TimeToString(long now_sec, char *dst, char time_separator);
CPROT DLLIMPEX void UTL_TimeToDateString(long now_sec, char *dst, char date_separator);

CPROT DLLIMPEX BOOL UTL_LimitDouble( double *pdbl, double min, double max );


/***************************************************************************/
CPROT DLLIMPEX char *UTL_UnitCodeToString( int unit_code, BOOL fMustBeUnique );
CPROT DLLIMPEX int UTL_ParseUnitString( char **ppszUnitString, double *pdblTechPrefixFactor );

CPROT DLLIMPEX BOOL UTL_AreStringsEqualWidhWildcard( char *pszString, char *pszRefWithWildcards );

/***************************************************************************/
CPROT DLLIMPEX void UTL_FloatToFixedLengthString( double dblValue, char *pszDest, int iNrOfChars );
   // Converts a floating-point number into a string,
   // with the best possible resolution for a given string length.
   // Something the lousy "sprintf"-function cannot do ! ?!


/***************************************************************************/
CPROT DLLIMPEX int UTL_FloatToTechNotation(
          char *pszDest,             // destination string
          int iMaxLen,               // max length of destination
          int iOptionsAndNrOfDigits, // how many DIGITS (+ flags)
          int iScaleUnit,            // SCALE_UNIT_xxxx
          double dblValue );         // floating point value to be formatted
CPROT int UTL_FloatToTechNotation2(
          char *pszDest,             // destination string
          int iMaxLen,               // max length of destination
          int iOptionsAndNrOfDigits, // how many DIGITS (+ flags)
          char *pszUnit,             // "V", "A", "Samples", ....
          double dblValue );         // floating point value to be formatted
   // "Formats" a floating-point value into a TECHNICAL NOTATION,
   //  with exponents like p(ico) .. k(ilo) .. M(ega) plus physical UNIT .
   // Return value:
   //     NEGATIVE: error
   //     POSITIVE: success, returns the length of the generated string.



/***************************************************************************/
CPROT DLLIMPEX char *UTL_LastApiErrorCodeToString( DWORD dwLastError );
  // Converts a windoze API error code (as returned by GetLastError() )
  // into a string. Also removes the CR/NL-nonsense which WINDOZE likes to append.
  // Returns a pointer to a STATIC string which is only valid
  // until the next call of this function !


/***************************************************************************/
CPROT DLLIMPEX double UTL_ConvertYMDhmsToUnix( int year, int month, int day,
                                      int hour, int minute, double dblSecond );
  // Converts a date into the UNIX format, which is explained below.
  // This is be a better replacement for the "mktime" function.
  //      NO lousy global variables like "_timezone" and "_daylight" are used.
  //      We always use UTC (~GMT) here, and double values are much better
  //      in the year 2038 (when programs using the old "mktime" will fail).
  //  Input parameters: full year (like 2001),
  //                    month: 1..12, day: 1..31,
  //                    hour: 0..23, minute: 0..59, second: 0..59 .
  //  Return:  UNIX-Format = SECONDS elapsed since January 1st, 1970, 00:00:00 .
  //  Example: 22.10.2001, 11:12:13  returns 1003749133 UNIX-SECONDS.
  //          (DD.MM.YYYY, hh:mm:ss)

/***************************************************************************/
CPROT DLLIMPEX void UTL_SplitUnixDateTimeToYMDhms( double dblUnixDateTime,
         int *piYear, int *piMonth, int *piDay,   // << outputs ..
         int *piHour, int *piMinute, double *pdblSecond );
  // More or less the inverse function to UTL_ConvertYMDhmsToUnix() .


/***************************************************************************/
CPROT DLLIMPEX void UTL_FormatDateAndTime( char *format, double dblUnixDateTime, char *dest);
  // Example for format:  "DD.MMM YYYY hh:mm:ss"
  //           ->result:  "01.May 2001 14:28:02"  (placed in dest)


/***************************************************************************/
CPROT DLLIMPEX BOOL UTL_ParseFormattedDateAndTime(BYTE *format, double *pdblDateTime,
                                   BYTE **ppSource );
  // Example for format:  "DD.MMM YYYY hh:mm:ss"
  //          &  source:  "01.May 2001 14:28:02"
  // The returned value is similar to the UNIX time:
  //         "SECONDS elapsed since January 1st, 1970, 00:00:00" .


/***************************************************************************/
CPROT DLLIMPEX void UTL_SkipToEndOfString( char **ppszSource );  // [in,out] sourcecode pointer
CPROT DLLIMPEX int  UTL_SkipToEndOfLine( char **ppszSource, char *cpEndstop );


/***************************************************************************/
CPROT DLLIMPEX BOOL UTL_CheckAndSkipToken(BYTE **ppbSource, char *pszToken);

/***************************************************************************/
CPROT DLLIMPEX long UTL_ParseInteger(BYTE **ppbSource, int ndigits);

/***************************************************************************/
CPROT DLLIMPEX char UTL_SkipSpaces(BYTE **ppbSource); // returns the next NON-WHITESPACE character

/***************************************************************************/
CPROT DLLIMPEX int  UTL_CopyStringUntilEOL( BYTE *pbSource, char *pszDest, int iMaxDestLen );

/***************************************************************************/
CPROT DLLIMPEX char *UTL_StringToTime( char *cp,  double dblDefaultTime,
                        double *pdblDestTime,
                        char date_separator, char time_separator  );
   /* The time is always a value in SECONDS !
    * Return value: pointer to the character FOLLOWING the time-expression.
    */


/***************************************************************************/
CPROT DLLIMPEX double UTL_VgainToDecibel(double voltage_factor);
   /* Safe conversion from a voltage factor into decibels.
    */

/***************************************************************************/
CPROT DLLIMPEX double UTL_DecibelToVgain(double decibels);
   /* Safe conversion from "decibels" into a voltage gain FACTOR.
    */

/***************************************************************************/
CPROT DLLIMPEX double UTL_dBFS_to_other_dB_Offset( int iToScaleUnit );
  // Returns an OFFSET which must be added
  //    to turn a "decibel-FULL-SCALE"-value
  //    into "some other kind of dB" .



/***************************************************************************/
CPROT DLLIMPEX double UTL_AnyAmplitudeToNormalizedV(
          double dblAnyAmplitude,    // input value (to be converted)
             int iFromScaleUnit) ;   // unit of input value, SCALE_UNIT_xxxxx
   // Converts "any possible amplitude/magnitude value" into a VOLTAGE .
   // Caution, uses some ugly global variables as invisible parameters
   //  ( UTL_dblAdcMaxInputVoltage   and   UTL_dblAdcInputImpedance ) !

/***************************************************************************/
CPROT DLLIMPEX double UTL_NormalizedVToAnyAmplitude(
          double dblVoltage,       // input value (VOLTAGE to be converted)
             int iToScaleUnit );   // unit of input value, SCALE_UNIT_xxxxx
   // Converts a NORMALIZED VOLTAGE into "any possible amplitude/magnitude value" .
   // Caution, uses some ugly global variables as invisible parameters
   //  ( UTL_dblAdcMaxInputVoltage   and   UTL_dblAdcInputImpedance ) !

/***************************************************************************/
CPROT DLLIMPEX double UTL_ConvertAmplitudeUnit( double dblAmplitudeInAnyUnit,
             int iFromUnit, int iToUnit );


/***************************************************************************/
void DLLIMPEX UTL_ConvertNormalizedVsToOtherUnits(
              int iToScaleUnit,    // desired output unit ( SCALE_UNIT_xxxxx )
              int iCountOfFloats,  // how many 'floating point values' (not necessarily "number of FFT bins")
              T_Float *pfltSrc,    // pointer to INPUT array
              T_Float *pfltDst );  // pointer to OUTPUT array (may be the same as the input array ! )


/***************************************************************************/
double DLLIMPEX UTL_ConvertAnyAmplitudeToNormalizedPower( double dblAnyAmplitude, int iFromScaleUnit );
double DLLIMPEX UTL_ConvertNormalizedPowerToAnyAmplitude( double dblPowerOrEnergy, int iToScaleUnit );


/***************************************************************************/
CPROT DLLIMPEX long UTL_GetBlockChecksum(void *pBlock, int iBlockSize);
  // Often used to check if the contents of a STRUCTURE have been changed.
  // Not 100% foolproof but fast.


#endif // _UTILITY1_H_

/* EOF <utility1.h>  .  Note that GNU C / GCC needs an empty line after this ! */

