/***************************************************************************/
/*  Sound Reveiver/Analyzer Thread #1:                                     */
/*   - Receives continuous input from the soundcard                        */
/*       and processes the sound samples   somehow ...                     */
/*   - requires "SOUND.CPP" ( CSound class )                               */
/*   - by DL4YHF   June 2000  -  April 2001                                */
/*   - VCL dependencies removed in May 2002 to keep the code compact (!)   */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef SoundThdH
#define SoundThdH

//---------------------------------------------------------------------------
#ifdef __BORLANDC__
 #include <Classes.hpp>
#endif
//---------------------------------------------------------------------------

/* manually included INCLUDES here: */


#include "Sound.h"       // Soundcard access helper
#include "ErrorCodes.h"
#include "SoundDec.h"    // Decimating buffer and a few tables, etc

// some CONSTANTS ...
#ifndef  PI
 #define PI 3.14159265358979323846
#endif


// Size of data chunks to process at a time from the soundcard (for ANALYZER)
// ex #define SOUND_MAX_CHUNK_SIZE 4096
// 2020-12: For today's high sampling rates like 96000 or 192000 Hz,
//      allowing chunk sizes of up to 65536, to buffer up to 500 ms of audio.
// Examples:
//  44100 samples/second -> iChunkSize = 4096 samples;
//          so one block of samples contains only 92 milliseconds of audio .
//  96000 samples/second, 500 milliseconds per chunk -> iChunkSize = 65536 .
// 192000 samples/second, 200 ms per chunk -> also 65536 samples per chunk .
#ifndef  SOUND_MAX_CHUNK_SIZE
# define SOUND_MAX_CHUNK_SIZE 65536
#endif


// Possible "connections" for SAVED samples:
#define SOUND_SAVE_OFF        0 // do NOT save anything
#define SOUND_SAVE_INPUT      1 // save INPUT samples
#define SOUND_SAVE_OUTPUT     2 // save OUTPUT samples
#define SOUND_SAVE_IQ_SAMPLES 3 // save decimated I/Q samples from FFT input

// states of the 'sound save buffers' (see T_SOUND_SAVE_BUFFER)
#define SOUND_SAVEBUF_EMPTY   0 // signal from main application to sound thread
#define SOUND_SAVEBUF_FILLING 1
#define SOUND_SAVEBUF_FILLED  2 // signal from sound thread to main application


#ifndef  K_PI
 #define K_PI  (3.1415926535897932384626)
#endif


/*----------------------- Data Types --------------------------------------*/



/*--------------- Declaration of the Sound Analyzer Thread ----------------*/




//---------------------------------------------------------------------------


/*----------------------- Variables  --------------------------------------*/
#undef EXTERN
#ifdef _I_AM_SOUND_THREAD_
 #define EXTERN
#else
 #define EXTERN extern
#endif

extern int SOUND_InstanceNr;  // Instance counter.  Possible values:
             // 0 = "I am the FIRST instance and most likely a SERVER"
             // 1 = "I am the SECOND instance and most likely a CLIENT"
             // 2 = "I am the THIRD or any other instance" (which is bad!)
             // Some of SpecLab's child windows use this information
             //  to change their window title accordingly, therefore GLOBAL.
             //  The instance number is detected somewhere during
             //  the initialization of the main form (using a MUTEX).

EXTERN BOOL SOUND_exited_from_thread_loop;


extern double SOUND_dblAudioPeakValue;


// A large "decimating" buffer where the samples from the soundcard are stored
extern CSoundDecimatingBuffer DecimatingAudioBuffer;


/*-----------------------------------------------------------------------*/


/* debugging stuff.  WARNING: Modified in a thread, be carefull--   */
EXTERN int SOUND_iErrorCode;



/*--------------- Old-fashioned "C"-style prototypes :-) ------------------*/


/***************************************************************************/
void SOUND_SetDefaultParameters(void);
  // Prepare some soundcard settings (WAVEFORMATEX) required later.
  // Note: some of these settings may be overridden by the command line parser.


/***************************************************************************/
void SOUND_TerminateAll(void);

/***************************************************************************/
char *SOUND_ErrorCodeToString(int error_code );

/***************************************************************************/
BOOL SoundThd_LaunchWorkerThread(void);

/***************************************************************************/
BOOL SoundThd_TerminateAndDeleteThread(void);




#endif // #ifndef SoundThdH
