/***************************************************************************/
/*  Sound Output Thread #1:                                                */
/*   - Sends samples to the soundcard                                      */
/*       (with a bit of optional "output processing" )                     */
/*   - requires "SOUND.CPP" ( CSound class )                               */
/*   - by DL4YHF   June 2000  -  April 2001                                */
/*   - VCL dependencies removed in May 2002 to keep the code compact (!)   */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef SndOutThdH
#define SndOutThdH

//---------------------------------------------------------------------------
#ifdef __BORLANDC__
  #include <Classes.hpp>
#endif
//---------------------------------------------------------------------------

/* manually included INCLUDES here: */


#include "Sound.h"       // Soundcard access helper
#include "ErrorCodes.h"
//#include "SoundDec.h"    // Decimating buffer and a few tables, etc
#include "SoundUps.h"    // Upsampling buffer

// some CONSTANTS ...
#ifndef  PI
 #define PI 3.14159265358979323846
#endif

// Size of data chunks to process at a time from the soundcard (for ANALYZER)
// ex #define SOUND_MAX_CHUNK_SIZE 4096
// 2020-12: For today's high sampling rates like 96000 or 192000 Hz,
//      allowing chunk sizes of up to 65536, to buffer up to 500 ms of audio.
// Examples:
//  44100 samples/second -> iChunkSize = 4096 samples;
//          so one block of samples contains only 92 milliseconds of audio .
//  96000 samples/second, 500 milliseconds per chunk -> iChunkSize = 65536 .
// 192000 samples/second, 200 ms per chunk -> also 65536 samples per chunk .
#define SOUND_MAX_CHUNK_SIZE 65536

#ifndef  K_PI
 #define K_PI  (3.1415926535897932384626)
#endif


/*----------------------- Data Types --------------------------------------*/



/*--------------- Declaration of the Sound Output Thread ------------------*/




//---------------------------------------------------------------------------


/*----------------------- Variables  --------------------------------------*/
#undef EXTERN
#ifdef _I_AM_SOUND_THREAD_
 #define EXTERN
#else
 #define EXTERN extern
#endif

extern int SOUND_InstanceNr;  // Instance counter.  Possible values:
             // 0 = "I am the FIRST instance and most likely a SERVER"
             // 1 = "I am the SECOND instance and most likely a CLIENT"
             // 2 = "I am the THIRD or any other instance" (which is bad!)
             // Some of SpecLab's child windows use this information
             //  to change their window title accordingly, therefore GLOBAL.
             //  The instance number is detected somewhere during
             //  the initialization of the main form (using a MUTEX).

EXTERN BOOL SOUND_exited_from_thread_loop;

extern long   SOUND_lOutThreadLoops;   // for debugging purposes only !


extern T_Float SOUND_fltGainFactor;
extern T_Float SOUND_fltAudioPeakValue[2];
extern T_Float SOUND_fltTestGeneratorFreq;


// An instance of the CSound class to access the soundcards...
extern CSound SoundDev;


// A large "upsampling" buffer where the samples for the soundcard are taken from
extern CSoundUpsamplingBuffer UpsamplingAudioBuffer;
extern LONGLONG SOUND_i64SamplePairIndex;  // COUNTER and BUFFER INDEX for this reader of audio samples

extern char g_sz255DeviceName[256];  // e.g. "-1" = 'standard audio device' in bad old Windows tradition

// input- and output device settings :
extern WAVEFORMATEX SOUND_WFXSettings;


// Some parameters which may be 'overwritten' by command line arguments.
//  Therefore, the names are common for several modules like SndInThd, SerInThd, etc.
extern int     SOUND_iNrOfAudioChannels;
extern T_Float SOUND_fltGainFactor;
extern int     SOUND_iUseSignedValues;
extern long    SOUND_lDecimationRatio;
extern int     SOUND_fComplexOutput;     // 0=real, 1=complex output
extern T_Float SOUND_fltCenterFrequency;
extern int     SOUND_iDcReject;
extern int     SndThd_iConnectMeterToOutput;

extern int SndThd_iChunkSize; // size of a processing 'chunk' [Samples]


/*-----------------------------------------------------------------------*/


/* debugging stuff.  WARNING: Modified in a thread, be carefull--   */
EXTERN int SOUND_iErrorCode;



/*--------------- Old-fashioned "C"-style prototypes :-) ------------------*/


/***************************************************************************/
void SOUND_SetDefaultParameters(void);
  // Prepare some soundcard settings (WAVEFORMATEX) required later.
  // Note: some of these settings may be overridden by the command line parser.


/***************************************************************************/
void SOUND_TerminateAll(void);

/***************************************************************************/
BOOL SoundThd_LaunchWorkerThread(void);

/***************************************************************************/
BOOL SoundThd_TerminateAndDeleteThread(void);




#endif // #ifndef SndOutThdH
