//---------------------------------------------------------------------------
// File  :  SndInMain.h
// Date  :  2002-05-04   (yyyy-mm-dd)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//     Implementation of the Main Window in a non-VCL application.
//
// Revision history :  See *.cpp
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef SndOutMainH
#define SndOutMainH
//---------------------------------------------------------------------------

#define C_MyIniFile "SndOutpt.ini"   /* raw name of *.ini-file with session data */

#define MY_BACKGROUND_COLOR COLOR_BTNFACE

#define CTRL_ID_BTN_RUN  1 // Control-ID for the 'Run'-button, etc
#define CTRL_ID_BTN_HELP 2
#define CTRL_ID_BTN_GAIN 3
#define CTRL_ID_BTN_QUIT 4


//------- Global 'application' variables -----------------------------------
extern char * APPL_szWindowName;    // like "API_DEMO"
extern char * APPL_szWindowCaption; // like "Non-VCL Application Skeleton"
extern int APPL_iWinCmdShow;  // second argument for ShowWindow() in WinMain()

extern HINSTANCE APPL_hInstance; // handle to current instance, set in WinMain()
extern HWND APPL_hMainWindow;    // handle of the main window, set in WinMain()
extern char APPL_sz255CmdLine[256];   // copy of command line passed to WinMain()
extern char APPL_sz255MyIniFile[256]; // INI-File with full path specification (!)


//------- functions called by the application skeleton, always needed ------
BOOL CheckBeforeWndCreation(void);
   // Called by the application skeleton BEFORE any window is created.
   // May be used to detect if another instance is already running.
   // Return value (evaluated somewhere in WinMain() ):
   //    FALSE = exit program, don't create a window, don't call OnWmCreate
   //    TRUE  = let me run, create the main window, then call OnWmCreate

LONG OnWmPaint(HWND hWnd);                          // called on WM_PAINT
LONG OnWmCreate(HWND hWnd, LPCREATESTRUCT lpcs);    // called on WM_CREATE
void OnWmClose(HWND hWnd);                          // called on WM_CLOSE
LONG OnWmCommand(HWND hWnd,                         // called on WM_COMMAND
           WORD wNotifyCode, // notification code
           WORD wID        , // item, control, or accelerator identifier
           HWND hwndCtl );   // handle of control


//------- functions called by the application skeleton, optional -----------
void OnWmTimer(HWND hWnd, WORD wTimerID ); // called on WM_TIMER
LONG OnWmCopydata(HWND hMyWnd, HWND hSendingWnd, COPYDATASTRUCT *pCds ); // called on WM_COPYDATA

#endif // SndOutMainH
