//---------------------------------------------------------------------------
// File  :  c:\cbproj\SoundUtl\SndInput.cpp (ex: ApplMain.cpp)
// Date  :  2020-09-26     (YYYY-MM-DD)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//     Red tape and message handler for a non-VCL Windoze application.
//
// Revision history (YYYY-MM-DD):
//   2020-09-26  Made the window a bit larger because under Windows 8 / 10,
//               some of the text was now hidden below the buttons .
//               Most of those 'cosmetic' corrections are in SndInput.cpp .
//
//   2004-06-13  Integrated the "Audio-Message-Sender" (AudioSnd) in project
//               "SoundInput", which allows to send a stream of audio samples
//               to other applications through WM_COPYDATA messages.
//
//   2002-05-04  Used in the "Audio Input Tool" in c:\CBProj\SndInput\.
//               File renamed from ApplMain to SndInput .
//
//   2002-05-03  Started as a simple application skeleton,
//               some sample code from community.borland.com was used here.
//               Original directory: c:\CBproj\NoVcl\MainWnd.cpp
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
#ifdef __BORLANDC__  /* Borland-specific stuff: */
 #include <vcl.h>
#endif
#include <windows.h>
#pragma hdrstop

#include "yhf_type.h"   // C:\CBproj\YHF_Tools\yhf_type.h (everything else is a COPY)
#include "SndInMain.h"
#include "goodies.h"


//---------------------------------------------------------------------------
#ifdef __BORLANDC__  /* Borland-specific stuff: */
#endif // __BORLANDC__

//---------------------------------------------------------------------------
HINSTANCE APPL_hInstance= 0; // handle to current instance, set in WinMain()

HWND APPL_hMainWindow = 0;  // handle of the main window, set in WinMain()

int APPL_iWinCmdShow=SW_SHOW; // second argument for ShowWindow() in WinMain()
                              // (may be overridden by the application !)

char APPL_sz255CmdLine[256];   // command line, may be evaluated by application
char APPL_sz255MyIniFile[256]; // INI-File with full path specification (!)
#if( SWI_ASIO_SUPPORTED )
 BOOL APPL_fMayUseASIO=FALSE; // ASIO may be enabled/disabled via command line switch .
#endif // SWI_ASIO_SUPPORTED ?

extern LRESULT CALLBACK _export WndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam);


/*==============================================================================
       WinMain
==============================================================================*/
int WINAPI WinMain( HINSTANCE hInstance,     // handle to current instance
                    HINSTANCE hPrevInstance, // handle to previous instance
                    LPSTR lpCmdLine,         // pointer to command line
                    int nCmdShow  )          // show state of window
{
  MSG      msg ;
  WNDCLASS wndclass ;

  // save instance for creation of controls & child windows later
  APPL_hInstance=hInstance;

  // save command line for later
  strncpy(APPL_sz255CmdLine, lpCmdLine, 255);
  APPL_sz255CmdLine[255] = '\0';

  // Make a full path for the INI file because we don't want it to be placed
  // in some goddamn windoze system directory !
  ExpandFilenameToFullPath( C_MyIniFile, APPL_sz255MyIniFile, 255/*iMaxLen*/);

  // Let the "application" decide if it's ok to create the main window,
  //  or if it wants to terminate immediately (possibly because another
  //  instance is already running, etc).
  if( ! CheckBeforeWndCreation() )
   {
     // from Win32 programmer's reference:
     //  > If the function terminates before entering the message loop,
     //  > it should return 0.
     return 0;
   }

  // set up window
  wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
  wndclass.lpfnWndProc   = WndProc ;
  wndclass.cbClsExtra    = 0 ;
  wndclass.cbWndExtra    = 0 ;
  wndclass.hInstance     = hInstance ;
  wndclass.hIcon         = NULL;
  wndclass.hIcon         = LoadIcon(hInstance,TEXT("PROGRAM_ICON"));
  wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH)(MY_BACKGROUND_COLOR+1); // don't ask what the "+1" is for !
  wndclass.lpszMenuName  = NULL ;
  wndclass.lpszClassName = APPL_szWindowName; // window name
  RegisterClass (&wndclass) ;

  // now create main window
  HWND hWnd = CreateWindow(
    APPL_szWindowName,    // lpClassName,    pointer to registered class name
    APPL_szWindowCaption, // "lpWindowName", pointer to window name, effectively the TITLE
    // DWORD dwStyle,        window style. Tried a lot ...
       WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_OVERLAPPED,  // normal window
    // WS_POPUP | WS_DLGFRAME ,   // window with no title, quite unusual as main window
    // WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_SIZEBOX, // sizeable
    // WS_CAPTION,   // with title, but no icon and no system menu nor close symbol
    ReadIntegerFromIniFile( APPL_sz255MyIniFile, "MainWin", "x", 10/*default*/ ),  // int x
    ReadIntegerFromIniFile( APPL_sz255MyIniFile, "MainWin", "y", 10/*default*/ ),  // int y
    260,            // int nWidth , window width    ( before 2022-10-17 : 220 pixels; before 2020-09-26 : 210 pixels )
    150,            // int nHeight,   window height ( before 2022-10-17 : 150 pixels; before 2020-09-26 : 140 pixels )
    NULL,            // HWND hWndParent, handle to parent or owner window
    NULL,            // HMENU hMenu,     handle to menu or child-window identifier
    hInstance,       // HANDLE hInstance, handle to application instance
    NULL);           // LPVOID lpParam,   pointer to window-creation data
  // As usual as in the obfuscated stoneage "direct Win32 programming",
  // the main window creates various "children" in the handler for the
  // WM_CREATE message. This is incredibly ugly, so the author decided
  // to pack all that stuff into a separate module - see for example
  // c:\cbproj\SoundUtl\SndInMain.cpp : OnWmCreate() .

  APPL_hMainWindow = hWnd;   // save handle of main window in case someone needs it ;-)

  // Display initial window
  // normal state: ShowWindow( hWnd, SW_SHOW ) ;
  ShowWindow( hWnd, APPL_iWinCmdShow );

  // Main loop: process messages
  while (GetMessage(&msg,NULL,0,0))
  {
    TranslateMessage(&msg) ;
    DispatchMessage(&msg) ;
  }
  return msg.wParam;
} // end WinMain()
//------------------------------------------------------------------------

