//---------------------------------------------------------------------------
// File  :  SndInMain.h
// Date  :  2002-05-04   (yyyy-mm-dd)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//     Implementation of the Main Window in a non-VCL application.
//
// Revision history :  See *.cpp
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef SndInMainH
#define SndInMainH
//---------------------------------------------------------------------------

#define C_MyIniFile "SndInput.ini"   /* raw name of *.ini-file with session data */

#define APPL_NEEDS_WM_TIMER    1   // 1= need the WM_TIMER message
#define APPL_NEEDS_WM_COPYDATA 1   // 1= need the WM_COPYDATA message

#define MY_BACKGROUND_COLOR COLOR_BTNFACE

#define CTRL_ID_BTN_RUN  1 // Control-ID for the 'Run'-button, etc
#define CTRL_ID_BTN_HELP 2 // [in] iControlID
#define CTRL_ID_BTN_GAIN 3 // [in] iControlID
#define CTRL_ID_BTN_QUIT 4 // [in] iControlID


//------- Global 'application' variables -----------------------------------
extern char * APPL_szWindowName;    // like "SND_INPUT" or "SER_INPUT"
extern char * APPL_szWindowCaption; // like "SndInput" or "SerInput" (the 'text in the title bar').
                                    // Since Microsoft changed the rules (or the font sizes) again,
                                    // "Sound Input" was severely truncated on the screen
                                    // (only "Sound.." remained), so the names defined in
                                    // SndInMain.cpp have been modified in 2022-10-17 .

extern int APPL_iWinCmdShow;  // second argument for ShowWindow() in WinMain()
                              // (may be overridden by the application !)
extern HINSTANCE APPL_hInstance; // handle to current instance, set in WinMain()
                                 // Located in ApplMain.cpp !
extern HWND APPL_hMainWindow;    // handle of the main window, set in WinMain()
                                 // Located in ApplMain.cpp !
extern char APPL_sz255CmdLine[256];   // copy of command line passed to WinMain()
extern char APPL_sz255MyIniFile[256]; // INI-File with full path specification (!)

//------- functions called by the application skeleton, always needed ------
BOOL CheckBeforeWndCreation(void);
   // Called by the application skeleton BEFORE any window is created.
   // May be used to detect if another instance is already running.
   // Return value (evaluated somewhere in WinMain() ):
   //    FALSE = exit program, don't create a window, don't call OnWmCreate
   //    TRUE  = let me run, create the main window, then call OnWmCreate

LONG OnWmCreate(HWND hWnd, LPCREATESTRUCT lpcs);    // called on WM_CREATE
LONG OnWmPaint(HWND hWnd);                          // called on WM_PAINT
void OnWmClose(HWND hWnd);                          // called on WM_CLOSE
LONG OnWmCommand(HWND hWnd,                         // called on WM_COMMAND
           WORD wNotifyCode, // notification code
           WORD wID        , // item, control, or accelerator identifier
           HWND hwndCtl );   // handle of control


//------- functions called by the application skeleton, optional -----------

#if(APPL_NEEDS_WM_TIMER)
 void OnWmTimer(HWND hWnd, WORD wTimerID ); // called on WM_TIMER
#endif // APPL_NEEDS_WM_TIMER

#if(APPL_NEEDS_WM_COPYDATA)
 LONG OnWmCopydata(HWND hMyWnd, HWND hSendingWnd, COPYDATASTRUCT *pCds ); // called on WM_COPYDATA
#endif // APPL_NEEDS_WM_COPYDATA


#endif
