//---------------------------------------------------------------------------
// File  :  SerInput.cpp (ex: ApplMain.cpp)
// Date  :  2002-05-04   (yyyy-mm-dd)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//     Red tape and message handler for a non-VCL Windoze application.
//     SerInput.cpp = Serial Input
//
// Revision history (yyyy-mm-dd):
//   2002-05-03  Started as a simple application skeleton,
//               some sample code from community.borland.com was used here.
//               Original directory: c:\CBproj\NoVcl\MainWnd.cpp
//   2002-05-04  Used in the "Audio Input Tool" in c:\CBProj\SndInput\.
//               File renamed from ApplMain to SndInput .
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SndInMain.h"
#include "goodies.h"

//---------------------------------------------------------------------------
USEUNIT("SndInMain.cpp");
USEUNIT("Sound.cpp");
USEUNIT("SoundDec.cpp");
USEUNIT("AudioWrt.cpp");
USEUNIT("Goodies.cpp");
USEUNIT("ErrorCodes.cpp");
USEUNIT("SoundTab.cpp");
USEFILE("..\YHF_Tools\yhf_type.h");
USEUNIT("SerInThd.cpp");
USERC("SerInput.rc");
USEUNIT("AudioMsgHdlr.cpp");
//---------------------------------------------------------------------------
HINSTANCE APPL_hInstance= 0; // handle to current instance, set in WinMain()

HWND APPL_hWindow = 0;  // handle of the main window, set in WinMain()

int APPL_iWinCmdShow=SW_SHOW; // second argument for ShowWindow() in WinMain()
                              // (may be overridden by the application !)

char APPL_sz255CmdLine[256]; // command line, may be evaluated by application
char APPL_sz255MyIniFile[256]; // INI-File with full path specification (!)


/*==============================================================================
       WndProc
==============================================================================*/
LRESULT CALLBACK _export WndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam)
{
  switch (message)
  {
    case WM_CREATE: // sent when application requests that a window be created
      return OnWmCreate(hWnd, (LPCREATESTRUCT) lParam);
    case WM_PAINT:  // request to paint a portion of an application's window
      return OnWmPaint(hWnd);
    case WM_COMMAND: // handle button press etc etc etc
      return OnWmCommand(hWnd,
              HIWORD(wParam), // wNotifyCode: notification code
              LOWORD(wParam), // wID: item, control, or accelerator identifier
              (HWND) lParam); // hwndCtl:  handle of control
    case WM_CLOSE:
      OnWmClose(hWnd);
      DestroyWindow(hWnd); // perform wm_destroy
      return 0L;
    case WM_DESTROY:
      PostQuitMessage( 0 );
      return 0L;

    //-------------- optional message handlers ----------------------------
#if(APPL_NEEDS_WM_TIMER)
    case WM_TIMER:
      OnWmTimer(hWnd, (WORD)wParam/*wTimerID*/ ); // called on WM_TIMER
      return 0L;
#endif // APPL_NEEDS_WM_TIMER

#if(APPL_NEEDS_WM_COPYDATA)
    case WM_COPYDATA:
      return OnWmCopydata( hWnd,  // handle of THIS window
                   (HWND)wParam,  // handle of SENDING window
       (PCOPYDATASTRUCT)lParam);  // pointer to a COPYDATASTRUCT (read-only!)
#endif // APPL_NEEDS_WM_COPYDATA


  }
 return DefWindowProc (hWnd, message, wParam, lParam) ;
} // end WndProc()



/*==============================================================================
       WinMain
==============================================================================*/
int WINAPI WinMain( HINSTANCE hInstance,     // handle to current instance
                    HINSTANCE hPrevInstance, // handle to previous instance
                    LPSTR lpCmdLine,         // pointer to command line
                    int nCmdShow  )          // show state of window
{
  MSG      msg ;
  WNDCLASS wndclass ;

  // save instance for creation of controls & child windows later
  APPL_hInstance=hInstance;

  // save command line for later
  strncpy(APPL_sz255CmdLine, lpCmdLine, 255);
  APPL_sz255CmdLine[255] = '\0';

  // Make a full path for the INI file because we don't want it to be placed
  // in some goddamn windoze system directory !
  ExpandFilenameToFullPath( C_MyIniFile, APPL_sz255MyIniFile, 255/*iMaxLen*/);

  // Let the "application" decide if it's ok to create the main window,
  //  or if it wants to terminate immediately (possibly because another
  //  instance is already running, etc).
  if( ! CheckBeforeWndCreation() )
   {
     // from Win32 programmer's reference:
     //  > If the function terminates before entering the message loop,
     //  > it should return 0.
     return 0;
   }

  // set up window
  wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
  wndclass.lpfnWndProc   = WndProc ;
  wndclass.cbClsExtra    = 0 ;
  wndclass.cbWndExtra    = 0 ;
  wndclass.hInstance     = hInstance ;
  wndclass.hIcon         = NULL;
  wndclass.hIcon         = LoadIcon(hInstance,TEXT("PROGRAM_ICON"));
  wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH) COLOR_WINDOW;
  wndclass.lpszMenuName  = NULL ;
  wndclass.lpszClassName = APPL_szWindowName; // window name
  RegisterClass (&wndclass) ;

  // now create main window
  HWND hWnd = CreateWindow(
    APPL_szWindowName,    // lpClassName,    pointer to registered class name
    APPL_szWindowCaption, // "lpWindowName", pointer to window name, effectively the TITLE
    // DWORD dwStyle,        window style. Tried a lot ...
       WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_OVERLAPPED,  // normal window
    // WS_POPUP | WS_DLGFRAME ,   // window with no title, quite unusual as main window
    // WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_SIZEBOX, // sizeable
    // WS_CAPTION,   // with title, but no icon and no system menu nor close symbol
    ReadIntegerFromIniFile( APPL_sz255MyIniFile, "MainWin", "x", 10/*default*/ ),  // int x
    ReadIntegerFromIniFile( APPL_sz255MyIniFile, "MainWin", "y", 10/*default*/ ),  // int y
    210,            // int nWidth , window width
    140,            // int nHeight,   window height
    NULL,            // HWND hWndParent, handle to parent or owner window
    NULL,            // HMENU hMenu,     handle to menu or child-window identifier
    hInstance,       // HANDLE hInstance, handle to application instance
    NULL);           // LPVOID lpParam,   pointer to window-creation data

  APPL_hWindow = hWnd;   // save handle of main window in case someone needs it ;-)

  // Display initial window
  // normal state: ShowWindow( hWnd, SW_SHOW ) ;
  ShowWindow( hWnd, APPL_iWinCmdShow );

  // Main loop: process messages
  while (GetMessage(&msg,NULL,0,0))
  {
    TranslateMessage(&msg) ;
    DispatchMessage(&msg) ;
  }
  return msg.wParam;
} // end WinMain()
//------------------------------------------------------------------------

