/***************************************************************************/
/* SerInThd.cpp =  Sample-Stream Input Thread for the SERIAL interface.    */
/*   - Receives continuous input from the serial interface                 */
/*       and places the sound samples in two alternating buffers.          */
/*   - based on "SndInThd" which takes audio samples from the soundcard.   */
/*   - by DL4YHF,  October 2002                                            */
/*   - VCL dependencies removed in May 2002 to keep the code compact (!)   */
/*                                                                         */
/*  The audio data are produced by a simple hardware with a PIC micro-     */
/*  controller, with the "Serial A/D"-firmware.                            */
/*  The data format is described in the firmware project directory,        */
/*   look for the file    SerialAD\SerPicAD.txt (written by W.Buescher) .  */
/*                                                                         */
/*  More info: see *.cpp !                                                 */
/*                                                                         */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef SerInThdH
#define SerInThdH

//---------------------------------------------------------------------------
#include <Classes.hpp>
//---------------------------------------------------------------------------

/* manually included INCLUDES here: */


#include "ErrorCodes.h"
#include "SoundDec.h"    // Decimating buffer and a few tables, etc

// some CONSTANTS ...
#ifndef  PI
 #define PI 3.14159265358979323846
#endif


// Size of data chunks to process at a time from the soundcard (for ANALYZER)
// ex #define SOUND_MAX_CHUNK_SIZE 4096
// 2020-12: For today's high sampling rates like 96000 or 192000 Hz,
//      allowing chunk sizes of up to 65536, to buffer up to 500 ms of audio.
// Examples:
//  44100 samples/second -> iChunkSize = 4096 samples;
//          so one block of samples contains only 92 milliseconds of audio .
//  96000 samples/second, 500 milliseconds per chunk -> iChunkSize = 65536 .
// 192000 samples/second, 200 ms per chunk -> also 65536 samples per chunk .
#define SOUND_MAX_CHUNK_SIZE 65536


#ifndef  K_PI
 #define K_PI  (3.1415926535897932384626)
#endif


/*----------------------- Data Types --------------------------------------*/



/*--------------- Declaration of the Serial Audio Input Thread ------------*/




//---------------------------------------------------------------------------


/*----------------------- Variables  --------------------------------------*/
#undef EXTERN
#ifdef _I_AM_SER_IN_THREAD_
 #define EXTERN
#else
 #define EXTERN extern
#endif


EXTERN BOOL SerIn_exited_from_thread_loop;

extern T_Float SOUND_fltAudioPeakValue[2];

// A large "decimating" buffer where the samples from the soundcard are stored
extern CSoundDecimatingBuffer DecimatingAudioBuffer;

// Some parameters which may be 'overwritten' by command line arguments.
//  Therefore, the names are common for several modules like SndInThd, SerInThd, etc.
extern T_Float SOUND_fltTestGeneratorFreq;
extern int     SOUND_iNrOfAudioChannels;
extern T_Float SOUND_fltGainFactor;
extern int     SOUND_iUseSignedValues;
extern long    SOUND_lDecimationRatio;
extern int     SOUND_fComplexOutput;     // 0=real, 1=complex output
extern T_Float SOUND_fltCenterFrequency;
extern int    SOUND_iDcReject;
extern int SndThd_iConnectMeterToOutput; // 1=meter on output, 0=meter on input
extern int SndThd_iChunkSize; // size of a processing 'chunk' [Samples]

extern char   SOUND_sz80PortName[81];  // initialized with something like "COM2"

/*-----------------------------------------------------------------------*/


/* debugging stuff.  WARNING: Modified in a thread, be carefull--   */
EXTERN int SOUND_iErrorCode;

extern double SOUND_dblTestGeneratorFreq;

extern long   SerWin_lCountReceivedBytes;    // for debugging purposes.


/*--------------- Old-fashioned "C"-style prototypes :-) ------------------*/

/***************************************************************************/
void SOUND_SetDefaultParameters(void);
  // Prepare some soundcard settings (WAVEFORMATEX) required later.
  // Note: some of these settings may be overridden by the command line parser.

/***************************************************************************/
void SOUND_TerminateAll(void);

/***************************************************************************/
BOOL SoundThd_LaunchWorkerThread(void);

/***************************************************************************/
BOOL SoundThd_TerminateAndDeleteThread(void);




#endif // #ifndef SerInThdH
