/****************************************************************************/
/* \cbproj\yhf_tools\QConfig.c:  "Quick Configuration File" routines        */
/*                                                                          */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*    see   *.c                                                             */
/*        2006-03-23:  Added the "QFILE_SEEK_xxx"-macros in QFile.h .       */
/*        2007-04-25:  Modified QFile_ReadLine() to support DOS- and UNIX-  */
/*                     textfiles: DOS uses CR+LF, UNIX only LF as line end. */
/*        2007-07-08:  Fixed a bug in QFile_ReadLine(): CR-LF at buffer     */
/*                     boundaries caused reading an additional empty line.  */
/*                                                                          */
/****************************************************************************/

#ifndef _QCONFIG_H_
#ifndef _QFILE_H_
 #include "QFile.h"
#endif


//---------- Constants ------------------------------------------------------

// Possible values for 'oflags' in QFile_Open .  Must be compatible with fcntl.h !
// Declared here so other modules don't need to include dozens of headers .
#define QFILE_O_RDONLY    0
#define QFILE_O_WRONLY    1
#define QFILE_O_RDWR      2

#define QFILE_SEEK_SET  0  /* Positionierung vom Dateianfang aus */
#define QFILE_SEEK_CUR  1  /* Positionierung von der aktuellen Position aus */
#define QFILE_SEEK_END  2  /* Positionierung vom Dateiende aus */


//ex: #define QFILE_BUFFER_SIZE 2048  // must be a power of two !
#define QFILE_BUFFER_SIZE 65536 // must be a power of two !
                 // 2008-03-17 : increased QFILE_BUFFER_SIZE from 2048 to 65536,
                 // to see if this would speed up the analysis of very large wave files
                 // in Spectrum Lab.  Result:  CRASHED !
                 // Rebuilt the entire project -> works (stupid MAKE ? ),
                 //  but not faster than the original code with 2048-byte-buffer.

//---------- Data types (no C++ classes!) -----------------------------------
typedef struct // T_QFile (for "Quick file access")
{
  T_QFile qf;
} T_QConfig;


//------------ Prototypes -------------------------------------------------

#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* nicht "cplusplus" */

/***************************************************************************/
CPROT BOOL QCfg_Open( T_QConfig *qc, const char *filename, int iReadWriteMode );
  // Opens a configuration file, either for reading or writing.
  #define QCFG_OPEN_TO_READ  0
  #define QCFG_OPEN_TO_WRITE 1

/***************************************************************************/
CPROT void QCfg_Close( T_QConfig *qc );
  // Closes a configuration file.
  // Flushes all buffers if necessary.



#endif // _QCONFIG_H_
