//---------------------------------------------------------------------------
// File  :  \CBproj\SoundUtl\MovingAvrgFilter.cpp
// Date  :  2005-12-05  (YYYY-MM-DD)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//     Interface for the CMovingAvrgFilter class.
//
// Revision history :
//     2005-12-05   Created
//
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef MovingAvrgFilterH
#define MovingAvrgFilterH

#define NOISEBLANKER_USE_FFT  0  // FFT was too complicated and slow

#include "SoundTab.h"  // frequently used types and tables for audio processing




//----------------------- Constants ---------------------------------------



//----------------------- Data Types --------------------------------------




//***************************************************************************
//  Definition of the  CMovingAvrgFilter   class
//***************************************************************************

class CMovingAvrgFilter
{
public:
   CMovingAvrgFilter();            // constructor without parameters
   virtual ~CMovingAvrgFilter();   // destructor (cleans up)
   double ProcessSample( double dblInput, int iNumAverages );
   int    GetCurrNrAverages(void); // returns the number of averages already collected
   void   Clear(void);             // forget the history (restart averaging)   

private:
  double m_dblSum;     // current sum of <nSummands> summands
  int m_nSummands;     // current number of summands added in dblSum
  int m_iSubSummands,m_iSubSummandsMax; // number of summands in every entry in m_pdblOldValues[], usually ONE
  int m_iWantedNumAverages; // current setting for "wanted number of averages"
  double *m_pdblOldValues;  // 1-dimensional array for "old [input] values"
  int     m_iOldValueLength; // length of array m_pdblOldValues[0..m_iOldValueLength-1]
  int     m_iOldValueIndex;  // index into m_pdblOldValues[]

  void SetWantedNumAverages( int iNumAverages );

}; // end class CMovingAvrgFilter


#endif // MovingAvrgFilterH