/***************************************************************************/
/*  IQaudIO.h :                                                            */
/*   Unit to import and export *.AUD - files.                              */
/*   - by DL4YHF December 2004                                             */
/*   - originally used in VE2IQ's AFRICAM and LOOKSEE tools                */
/*     which is a specialized audio logging format with I/Q-samples        */
/*     as single or double precision floats,                               */
/*     separate files for I- and Q- channel .                              */
/*-------------------------------------------------------------------------*/

#ifndef IQaudIO_H
#define IQaudIO_H


#include "SoundUps.h"   // upsampling audio buffer with optional I/Q processor


#ifndef  SWI_FLOAT_PRECISION
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_Float double
#endif



/*----------- Constant Definitions ----------------------------------------*/




/*----------- Data Types --------------------------------------------------*/



/*----------- Definition of the C_IQaudIO  class -------------------------*/
class C_IQaudIO
{
public:
   C_IQaudIO();
   virtual ~C_IQaudIO();

   // Public member functions for object's users.
   /************************************************************************/
   BOOL InOpen(  char *pszFileName, char *pszAuxFileName,
         double dblFileSampleRate,
         double dblReadingSampleRate,
         int    iSizeOfDataType ); // 1=BYTEs, 2=short INTs, 4=floats, 8=double's
     /* Opens one or two AUD-file(s) for READING it's samples.
      * Returns TRUE on success and FALSE on any error.
      */


   /************************************************************************/
   LONG GetCurrentSampleIndex(void);
     /* Reads the current sample index that will be used on the next
      * READ- or WRITE- access to the audio samples in the opened file.
      * Returns a negative value on any error.
      */


   /************************************************************************/
   BOOL WindToSampleIndex(long new_sample_index);
     /* Sets the current sample index that will be used on the next
      * READ- or WRITE- access to the audio samples an opened file.
      * Returns TRUE if ok ,  otherwise FALSE.
      * As long as you don't use this routine/method,
      * the audio file will be played in a strictly "sequential" way.
      */

   /************************************************************************/
   LONG ReadSampleBlocks(
         int channel_nr,     // channel_nr for 1st destination block
         int nr_samples,     // nr_samples
         T_Float *pFltDest1,  // 1st destination block (~"LEFT")
         T_Float *pFltDest2); // 2nd destination block (~"RIGHT")
     /* Reads some samples from a wave file which has been opened for READING
      * and converts them to double (floats) in the range of +- 32768.0
      * Input parameters:
      *   channel_nr: 0=first channel (LEFT if stereo recording)
      *   nr_samples: Max number of samples which can be stored in T_Float dest[0..nr_samples-1]
      *   *dest: Pointer to destination array.
      * Returns the NUMBER OF AUDIO SAMPLES if successful,
      *         or a negative value if errors occurred.
      * Note that returning less samples than you may expect is not an error
      * but indicates reaching the file's end !
      */



   /************************************************************************/
   BOOL OutOpen( char *pszFileName,
               double dblFileSampleRate,
               double dblFeedingSampleRate,
               double dblNcoFrequency );
     /* Creates and Opens an audio file for WRITING audio samples.
      *         Returns TRUE on success and FALSE on any error.
      *         Detailed description of arguments in WaveIO.cpp only.
      */


   /************************************************************************/
   LONG WriteSamples( BYTE* pData, LONG Length );
     /* Writes some samples to a wave file which has been opened for WRITING.
      * Returns TRUE on success and FALSE on any error.
      * Note: "Length" is the size of the caller's buffer capacity in BYTES.
      *       The actual number of AUDIO SAMPLES will depend on the sample
      *       format. For 16-bit mono recordings, the number of samples
      *       will only be half the "Length" etc.
      */


   /************************************************************************/
   LONG GetCurrentFileSize(void);
     /* Returns the current file size (if there is an opened WAVE file).
      * Useful especially when logging audio samples  to keep track
      * of the used disk size (stop before Windows is getting into trouble).
      */

   /************************************************************************/
   // Some more 'Get' - and 'Set' - routines for the AUDIO FILE class ..
   int    GetFileFormat(void);
   void   GetFileName(char *pszDest, int iMaxLen);

   double GetSampleRate(void);
   void   SetSampleRate(double dblSampleRate);

   int    GetNrChannels(void);
   int    GetBitsPerSample(void);
   LONG   GetTotalCountOfSamples(void);

   double GetNcoFrequency(void);
   BOOL   SetNcoFrequency(double dblNcoFrequency);

   double GetCurrentRecordingTime(void); // .. depending on current sample index
   double GetRecordingStartTime(void);
   void   SetRecordingStartTime(double dblStartTime);

   bool   AllParamsIncluded(void);

   /************************************************************************/
   BOOL CloseFile( void );
     /* Closes the WAV-file (if opened for READING exor WRITING.
      * Returns TRUE on success and FALSE on any error.
      */


   // Public properties for simplicity .. we know what we're doing, right ?
   char   m_sz80ErrorString[84];
   BOOL   m_OpenedForReading;
   BOOL   m_OpenedForWriting;
   double m_dbl_NcoFrequency;

private:
   HANDLE m_hFile[2];        // [0]=main file,   [1]="aux" file
   LONG   m_lFilePos_Data;   // file-internal position of 1st audio sample
   LONG   m_lCurrFilePos;    // current file access position
   BOOL   m_fReachedEOF;
   LONG   m_lFileDataSize[2];
   char   m_sz255FileName[2][256];
   double m_dblFileSampleRate;
   WORD   m_wBytesPerSample;  // 1=BYTEs, 2=short INTs, 4=floats, 8=double's
   WORD   m_wNrOfChannels;
   double m_dblStartTime;     // seconds elapsed since 00:00:00 GMT, January 1, 1970.
   int    m_iFileFormat;

   CSoundUpsamplingBuffer UpsamplingAudioBuffer;


}; /* end class C_IQaudIO */


#endif // IQaudIO_H

/* EOF <IQaudIO.h> */
