//--------------------------------------------------------------------------
//  File:   c:\cbproj\SoundUtl\Goodies.h
//  Date:   2011-07-04
//  Author: Wolfgang Buescher (DL4YHF)
//
//  Purpose:
//    A few non-application specific routines (mostly windoze stuff)
//    for the SOUND INPUT and SOUND OUTPUT tool,
//    later also used in some Audio-I/O-DLLs for the configuration screen.
//
//--------------------------------------------------------------------------


// Turn 4 characters into a DOUBLEWORD (Intel byte order, LSB first) .
// Used for DL4YHF's WM_COPYDATA-handler:
//    ch0..ch2 describe the TYPE of a WM_COPYDATA message,
//    ch3 is the "struct version" whereever applicable .
#define FOUR_CHARS_TO_DW(ch0,ch1,ch2,ch3) ((DWORD)(ch0)|((DWORD)(ch1)<<8)|((DWORD)(ch2)<<16)|((DWORD)(ch3)<<24))



//----------------- Mother's little helpers ---------------------------------

#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
# ifdef __cplusplus
#   define CPROT extern "C"
# else
#   define CPROT
# endif  /* ! "cplusplus"  */
#endif  /* ! defined CPROT */

#ifndef  NO_ERRORS // obviously, the caller didn't #include SoundUtl\ErrorCodes.h ...
# define NO_ERRORS 0 // .. so define the only "error code dummy" used in Goodies.c
#endif


//---------------------------------------------------------------------------
CPROT int YearMonthDayToUnixDays( int year, int month, int day );
  // Converts a date (year, month, day) into the number of days since UNIX was born.
  //  Input parameters: full year (like 2001),
  //                    month: 1..12, day: 1..31 .
  //  Return:  "UNIX-days" = number of DAYS elapsed since January 1st, 1970 .

//---------------------------------------------------------------------------
CPROT void UnixDaysToYearMonthDay( long i32UnixDayNumber,
                         int *piYear, int *piMonth, int *piDay );

//---------------------------------------------------------------------------
CPROT void  SimpleTextOut(  HDC hDC,  // device context for output
                   char *pszOutput,   // text to be drawn
                   int x, int y);     // start position

//---------------------------------------------------------------------------
CPROT void RotatedTextOut(  HDC hDC,  // device context for output
                   char *pszFaceName, // typeface name string like "Arial"
                   int iFontHeight,   // font height
                   char *pszOutput,   // text to be drawn
                   int x, int y, // start position
                   int angle );  // rotation angle in degrees
   /* Writes a string on the canvas, rotated by any angle,
    *   starting at the point (X,Y).
    * Based on an example from the Win32 Programmer's Reference,
    *   look for "Rotating Lines of Text".
    */

//---------------------------------------------------------------------------
CPROT void DrawVerticalIndicatorBar( HDC hDC, // device context for output
              int iLeft, int iTop, int iRight, int iBottom, // drawing area
              COLORREF lIndicatorColor , // Color of the indicator (RGB-mix)
              COLORREF lBackgroundColor, // Color of the background (RGB-mix)
                 float fltPercentValue,  // value to be displayed [percent]
                     char *pszCaption ); // one or two letters like "L" or "R"


//---------------------------------------------------------------------------
CPROT int GetWindowHeight( HWND hWnd );

//---------------------------------------------------------------------------
CPROT int GetWindowWidth( HWND hWnd );

//---------------------------------------------------------------------------
CPROT int GetWindowPosX1( HWND hWnd );

//---------------------------------------------------------------------------
CPROT int GetWindowPosY1( HWND hWnd );

//---------------------------------------------------------------------------
CPROT HWND CreateStaticText(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
              int x, int y, int width, int height);

//---------------------------------------------------------------------------
CPROT HWND CreateEditField(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
              int x, int y, int width, int height);

//---------------------------------------------------------------------------
CPROT HWND CreateButton(HWND hWndParent, char *pszCaption, DWORD dwStyleOptions,
              int iControlID,  // user-defined CONSTANT (suitable for case-lists)
              int x, int y, int width, int height);

//---------------------------------------------------------------------------
CPROT HWND CreateComboBox(HWND hWndParent, char *pszText,
              DWORD dwStyleOptions, // CBS_DROPDOWNLIST or CBS_DROPDOWN
              int iControlID,  // user-defined CONSTANT (suitable for case-lists)
              int x, int y, int width, int height);

//---------------------------------------------------------------------------
CPROT int AddStringToComboBox(HWND hWndComboBox, char *pszItemText );

//-------------------------------------------------------------------------
CPROT void CheckMenuItemByIDAndCondition( HMENU hMenu, UINT  uIDItem, BOOL condition );

//-------------------------------------------------------------------------
CPROT BOOL PrintIntoMenuItem(
  // first 3 params like CheckMenuItem :
       HMENU hmenu,   // handle to menu
       UINT  uIDItem, // menu item to modify
       UINT  uFlags,  // menu item flags: MF_BYCOMMAND or MF_BYPOSITION
  // parameter 4,5 and following like "wsprintf" :
       char *pszFormat, ... ); // format string for wsprintf (no floats!)


//---------------------------------------------------------------------------
CPROT BOOL DoesFileExist( char *pszFileName );
  // quite similar to FileExists(), but no bloody VCL "AnsiString" type needed

//---------------------------------------------------------------------------
CPROT void GetFileNameFromSource(char **cppSource, char *cpDest, int iMaxLength);

//---------------------------------------------------------------------------
CPROT BOOL ExpandFilenameToFullPath(char *pszFilename, char *pszFullName, int iMaxLen);

/* Note on windoze-"INI-files": If you don't specify a full path,             */
/* your INI-file will be placed in some strange windoze-system-directory !    */
/* Use ExpandFilenameToFullPath() if you want the INI file in the current dir */


//---------------------------------------------------------------------------
CPROT void WriteStringToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, char *pszData);

//---------------------------------------------------------------------------
CPROT void WriteIntegerToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, long lData);

//---------------------------------------------------------------------------
CPROT void ReadStringFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                           char *pszDest, int iMaxLen, char *pszDefault);

//---------------------------------------------------------------------------
CPROT long ReadIntegerFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                            long lDefault);


//---------------------------------------------------------------------------
CPROT int StartExecutableWithCommandLine(char *pszCommandLine, int iShowHow );

