//--------------------------------------------------------------------------
//  Goodies.cpp : REPLACED BY c:\cbproj\SoundUtl\Goodies.c
//                so we can use the functionality in plain old "C" .
//                None of these function really needs C++ .
//
//  A few non-application specific routines (mostly windoze stuff)
//    for the SOUND INPUT and SOUND OUTPUT tool
//
//--------------------------------------------------------------------------

#include <windows.h>
#pragma hdrstop


#include "Goodies.h"   // prototypes for Mother's little helpers


extern HINSTANCE APPL_hInstance; // handle to current instance, set in WinMain()


//----------------- Mother's little helpers ---------------------------------


//---------------------------------------------------------------------------
void  RotatedTextOut(  HDC hDC,  // device context for output
                   char *pszFaceName, // typeface name string like "Arial"
                   int iFontHeight,   // font height
                   char *pszOutput,   // text to be drawn
                   int x, int y, // start position
                   int angle )   // rotation angle in degrees
   /* Writes a string on the canvas, rotated by any angle,
    *   starting at the point (X,Y).
    * Based on an example from the Win32 Programmer's Reference,
    *   look for "Rotating Lines of Text".
    */
{
  HFONT hfnt, hfntPrev;

  /* Allocate memory for a LOGFONT structure.                          */
  PLOGFONT plf = (PLOGFONT) LocalAlloc(LPTR, sizeof(LOGFONT));

  /* Specify a font typeface name, height and weight.                  */
  /* Take the most important text parameters from Borlands "Canvas".   */
  strcpy( plf->lfFaceName, pszFaceName );
  plf->lfHeight = iFontHeight;
  plf->lfWeight = FW_NORMAL;

  /* Draw the string, rotating by the indicated angle (in degrees)     */
  plf->lfEscapement = angle*10;
  hfnt = CreateFontIndirect(plf);
  hfntPrev = (HFONT)SelectObject(hDC, hfnt);
  TextOut(hDC, x, y, pszOutput, lstrlen(pszOutput) );
  SelectObject(hDC, hfntPrev);
  DeleteObject(hfnt);

  /* Free the memory allocated for the LOGFONT structure.              */
  LocalFree((LOCALHANDLE) plf);
}


//---------------------------------------------------------------------------
void  DrawVerticalIndicatorBar( HDC hDC, // device context for output
               int iLeft, int iTop, int iRight, int iBottom, // drawing area
               COLORREF lIndicatorColor, // Color of the indicator (RGB-mix)
               COLORREF lBackgroundColor, // Color of the background (RGB-mix)
                 float fltPercentValue, // value to be displayed [percent]
                     char *pszCaption )  // one or two letters like "L" or "R"
{
 RECT rect;
  char sz10[11];

  // Draw the "peak value indicator" at the right window edge...
  float d;
  int y;
  d = fltPercentValue;
  if(d<0)   d=0;
  if(d>100) d=100;
  d = (float)(iBottom - iTop - 4) * d / 100.0;
  y = iBottom - (int)d;
  if(y<iTop)
     y=iTop;
  if(y>iBottom)
     y=iBottom;
  rect.left = iLeft  + 2;
  rect.right= iRight - 2;
  rect.top  = iTop+4;
  rect.bottom= y-1;     // draw the UPPER PART (which is not covered) with the "background" color
  HBRUSH hMeterBrush  = CreateSolidBrush( lBackgroundColor );
    FillRect(hDC, &rect, hMeterBrush);
  DeleteObject(hMeterBrush);
  rect.top  = y;
  rect.bottom= iBottom; // draw the LOWER PART OF THE BAR with the "indicator"
  HBRUSH hBackgndBrush= CreateSolidBrush( lIndicatorColor );
    FillRect(hDC, &rect, hBackgndBrush);
  DeleteObject(hBackgndBrush);

  // Set the background mode to transparent for the text-output operation..
  int iOldBkMode = SetBkMode(hDC, TRANSPARENT);
  wsprintf(sz10,"%d %%", (int)fltPercentValue );
  RotatedTextOut(  hDC, "Arial", 12, // typeface name, font "height"
                             sz10,   // text to be drawn
              rect.left, iBottom-16, // x,y
                              90 );  // rotation angle in degrees
  if(pszCaption)
   { RotatedTextOut( hDC,"Arial",12, // typeface name, font "height"
                         pszCaption, // text to be drawn
            rect.left+2, iBottom-12, // x,y
                               0 );  // rotation angle in degrees
   }

  SetBkMode(hDC, iOldBkMode);


} // end DrawVerticalIndicatorBar()




//---------------------------------------------------------------------------
BOOL DoesFileExist( char *pszFileName )
{ // quite similar to FileExists(), but no bloody VCL "AnsiString" type needed
 BOOL fResult;
 HANDLE hFindHandle;
 WIN32_FIND_DATA FindFileData;


 if( (hFindHandle=FindFirstFile(
                    pszFileName,  // pointer to name of file to search for
                  &FindFileData)) // pointer to returned information
       != INVALID_HANDLE_VALUE)
   { // success in FindFirstFile does not mean the file is "suitable" for us...
     fResult =
          ((FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)==0)
       && ((FindFileData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN   )==0) ;
     FindClose(hFindHandle); // close file search handle
     return fResult;         // return only TRUE if its a "normal" data file.
   }
  else // FindFirstFile failed
     return FALSE;  // assume the file does not exist
} // end DoesFileExist()

//---------------------------------------------------------------------------
void GetFileNameFromSource(char **cppSource, char *cpDest, int iMaxLength)
{
  BYTE *cpSource = (BYTE*) *cppSource;
  if(*cpSource=='"')
   {   // argument enclosed in double quotes...
       // may be a filename with spaces (YUCC!) but some folks use them these days
     ++cpSource; // skip opening double quote
     while(*cpSource!='"' && *cpSource!='\0' && iMaxLength>0)
      { *cpDest++ = *cpSource++;
        --iMaxLength;
      }
     if(*cpSource=='"')
       ++cpSource; // skip closing double quote
   }
  else // argument not enclosed in double quotes...
   {
     while( (*cpSource > ' ') // can you guess why this is a BYTE pointer ? :-)
           && iMaxLength>0)
      { *cpDest++ = *cpSource++;
        --iMaxLength;
      }
   }

  *cpDest = '\0';                // terminate destination string
  *cppSource = (char*)cpSource;  // advance source pointer  to end of analyzed string

} // end GetFileNameFromSource()


//---------------------------------------------------------------------------
BOOL ExpandFilenameToFullPath(char *pszFilename, char *pszFullName, int iMaxLen)
{ // Proved to be very useful when working with INI-files...
 char *pszDummy;
  // The GetFullPathName function retrieves the full path
  // and filename of a specified file.
  return (0<GetFullPathName(
    pszFilename, // address of name of file to find path for
    iMaxLen,     // size, in characters, of path buffer
    pszFullName, // address of path buffer
    &pszDummy)); // address of filename in path
} // end ExpandFilenameToFullPath()


//**************************************************************************
// Routines to make low-level windoze programming a bit easier ...
//    .. or even more obscure ?)
// Most of these taken from DL4YHF's Complex Calculating Text Editor .
//**************************************************************************

//---------------------------------------------------------------------------
int GetWindowHeight( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  // The GetWindowRect function retrieves the dimensions of the bounding
  // rectangle of the specified window. The dimensions are given in screen
  // coordinates that are relative to the upper-left corner of the screen.
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.bottom - MyRect.top;
} // end GetWindowHeight()

//---------------------------------------------------------------------------
int GetWindowWidth( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )  // See GetWindowHeight() for details
     return 0;
  return MyRect.right - MyRect.left;
} // end GetWindowWidth()

//---------------------------------------------------------------------------
int GetWindowPosX1( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.left;
} // end GetWindowPosX1()

//---------------------------------------------------------------------------
int GetWindowPosY1( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.top;
} // end GetWindowPosY1()



//---------------------------------------------------------------------------
HWND CreateStaticText(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create "static text" through Win API..
        "static",          // LPCTSTR lpClassName
        pszText,           // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        0,                 // HMENU hMenu
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateStaticText()

//---------------------------------------------------------------------------
HWND CreateEditField(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create a simple edit field..
        "edit",            // LPCTSTR lpClassName
        pszText,           // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        0,                 // HMENU hMenu
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateEditField()

//---------------------------------------------------------------------------
HWND CreateButton(HWND hWndParent, char *pszCaption, DWORD dwStyleOptions,
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create a simple edit field..
        "button",          // LPCTSTR lpClassName
        pszCaption,        // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        0,                 // HMENU hMenu
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateButton()


//-------------------------------------------------------------------------
BOOL PrintIntoMenuItem(
  // first 3 params like CheckMenuItem :
                HMENU hmenu,   // handle to menu
                UINT  uIDItem, // menu item to modify
                UINT  uFlags,  // menu item flags: MF_BYCOMMAND or MF_BYPOSITION
  // parameter 4,5 and following like "wsprintf" :
                char *pszFormat, ... )  // format string for wsprintf (no floats!)
{
 va_list parameter;              /* Parameter-Liste fr VA_... Macros */
 char szText[255];                  /* Puffer fr formatierten String */
 MENUITEMINFO mii;

 va_start( parameter, pszFormat );             /* Parameter umwandeln */
 wvsprintf( szText, pszFormat, parameter );            /* formatieren */
 va_end(parameter);                            /* Parameter-Ende      */

 ZeroMemory(&mii,sizeof(MENUITEMINFO));
 mii.cbSize= sizeof(MENUITEMINFO);
 mii.fMask = MIIM_TYPE; // MIIM_TYPE sets the fType and dwTypeData members
 mii.fType = MFT_STRING;
 mii.dwTypeData = (LPSTR)szText;
 return SetMenuItemInfo( hmenu, uIDItem, (uFlags & MF_BYPOSITION)?TRUE:FALSE, &mii);
}





/* Note on windoze-"INI-files": If you don't specify a full path,             */
/* your INI-file will be placed in some strange windoze-system-directory !    */
/* Use ExpandFilenameToFullPath() if you want the INI file in the current dir */

//---------------------------------------------------------------------------
void WriteStringToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, char *pszData)
{
  WritePrivateProfileString(pszSection,pszKey,pszData,pszIniFileName);
}

//---------------------------------------------------------------------------
void WriteIntegerToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, long lData)
{
  char sz15Temp[16];
  wsprintf(sz15Temp,"%ld",(long)lData);
  WriteStringToIniFile(pszIniFileName,pszSection,pszKey,sz15Temp);
}

//---------------------------------------------------------------------------
void ReadStringFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                           char *pszDest, int iMaxLen, char *pszDefault)
{
  GetPrivateProfileString(
     pszSection,pszKey,pszDefault,   // section, key name, default string
     pszDest,iMaxLen,                // returned string, max length
     pszIniFileName );               // "initialization filename"
}

//---------------------------------------------------------------------------
long ReadIntegerFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                            long lDefault)
{
  return GetPrivateProfileInt(
     pszSection,pszKey,lDefault,   // section, key name, default value
     pszIniFileName );             // "initialization filename"
}


