//--------------------------------------------------------------------------
//  File:   c:\cbproj\SoundUtl\Goodies.c
//  Date:   2011-07-04
//  Author: Wolfgang Buescher (DL4YHF)
//
//  Purpose:
//    A few non-application specific routines (mostly windoze stuff)
//    for the SOUND INPUT and SOUND OUTPUT tool,
//    later also used in some Audio-I/O-DLLs for the configuration screen;
//    for example in c:\cbproj\AudioIO\aio2winamp.c .
//
//  Latest changes:
// 2011-07-03 : The MinGW-linker was unable to find the functions in this module,
//              even though it was included in the project,
//              and Goodies.H was used (in aio2winamp.c) .  WTF ?
//           Cure: Renamed 'Goodies.cpp' to 'Goodies.c' ,
//                 and added the inevitable 'CPROT' in the prototypes
//                 so Goodies.h can also be used in mixed C / C++ projects.
//--------------------------------------------------------------------------

#include <windows.h>   // contains stuff like "BOOL", etc
#pragma hdrstop


#include "Goodies.h"   // prototypes for Mother's little helpers
                       // original file located at c:\cbproj\SoundUtl\Goodies.h

extern HINSTANCE APPL_hInstance; // handle to current instance, set in WinMain()


//----------------- Mother's little helpers ---------------------------------

//---------------------------------------------------------------------------
void  SimpleTextOut(  HDC hDC,  // device context for output
                   char *pszOutput,   // text to be drawn
                   int x, int y)      // start position
{
   TextOut( hDC, x, y, pszOutput, strlen(pszOutput) );
}


//---------------------------------------------------------------------------
void  RotatedTextOut(  HDC hDC,  // device context for output
                   char *pszFaceName, // typeface name string like "Arial"
                   int iFontHeight,   // font height
                   char *pszOutput,   // text to be drawn
                   int x, int y, // start position
                   int angle )   // rotation angle in degrees
   /* Writes a string on the canvas, rotated by any angle,
    *   starting at the point (X,Y).
    * Based on an example from the Win32 Programmer's Reference,
    *   look for "Rotating Lines of Text".
    */
{
  HFONT hfnt, hfntPrev;

  /* Allocate memory for a LOGFONT structure.                          */
  PLOGFONT plf = (PLOGFONT) LocalAlloc(LPTR, sizeof(LOGFONT));

  /* Specify a font typeface name, height and weight.                  */
  /* Take the most important text parameters from Borlands "Canvas".   */
  strcpy( plf->lfFaceName, pszFaceName );
  plf->lfHeight = iFontHeight;
  plf->lfWeight = FW_NORMAL;

  /* Draw the string, rotating by the indicated angle (in degrees)     */
  plf->lfEscapement = angle*10;
  hfnt = CreateFontIndirect(plf);
  hfntPrev = (HFONT)SelectObject(hDC, hfnt);
  TextOut(hDC, x, y, pszOutput, lstrlen(pszOutput) );
  SelectObject(hDC, hfntPrev);
  DeleteObject(hfnt);

  /* Free the memory allocated for the LOGFONT structure.              */
  LocalFree((LOCALHANDLE) plf);
}


//---------------------------------------------------------------------------
void  DrawVerticalIndicatorBar( HDC hDC, // device context for output
               int iLeft, int iTop, int iRight, int iBottom, // drawing area
               COLORREF lIndicatorColor, // Color of the indicator (RGB-mix)
               COLORREF lBackgroundColor, // Color of the background (RGB-mix)
                 float fltPercentValue, // value to be displayed [percent]
                     char *pszCaption )  // one or two letters like "L" or "R"
{
 RECT rect;
 HBRUSH hMeterBrush, hBackgndBrush;
 int y, iOldBkMode;
 float d;
 char sz10[11];

  // Draw the "peak value indicator" at the right window edge...
  d = fltPercentValue;
  if(d<0)   d=0;
  if(d>100) d=100;
  d = (float)(iBottom - iTop - 4) * d / 100.0;
  y = iBottom - (int)d;
  if(y<iTop)
     y=iTop;
  if(y>iBottom)
     y=iBottom;
  rect.left = iLeft  + 2;
  rect.right= iRight - 2;
  rect.top  = iTop+4;
  rect.bottom= y-1;     // draw the UPPER PART (which is not covered) with the "background" color
  hMeterBrush  = CreateSolidBrush( lBackgroundColor );
   { FillRect(hDC, &rect, hMeterBrush);
   }
  DeleteObject(hMeterBrush);
  rect.top  = y;
  rect.bottom= iBottom; // draw the LOWER PART OF THE BAR with the "indicator"
  hBackgndBrush = CreateSolidBrush( lIndicatorColor );
   { FillRect(hDC, &rect, hBackgndBrush);
   }
  DeleteObject(hBackgndBrush);

  // Set the background mode to transparent for the text-output operation..
  iOldBkMode = SetBkMode(hDC, TRANSPARENT);
  wsprintf(sz10,"%d %%", (int)fltPercentValue );
  RotatedTextOut(  hDC, "Arial", 12, // typeface name, font "height"
                             sz10,   // text to be drawn
              rect.left, iBottom-16, // x,y
                              90 );  // rotation angle in degrees
  if(pszCaption)
   { RotatedTextOut( hDC,"Arial",12, // typeface name, font "height"
                         pszCaption, // text to be drawn
            rect.left+2, iBottom-12, // x,y
                               0 );  // rotation angle in degrees
   }

  SetBkMode(hDC, iOldBkMode);


} // end DrawVerticalIndicatorBar()




//---------------------------------------------------------------------------
BOOL DoesFileExist( char *pszFileName )
{ // quite similar to FileExists(), but no bloody VCL "AnsiString" type needed
 BOOL fResult;
 HANDLE hFindHandle;
 WIN32_FIND_DATA FindFileData;


 if( (hFindHandle=FindFirstFile(
                    pszFileName,  // pointer to name of file to search for
                  &FindFileData)) // pointer to returned information
       != INVALID_HANDLE_VALUE)
   { // success in FindFirstFile does not mean the file is "suitable" for us...
     fResult =
          ((FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)==0)
       && ((FindFileData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN   )==0) ;
     FindClose(hFindHandle); // close file search handle
     return fResult;         // return only TRUE if its a "normal" data file.
   }
  else // FindFirstFile failed
     return FALSE;  // assume the file does not exist
} // end DoesFileExist()

//---------------------------------------------------------------------------
void GetFileNameFromSource(char **cppSource, char *cpDest, int iMaxLength)
{
  BYTE *cpSource = (BYTE*) *cppSource;
  if(*cpSource=='"')
   {   // argument enclosed in double quotes...
       // may be a filename with spaces (YUCC!) but some folks use them these days
     ++cpSource; // skip opening double quote
     while(*cpSource!='"' && *cpSource!='\0' && iMaxLength>0)
      { *cpDest++ = *cpSource++;
        --iMaxLength;
      }
     if(*cpSource=='"')
       ++cpSource; // skip closing double quote
   }
  else // argument not enclosed in double quotes...
   {
     while( (*cpSource > ' ') // can you guess why this is a BYTE pointer ? :-)
           && iMaxLength>0)
      { *cpDest++ = *cpSource++;
        --iMaxLength;
      }
   }

  *cpDest = '\0';                // terminate destination string
  *cppSource = (char*)cpSource;  // advance source pointer  to end of analyzed string

} // end GetFileNameFromSource()


//---------------------------------------------------------------------------
BOOL ExpandFilenameToFullPath(char *pszFilename, char *pszFullName, int iMaxLen)
{ // Proved to be very useful when working with INI-files...
 char *pszDummy;
  // The GetFullPathName function retrieves the full path
  // and filename of a specified file.
  return (0<GetFullPathName(
    pszFilename, // address of name of file to find path for
    iMaxLen,     // size, in characters, of path buffer
    pszFullName, // address of path buffer
    &pszDummy)); // address of filename in path
} // end ExpandFilenameToFullPath()


//---------------------------------------------------------------------------
int StartExecutableWithCommandLine(char *pszCommandLine, int iShowHow )
  /* Starts an external application run (using the operating system).
   * [in] pszCommandLine = full path to the executable and command line, e.g.:
   *      "C:\\CBproj\\SoundUtl\SndInput.exe /sh=1 /sr=48000 /ch=2 /dt=2 /dev=\"IN 3-4\" testsig=440"
   * [in] iShowHow : In almost every case, SW_SHOWNORMAL .
   * Return: Negative value = CLI error Code.
   *         Zero           = Ok, command executed.
   *        Positive values are reserved for future applications,
   *          like loops and program branches.
   */
{
 int   i;
 STARTUPINFO         my_startup_info;
 PROCESS_INFORMATION my_process_info;

 DWORD dwLastError; // .. from GetLastError(), after CreateProcess() failed ..

  if( iShowHow==0 ) // caller wants US to decide "how to show the window" ..
   {  iShowHow = SW_SHOWNORMAL;
   }

  // To execute a command from the operation system (maybe DOS),
  //  prepare some red tape...  WinExec (from the old days) was simpler.
  memset(&my_startup_info, 0, sizeof(my_startup_info) );
        // see help on STARTUPINFO, LoadModule(), PROCESS_INFORMATION !
  my_startup_info.cb = sizeof(my_startup_info);
  my_startup_info.wShowWindow= iShowHow; // e.g. SW_SHOWNORMAL
  memset(&my_process_info, 0, sizeof(my_process_info) );
     // CreateProcess also works under Win98, but not the "internal"
     // DOS commands like "copy".  The trick with "cmd \C copy x.dat y.dat"
     // only works under Win NT, XP, and most likely Win 2000 .
#if(0)  // 2004-04-27: Tried WinExec, but switched back to CreateProcess
  if( WinExec(     // MS say "use CreateProcess for Win32 applications" - why ?
         temp_command_line, // address of command line
         my_startup_info.wShowWindow ) // window style for new application
        <= 31) // <= 31 means "something wrong"
#else // try CreateProcess instead of WinExec ?   There is no obvious difference.
  if (! CreateProcess( // Why use CreateProcess ?  M$ say "WinExec" is outdated.
               NULL,  // name of executable module (with no "module name", use the command line)
               pszCommandLine, // command line (with program name + command line, space-delimited)
               NULL,  // pointer to process security attributes
               NULL,  // pointer to thread security attributes
               FALSE, // handle inheritance flag
               CREATE_NEW_CONSOLE + NORMAL_PRIORITY_CLASS, // creation flags
               NULL,  // pointer to new environment block
               NULL,  // pointer to current directory name
               &my_startup_info, // pointer to STARTUPINFO
               &my_process_info  // pointer to PROCESS_INFORMATION
            ) )
#endif // use "WinExec" or "CreateProcess" ?
  {  // CreateProcess() failed:
     dwLastError = GetLastError();
     // Error codes seen here (with a breakpoint on 'return dwLastError') :
     //
     return dwLastError;
  } // end if (!CreateProcess () )

  // Other program has been launched. Here, we do NOT want to wait until it has ENDED !
  return NO_ERRORS; // no "last error" (a la Win32 'GetLastError()') but SUCCESS

} // end StartExecutableWithCommandLine()


/***************************************************************************/
int YearMonthDayToUnixDays( int year, int month, int day )
  // Converts a date (year, month, day) into the number of days since UNIX was born.
  //  Input parameters: full year (like 2001),
  //                    month: 1..12, day: 1..31 .
  //  Return:  "UNIX-days" = number of DAYS elapsed since January 1st, 1970 .
{
  // Nach Infos von http://www.pci.uzh.ch/pfister/formelsammlung.html ,
  //                  (Lokal gespeichert unter "Rolfs Formelsammlung")
  //  Julianisches Datum (JD)
  // JD = Anzahl Tage seit 4713 vor Christus
  // bis und mit 4.Oktober 1582: B = int((y+4716)/4) - 1181
  //        ab 15.Oktober 1582: B = int(y/400)-int(y/100)+int(y/4)
  // (Wegen der Gregoranischen Kalenderreform folgte auf den 4.Okt. sogleich der 15.)
  //  JD = 365*y - 679004 + B + int(30.6*m) + d + h/24 + 2400000.5
  // MJD = JD - 2400000.5  (Modifiziertes Julianisches Datum)
  //          (WB: MJD = Anzahl Tage seit 17. November 17 1858 Mitternacht)
  // h = Tageszeit in Stunden
  // d = Tag
  // Y = fr Jahre vor Christus: Y = -1 - Jahreszahl
  //     fr Jahre nach Christus: Y = Jahreszahl
  // wenn Monat<=2 : y = Y-1   m = Monat+13
  //          sonst: y = Y     m = Monat+1
  // int() = Abrundung auf ganze Zahl
  //
  // ... Conversion into C :
  // The "Modified Julian Date" is the number of DAYS passed since
  //     >>  Midnight, November 17, 1858  <<
  // The UNIX date-and-time format is the number of SECONDS passed since
  //     >>  Midnight, January 1, 1970    <<
  long   b, m, y, mjd;

  if( month<= 2) { y=year-1; m=month+13; }
         else    { y=year;   m=month+1;  }
  if( (year>=1582) || (month>=10) || (day>=15) )
       b = (int)(y/400) - (int)(y/100) + (int)(y/4);
   else // before October 4, 1582:
       b = (int)((y+4716)/4) - 1181;
   mjd = 365*y - 679004 + b + (int)((double)m*30.6) + day;
   // Now convert the result from Modified Julian DAYS (MJD)
   //     to the UNIX day number ( = "DAYS since January 1, 1970" ) .
   //
   // The MJD of Jan 1, 1970 has been calculated by the above routine
   // as:  40587 [days between Jan1, 1970  and  Nov 17, 1858, 00:00:00]
   return (mjd - 40587);
   // Note: In contrast to UNIX, this routine may also return valid negative
   //       numbers (there were good times even before January 1, 1970 ;-)
   //       and -hopefully- this routine will still work after year 2038 .
} // end YearMonthDayToUnixDays()

/***************************************************************************/
void UnixDaysToYearMonthDay( long i32UnixDayNumber, // [in] day number, 0 = 1970-01-01
         int *piYear, int *piMonth, int *piDay )    // [out] year, month, day-of-month
  // Inverse function to YearMonthDayToUnixDays() .
  // Splits a day-number in UNIX format (number of days since Jan 1st, 1970)
  //        into year, month, day .
{
  long   jdayno, j, d, m, y;

  // Split year, month of year, and day of month.
  // From   http://en.wikipedia.org/wiki/Julian_day :
  // > Unix Time (seconds since January 1st, 1970, UTC)
  // >  calculated from Julian Day by : (JD - 2440587.5) * 86400
  // First calculate 'jdayno' (Julian Day, JD) for the algo further below.
  //  "UnixDay" = JulianDay - 2440587.5, so :
  jdayno = (long)( i32UnixDayNumber + 2440587/*.5*/ ); // -> Julian Day, INTEGER

  // Die folgende Berechnung stammt aus Google Code Search, Stichwort
  //  "jdater - sets day, month and year given jdayno" (haystack.edu .. date.c)
  //  "inverse of jday method" .
  // Was in der Beschreibung leider komplett fehlt, ist eine Spezifikation
  //  der ZAEHLWEISE, speziell fuer jdayno (0...x oder 1...x),
  //  Monat(0..11 oder 1..12) und Tag (0..30 oder 1..31) !
  // Von gmtime() ist man ja Elendes gewohnt (Tage von 1..31 aber Monate von 0..11).
  // Hier scheint aber alles AB EINS gezaehlt zu werden (Pascal-Freaks?),
  // auch der 'jdayno' beginnt die Zaehlung scheinbar bei EINS, nicht NULL, darum:
  ++jdayno;
  // Original formula from haystack.edu starts here:
  j = jdayno - 1721119;
  y = (4*j - 1)/146097;
  j  =  4*j - 1 - 146097*y;
  d = j/4;
  j = (4*d + 3)/1461;
  d = 4*d + 3 - 1461*j;
  d = (d + 4)/4;
  m = (5*d - 3)/153;
  d = 5*d - 3 - 153*m;
  d = (d + 5)/5;
  y = 100*y + j;
  if (m < 10)
   {  m = m + 3;
   }
  else
   {  m = m - 9;
      y = y + 1;
   }

  if( piYear != NULL )
   { *piYear = y;
   }
  if( piMonth != NULL )
   { *piMonth = m;
   }
  if( piDay != NULL )
   { *piDay = d;
   }
} // end UnixDaysToYearMonthDay()



//**************************************************************************
// Routines to make low-level windoze programming a bit easier ...
//    .. or even more obscure ?)
// Most of these taken from DL4YHF's Complex Calculating Text Editor .
//**************************************************************************

//---------------------------------------------------------------------------
int GetWindowHeight( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  // The GetWindowRect function retrieves the dimensions of the bounding
  // rectangle of the specified window. The dimensions are given in screen
  // coordinates that are relative to the upper-left corner of the screen.
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.bottom - MyRect.top;
} // end GetWindowHeight()

//---------------------------------------------------------------------------
int GetWindowWidth( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )  // See GetWindowHeight() for details
     return 0;
  return MyRect.right - MyRect.left;
} // end GetWindowWidth()

//---------------------------------------------------------------------------
int GetWindowPosX1( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.left;
} // end GetWindowPosX1()

//---------------------------------------------------------------------------
int GetWindowPosY1( HWND hWnd )
{
 RECT MyRect;
  if(! hWnd)
    return 0;
  if(! GetWindowRect( hWnd, &MyRect) )
     return 0;
  return MyRect.top;
} // end GetWindowPosY1()



//---------------------------------------------------------------------------
HWND CreateStaticText(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create "static text" through Win API..
        "static",          // LPCTSTR lpClassName
        pszText,           // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        0,                 // HMENU hMenu
        APPL_hInstance,    // HANDLE hInstance
        // Found somewhere: If you have a HWND from the application,
        //  you can always get the HINSTANCE with GetWindowLongPtr :
        // GetWindowLongPtr( hWndParent, GWLP_HINSTANCE ), // replaces APPL_hInstance, but:
        // BTW, GetWindowLongPtr and GWPL_HINSTANCE could not be found
        //      in ANY of Borland's include files (header files),
        //      so it's most likely "too new to be good for anything" .
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateStaticText()

//---------------------------------------------------------------------------
HWND CreateEditField(HWND hWndParent, char *pszText, DWORD dwStyleOptions,
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create a simple edit field..
        "edit",            // LPCTSTR lpClassName
        pszText,           // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        0,                 // HMENU hMenu
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateEditField()

//---------------------------------------------------------------------------
HWND CreateButton(HWND hWndParent, char *pszCaption, DWORD dwStyleOptions,
                      int iControlID,  // user-defined CONSTANT (suitable for case-lists)
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create a simple edit field..
        "button",          // LPCTSTR lpClassName
        pszCaption,        // LPCTSTR lpWindowName
        WS_CHILD | WS_VISIBLE | dwStyleOptions,  // DWORD dwStyle
        x, y, width, height, // position + size
        hWndParent,        // handle of parent window
        (HMENU)iControlID, // HMENU hMenu ... well, not really in this case:
         // > For a child window, hMenu specifies the child-window identifier,
         // > an integer value used by a dialog box control to notify
         // > its parent about events.
         // This 'notification' is the WM_COMMAND message, and
         // this 'integer value' is usually called the 'control ID',
         // passed as LOWORD(wParam) in WM_COMMAND .
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateButton()

//---------------------------------------------------------------------------
HWND CreateComboBox(HWND hWndParent, char *pszText,
                    DWORD dwStyleOptions, // CBS_DROPDOWNLIST or CBS_DROPDOWN
                    int iControlID,  // user-defined CONSTANT (suitable for case-lists)
                      int x, int y, int width, int height)
{
  return CreateWindow(     // Create a combo box..
        "combobox",        // LPCTSTR lpClassName
        pszText,           // LPCTSTR lpWindowName (misleading name)
        WS_CHILD | WS_VISIBLE // DWORD dwStyle ..
                 | CBS_DROPDOWN | CBS_AUTOHSCROLL | CBS_HASSTRINGS
                 | dwStyleOptions,
        x, y, width, height, // position + size, includes the area of the dropdown-list !
        hWndParent,        // handle of parent window
        (HMENU)iControlID, // HMENU hMenu, here: CONTROL ID (user def'd constant)
        APPL_hInstance,    // HANDLE hInstance
        NULL);             // LPVOID lpParam, pointer to window-creation data
} // end CreateComboBox()

//---------------------------------------------------------------------------
int AddStringToComboBox(HWND hWndComboBox, char *pszItemText )
{
  // > An application sends a CB_ADDSTRING message to add a string
  // > to the list box of a combo box. If the combo box does not have
  // > the CBS_SORT style, the string is added to the end of the list.
  // > Otherwise, the string is inserted into the list, and the list is sorted.
  // >
  // > The return value is the zero-based index to the string in the list box
  // > of the combo box. If an error occurs, the return value is CB_ERR.
  // > If insufficient space is available to store the new string, it is CB_ERRSPACE.
  // >
  // > To insert a string at a specific location within the list,
  // > use the CB_INSERTSTRING message.
  return SendMessage( hWndComboBox, CB_ADDSTRING, 0, (LPARAM)pszItemText );
} // end AddStringToComboBox()


//-------------------------------------------------------------------------
void CheckMenuItemByIDAndCondition( HMENU hMenu, UINT  uIDItem, BOOL condition )
{
  CheckMenuItem( hMenu, uIDItem, MF_BYCOMMAND |
                 (condition  ? MF_CHECKED : MF_UNCHECKED)  );
}


//-------------------------------------------------------------------------
BOOL PrintIntoMenuItem(
  // first 3 params like CheckMenuItem :
                HMENU hmenu,   // handle to menu
                UINT  uIDItem, // menu item to modify
                UINT  uFlags,  // menu item flags: MF_BYCOMMAND or MF_BYPOSITION
  // parameter 4,5 and following like "wsprintf" :
                char *pszFormat, ... )  // format string for wsprintf (no floats!)
{
 va_list parameter;              /* Parameter-Liste fr VA_... Macros */
 char szText[255];                  /* Puffer fr formatierten String */
 MENUITEMINFO mii;

 va_start( parameter, pszFormat );             /* Parameter umwandeln */
 wvsprintf( szText, pszFormat, parameter );            /* formatieren */
 va_end(parameter);                            /* Parameter-Ende      */

 ZeroMemory(&mii,sizeof(MENUITEMINFO));
 mii.cbSize= sizeof(MENUITEMINFO);
 mii.fMask = MIIM_TYPE; // MIIM_TYPE sets the fType and dwTypeData members
 mii.fType = MFT_STRING;
 mii.dwTypeData = (LPSTR)szText;
 return SetMenuItemInfo( hmenu, uIDItem, (uFlags & MF_BYPOSITION)?TRUE:FALSE, &mii);
}




//---------------------------------------------------------------------------
// Note on windoze-"INI-files": If you don't specify a full path,
// your INI-file will be placed in some strange windoze-system-directory !
// Use ExpandFilenameToFullPath() if you want the INI file in the current dir.
// BUT: Placing the INI file where *YOU* want to have it doesn't work under
//      Windows "Vista" (yucc) and Windows 7 anymore !!
//   So forget about this, forget about ini files, forget about windoze... ?

//---------------------------------------------------------------------------
void WriteStringToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, char *pszData)
{
  WritePrivateProfileString(pszSection,pszKey,pszData,pszIniFileName);
}

//---------------------------------------------------------------------------
void WriteIntegerToIniFile(char *pszIniFileName, char *pszSection, char *pszKey, long lData)
{
  char sz15Temp[16];
  wsprintf(sz15Temp,"%ld",(long)lData);
  WriteStringToIniFile(pszIniFileName,pszSection,pszKey,sz15Temp);
}

//---------------------------------------------------------------------------
void ReadStringFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                           char *pszDest, int iMaxLen, char *pszDefault)
{
  GetPrivateProfileString(
     pszSection,pszKey,pszDefault,   // section, key name, default string
     pszDest,iMaxLen,                // returned string, max length
     pszIniFileName );               // "initialization filename"
}

//---------------------------------------------------------------------------
long ReadIntegerFromIniFile(char *pszIniFileName, char *pszSection, char *pszKey,
                            long lDefault)
{
  return GetPrivateProfileInt(
     pszSection,pszKey,lDefault,   // section, key name, default value
     pszIniFileName );             // "initialization filename"
}


