/*--------------------------------------------------------------------------*/
/* FilterTypes.h  =  Common Definitions and data types for digital filters  */
/*                   used in DL4YHF's SpecLab and similar DSP experiments.  */
/*                                                                          */
/*  Coded by Wolfgang Buescher (DL4YHF) .                                   */
/*                                                                          */
/*  Revision date:   2003-02-11  (YYYY-MM-DD)                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/



#ifndef _FILTER_TYPES_H_
#define _FILTER_TYPES_H_ 1

#ifndef  SWI_FLOAT_PRECISION   // should be defined under Project..Options..Conditionals
 #define SWI_FLOAT_PRECISION 2 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_FilterFloat float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_FilterFloat double
#endif



// some CONSTANTS ...
#ifndef  PI
 #define PI 3.14159265358979323846
#endif

// max. filter order for FIR or IIR algorithm:
#define FILTER_MAX_COEFFICIENTS 128
       // Note: This may change dramatically
       // when filters with FFT CONVOLUTION are implemented one fine day !


/*---------- Common Data types (for some different filter designers) --------*/

     // Types of filters for cascaded designs ("IIR-Designer #2" + "FFT Filter"),
     // must match the items in CB_FftFilterType in SpecLab's filter control window.
#define C_FILTER_TYPE_BYPASS     0  // for classic filters in the time domain
#define C_FILTER_TYPE_CUSTOM     0  // for FFT Filter (very long FIR filters)
#define C_FILTER_TYPE_LOWPASS    1
#define C_FILTER_TYPE_HIGHPASS   2
#define C_FILTER_TYPE_BANDPASS   3
#define C_FILTER_TYPE_BANDREJECT 4

     // Maximum stage number for cascaded designs like "IIR-Designer" #2 + 3
#define C_FILTER_MAX_CHAIN_STAGE 32

     // Filter response types for the "IIR3" designer suggested by M0BMU..
     // The trailing number is the number of 2nd-order IIR stages/sections
     // created by this design.
     // When changing these definitions, a combo list must also be modified !
#define FILTER_RESPONSE_BESSEL_10       0
#define FILTER_RESPONSE_BUTTERWORTH_10  1
#define FILTER_RESPONSE_CHEBYSHEV01_10  2
#define FILTER_RESPONSE_CHEBYSHEV1_10   3
#define FILTER_RESPONSE_LINPHASE05_10   4
#define FILTER_RESPONSE_LINPHASE005_10  5
#define FILTER_RESPONSE_GAUSSIAN6DB_10  6
#define FILTER_RESPONSE_GAUSSIAN12DB_10 7


typedef struct
{
   int     filter_type;
   double  f_center;
   double  bandwidth;
   double  gain;
} T_FILTER_STAGE;

typedef struct
{
   int            nr_of_stages;
   T_FILTER_STAGE stage[C_FILTER_MAX_CHAIN_STAGE+1];
} T_FILTER_CHAIN;


typedef struct
{
 double dblFcenter;           // filter center frequency [Hertz]
 double dblBandwidth;         // total filter bandwidth  [Hertz]
    int iFilterResponseType;  // like FILTER_RESPONSE_BESSEL_10 etc
} T_FILTER_DESIGN_IIR3;



typedef struct // Structure with ALL DATA needed to "run" an FIR- or IIR filter
{              // (also used as destination structure for some filter designers)
  int    max_coeff;   // 1..<SND_FILTER_MAX_COEFFICIENTS>, 2=2nd order filter
                      // or <numer_of_stages> * <coeffs_per_stage> !!!
  int    iir_type;    // false = FIR-filter,  true = IIR-filter
  int    cascaded;    // 0=one big filter,  3= 3 coefficient-pairs per stage

   // Note on "float" versus "double": The filter coeffs MAY be "doubles"
   //  though the processed samples are "single precision floats" (!!)
  T_FilterFloat alpha[FILTER_MAX_COEFFICIENTS+1];
  T_FilterFloat beta[FILTER_MAX_COEFFICIENTS+1];
  T_FilterFloat z[FILTER_MAX_COEFFICIENTS+1];
  T_FilterFloat *p_circular_input_queue;  // if 'alternative' FIR algorithm is used
} T_FILTER_DATA;



#endif // _FILTER_TYPES_H_
