//------------------------------------------------------------------------
//  c:\cbproj\SoundUtl\ErrorCodes.h
//
//  This file contains the definitions for all the error codes
//       that can be generated by the CSound and CWave classes,
//       and by a few functions of the application itself.
//  Much later (2011), other error codes which haven't got anything to do
//       with the 'sound utilities' and digital signal processing
//       were added, and the file was copied
//         from c:\cbproj\SoundUtl\ErrorCodes.h
//           to C:\cbproj\YHF_Tools\ErrorCodes.h .
//
//  Original location:  C:\CBproj\SoundUtl\ErrorCodes.h
//             Copies:  C:\cbproj\YHF_Tools\ErrorCodes.h ,
//                      C:\CBproj\CurveEdit\ErrorCodes.h .
//  Revision date    :  2011-12-04 (YYYY-MM-DD)
//
// Last modifications (latest entry FIRST):
//    2011-12-04 : Added a few error codes for the socket-service wrapper;
//                 C:\cbproj\YHF_Tools\YHF_Inet.c  uses  ErrorCodes.h now .
//
//------------------------------------------------------------------------

#if !defined ErrorCodesH
#define ErrorCodesH

/* Note by DL4YHF:
 * Be careful with the error codes !
 * Someone mixed his own error codes (defined in this header)
 *   to the Multimedia API error codes from Microsoft....
 * Compare the following error constants with
 *   ??\CBuilder4\include\mmsystem.h !
 *  Search for MMSYSERR_  ( error codes  0..31 max)
 *               WAVERR_  ( error codes 32..63 max)
 *              MIDIERR_  ( error codes 64..95 max)
 *               TIMERR_  ( error codes 96..159 max)
 *               MIXERR_  ( error codes 1024..1026 or so)
 * The "original" ErrorCodes.h defined codes 100..116,
 * DL4YHF introduced MYERR_BASE (my error code base)
 * to move them anywhere else easily.
 * Note that the error codes in ErrorCodes.h are all POSITIVE !
 */
#define MYERR_BASE  2000

// generic error codes for all classes. All convertable to text via ErrorCodeToString().
#define NO_ERRORS 0
#define MEMORY_ERROR (MYERR_BASE+100)

// input wave file error codes
#define WAVIN_ERR_OPEN    (MYERR_BASE+101) // can't open wave file (or COM port) for input
#define WAVIN_ERR_NOTWAVE (MYERR_BASE+102) // file is not a RIFF wave type
#define WAVIN_ERR_INVALID (MYERR_BASE+103) // Invalid wave file
#define WAVIN_ERR_NODATA  (MYERR_BASE+104) // no data in file
#define WAVIN_ERR_NOTSUPPORTED (MYERR_BASE+105) // not a supported data type
#define WAVIN_ERR_READING (MYERR_BASE+106) // Error reading data from file
#define WAVIN_ERR_NOTOPEN (MYERR_BASE+107) // tried to read but file is not open

// output wave file error codes
#define WAVOUT_ERR_OPEN    (MYERR_BASE+108) // can't open wave file for output
#define WAVOUT_ERR_WRITING (MYERR_BASE+109) // error writing to wave file
#define WAVOUT_ERR_NOTOPEN (MYERR_BASE+110) // tried to write and file is not open

// Soundcard input error codes
#define SOUNDIN_ERR_NOTOPEN (MYERR_BASE+111)  // tried to read but soundcard is not open
#define SOUNDIN_ERR_OVERFLOW (MYERR_BASE+112) // input buffers overflowed
#define SOUNDIN_ERR_HIGH_WATER (MYERR_BASE+113) // critically "full" input buffers
#define SOUNDIN_ERR_TIMEOUT  (MYERR_BASE+114) // Timed out waiting for input buffers (2114)

// Soundcard output error codes
#define SOUNDOUT_ERR_NOTOPEN   (MYERR_BASE+115) // tried to write and soundcard is not open
#define SOUNDOUT_ERR_UNDERFLOW (MYERR_BASE+116) // output buffers Underflowed
#define SOUNDOUT_ERR_OVERFLOW  (MYERR_BASE+117) // output buffer overflow (only occurrs w/o waiting)
#define SOUNDOUT_ERR_LOW_WATER (MYERR_BASE+118) // critically "empty" output buffers
#define SOUNDOUT_ERR_TIMEOUT   (MYERR_BASE+119) // Timed out waiting for output buffers

// Error from the audio-I/O-DLL (only "one for all")
#define ERROR_FROM_AUDIO_IO_DLL   (MYERR_BASE+120)
#define ERROR_FROM_AUDIO_IO_DLL2  (MYERR_BASE+121)


// other error codes introduced by DL4YHF for "debugging" purposes..
#define ERROR_DULL_POINTER_ASSIGNMENT  (MYERR_BASE+129)
      // a DULL pointer may be a NULL pointer, or a pointer that is invalid for
      // any other reason (on uC: illegal address, bad alignment, etc)
#define ERROR_WORD_AT_ODD_ADDRESS      (MYERR_BASE+130)
#define ERROR_THREAD_FAILED            (MYERR_BASE+131)
#define ERROR_WITH_ASIO_DRIVER         (MYERR_BASE+132)
#define ERROR_UNKNOWN_CMD_ARGUMENT     (MYERR_BASE+133)
#define ERROR_ILLEGAL_CMD_PARAMETER    (MYERR_BASE+134)
#define ERROR_CMD_COMBI_UNSUPPORTED    (MYERR_BASE+135)
#define ERROR_DATA_TYPE_NOT_SUPPORTED  (MYERR_BASE+136)
#define ERROR_OUTPUT_FILE_NOT_CONSUMED (MYERR_BASE+137)
#define ERROR_CREATE_FILE_FAILED       (MYERR_BASE+138)
#define ERROR_FILE_DOESNT_EXIST        (MYERR_BASE+139)

// Error codes related with the socket-based 'INET'-module
//  ( -> C:\cbproj\YHF_Tools\YHF_Inet.c )
#define INET_ERROR_SOCKET_NOT_OPEN  (MYERR_BASE+140)
#define INET_ERROR_COULDNT_CONNECT  (MYERR_BASE+141)
#define INET_ERROR_BAD_URL_SYNTAX   (MYERR_BASE+142)
#define INET_ERROR_CONNECTION_RESET (MYERR_BASE+143)
#define INET_ERROR_CONNECTION_ABORT (MYERR_BASE+144)
#define INET_ERROR_CANNOT_SEND      (MYERR_BASE+145)

// general multimedia error values as defined in mmsystem.h
//#define MMSYSERR_BASE          0

//#define MMSYSERR_NOERROR      0                    // no error
//#define MMSYSERR_ERROR        (MMSYSERR_BASE + 1)  // unspecified error
//#define MMSYSERR_BADDEVICEID  (MMSYSERR_BASE + 2)  // device ID out of range
//#define MMSYSERR_NOTENABLED   (MMSYSERR_BASE + 3)  // driver failed enable
//#define MMSYSERR_ALLOCATED    (MMSYSERR_BASE + 4)  // device already allocated
//#define MMSYSERR_INVALHANDLE  (MMSYSERR_BASE + 5)  // device handle is invalid
//#define MMSYSERR_NODRIVER     (MMSYSERR_BASE + 6)  // no device driver present
//#define MMSYSERR_NOMEM        (MMSYSERR_BASE + 7)  // memory allocation error
//#define MMSYSERR_NOTSUPPORTED (MMSYSERR_BASE + 8)  // function isn't supported
//#define MMSYSERR_BADERRNUM    (MMSYSERR_BASE + 9)  // error value out of range
//#define MMSYSERR_INVALFLAG    (MMSYSERR_BASE + 10) // invalid flag passed
//#define MMSYSERR_INVALPARAM   (MMSYSERR_BASE + 11) // invalid parameter passed
//#define MMSYSERR_HANDLEBUSY   (MMSYSERR_BASE + 12) // handle being used
												     // simultaneously on another
												     // thread (eg callback)
//#define MMSYSERR_INVALIDALIAS (MMSYSERR_BASE + 13) // specified alias not found
//#define MMSYSERR_BADDB        (MMSYSERR_BASE + 14) // bad registry database
//#define MMSYSERR_KEYNOTFOUND  (MMSYSERR_BASE + 15) // registry key not found
//#define MMSYSERR_READERROR    (MMSYSERR_BASE + 16) // registry read error
//#define MMSYSERR_WRITEERROR   (MMSYSERR_BASE + 17) // registry write error
//#define MMSYSERR_DELETEERROR  (MMSYSERR_BASE + 18) // registry delete error
//#define MMSYSERR_VALNOTFOUND  (MMSYSERR_BASE + 19) // registry value not found
//#define MMSYSERR_NODRIVERCB   (MMSYSERR_BASE + 20) // driver does not call DriverCallback
//#define MMSYSERR_LASTERROR    (MMSYSERR_BASE + 20) // last error in range

// Besides the above, there may be hundreds of other error codes returned
// by "GetLastError()" (windows specific), that ErrorCodeToString()
// can convert into human-readable text --- if M$'s "FormatMessage" works as planned.
// On the author's machine, such error codes (like 1=ERROR_INVALID_FUNCTION)
// were defined in C:\cbuilder6\include\winerror.h


#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
// Note on "extern": do not trust the lousy example from Borland !
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//-----------------------------------------------------------------------------
CPROT char *ErrorCodeToString(int error_code );
   // Converts one of the error codes into a string.


#endif // ErrorCodesH
