/*--------------------------------------------------------------------------*/
/* DesignIIRbandpass.h = (header of) Filter Designer for IIR Bandpass Chain */
/*                                                                          */
/*  Coded by Wolfgang Buescher (DL4YHF) .                                   */
/*  Based on an idea by Jim Moritz (M0BMU) using analogue design methods .  */
/*                                                                          */
/*  Revision date:   2003-02-11  (YYYY-MM-DD)                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/


#ifndef _DESIGN_IIR_BANDPASS_H_
#define _DESIGN_IIR_BANDPASS_H_


#include "FilterTypes.h"

#ifndef CPROT
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = nonsense (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif



//---------------------------------------------------------------------------
CPROT int DesignIIRBandpassChain(
   double dblFcenter,           // filter center frequency [Hertz]
   double dblBandwidth,         // total filter bandwidth  [Hertz]
   double dblSampleRate,        // samples per second, required for normalization
      int iFilterResponseType,  // like FILTER_RESPONSE_BESSEL_10
   T_FILTER_DATA  *pFilter,     // destination structure with the filter coeffs
   T_FILTER_CHAIN *pIIR2_Chain);// destination structure for IIR-Designer #2 (optional)
  //
  // Calculates a chain (cascade) of IIR-type BANDPASS FILTERS,
  //            with carefully distributed poles.
  //
  // Input parameters:
  //      Fcenter, Bandwidth, SampleRate : values in Hertz(!)
  //      FilterResponseType: FILTER_RESPONSE_xxxx (see FilterTypes.h)
  //
  // Return values :  1 = ok
  //                 <0 = Error


#endif // _DESIGN_IIR_BANDPASS_H_
