/***************************************************************************/
/* AudioWrt.cpp =  interface for the  Audio File Writer .                  */
/*   - by DL4YHF,  May 2002                                                */
/*   - no VCL, no special runtime libs, only Win32 API used.               */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef AudioWrtH
#define AudioWrtH

#ifndef  SWI_FLOAT_PRECISION
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_Float double
#endif


#include "yhf_type.h"

//----------------------- Constants ---------------------------------------
 // DATA_TYPE_INT8  ... DATA_TYPE_FLOAT64  taken from yhf_type.h !



//***************************************************************************
//  Definition of the  CAudioFileWriter   class
//***************************************************************************

class CAudioFileWriter
{
public:
   CAudioFileWriter();  // constructor w/o parameters
   virtual ~CAudioFileWriter();

   BOOL CreateFile( char *pszDestFile,    // name of produced output file
                     int iExportDataType, // usually DATA_TYPE_INT16
              WAVEFORMATEX *pWaveFormat); // if a WAVe file header shall be written
   BOOL AppendToFile( T_Float *pfltSource, // pointer to source data
                       long lNrSamples) ; // count of '64-bit-float' values (!)
              // Note: the audio writer does not care for the buffer structure.
              //       If you want to write 4 pairs of I/Q samples,
              //       lNrSamples must be 4 * 2 = 8 'values' .

   BOOL CloseFile(void);
   inline BOOL  IsOpen(void) { return m_hOutputFile!=INVALID_HANDLE_VALUE; }
   inline long  GetBytesWritten(void)   { return m_lCountBytesWritten; }
   inline DWORD GetLastError(void)      { return m_dwErrorCode;        }
   inline int   GetExportDataType(void) { return m_iExportDataType;    }

private:
   HANDLE m_hOutputFile;       // value returned by WinApi CreateFile
   int    m_iExportDataType;
   DWORD  m_dwErrorCode;
   long   m_lCountBytesWritten;

}; // end class CAudioFileWriter






#endif // AudioWrtH
