/***************************************************************************/
/* AudioSnd.cpp =  interface for the  Audio Message Sender .               */
/*  Sends audio samples to other applications through WM_COPYDATA messages */
/*   - by DL4YHF,  June 2004                                               */
/*   - no VCL, no special runtime libs, only Win32 API used.               */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef AudioSndH
#define AudioSndH

#ifndef  SWI_FLOAT_PRECISION
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_Float double
#endif


#include "yhf_type.h"

//----------------------- Constants ---------------------------------------
 // DATA_TYPE_INT8  ... DATA_TYPE_FLOAT64  taken from yhf_type.h !



//***************************************************************************
//  Definition of the  CAudioMessageSender   class
//***************************************************************************

class CAudioMessageSender
{
public:
   CAudioMessageSender();  // constructor w/o parameters
   virtual ~CAudioMessageSender();

   BOOL ConnectRcvr( HWND hRcvrWindow );     // connect to a "receiver"
   BOOL DisconnectRcvr( HWND hRcvrWindow );  // disconnect from "receiver"

   BOOL SendAudio( T_Float *pfltSource,  // pointer to source data
                       long lNrSamples); // count of 'T_Float' values (!)
              // Note: the audio sender does not care for the buffer structure.
              //       If you want to write 4 pairs of I/Q samples,
              //       lNrSamples must be 4 * 2 = 8 'values' .

private:
   int    m_iExportDataType;
   DWORD  m_dwErrorCode;

}; // end class CAudioMessageSender






#endif // AudioSndH
