/***************************************************************************/
/* AudioRdr.cpp =  interface for the  Audio File Reader .                  */
/*   - by DL4YHF,  May 2002                                                */
/*   - no VCL, no special runtime libs, only Win32 API used.               */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef AudioRdrH
#define AudioRdrH

#ifndef  SWI_FLOAT_PRECISION
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_Float double
#endif


#include "yhf_type.h"

#include <windows.h>   // need WAVEFORMATEX in a class declaration
                       // ( often too late to include it here,
                       //   windows.h sometimes has to be included
                       //   before the bloody VCL.H - holy shit )


//----------------------- Constants ---------------------------------------
// #define DATA_TYPE_INT8 etc...  moved to yhf_type.h !!


//***************************************************************************
//  Definition of the  CAudioFileReader   class
//***************************************************************************

class CAudioFileReader
{
public:
   CAudioFileReader();  // constructor w/o parameters
   virtual ~CAudioFileReader();

   BOOL OpenFile( char *pszSourceFile,    // name of analysed input file
                   int iImportDataType,   // usually DATA_TYPE_INT16
              WAVEFORMATEX *pWaveFormat); // if a WAVe file header will be found..
        // if the "WAVEFORMATEX" causes trouble ("Type name expected"),
        // include WINDOWS.H before VCL.H, but don't ask me why !

   long ReadSamplesFromFile( T_Float *pdblDest, // pointer to destination block
                            long lNrSamples) ; // count of 'XX-bit-float' values (!)
              // Note: the audio reader does not care for the buffer structure.
              //       If you want to read 4 pairs of I/Q samples,
              //       lNrSamples must be 4 * 2 = 8 'values' .

   BOOL CloseFile(void);
   inline BOOL  IsOpen(void) { return m_hInputFile!=INVALID_HANDLE_VALUE; }
   inline long  GetBytesRead(void)      { return m_lCountBytesRead;    }
   inline DWORD GetLastError(void)      { return m_dwErrorCode;        }
   inline int   GetImportDataType(void) { return m_iImportDataType;    }

private:
   HANDLE m_hInputFile;     // value returned by WinApi CreateFile (to "open")
   int    m_iImportDataType;
   DWORD  m_dwErrorCode;
   long   m_lCountBytesRead;

}; // end class CAudioFileReader




#endif // AudioRdrH
