/***************************************************************************/
/* AudioRdr.cpp =  Audio File Reader .                                     */
/*   - by DL4YHF,  May 2002                                                */
/*   - no VCL, no special runtime libs, only Win32 API used.               */
/*   - quite outdated, doesn't support timestamped streams                 */
/*    ( better use C_AnyAudioFileIO, in \cbproj\SoundUtl\AudioFileIO.cpp ; */
/*      for WAVE audio files, that uses \cproj\SoundUtl\CWaveIO.cpp )      */ 
/*                                                                         */
/* Used by: "SndOutpt", "SpecLab" .                                        */
/*                                                                         */
/***************************************************************************/

#include "SWITCHES.H"  // project specific compiler switches ("options")
                       // must be included before anything else !


#include <windows.h>  // must be included BEFORE vcl.h for some strange reason

#pragma hdrstop

#include "ErrorCodes.h"
#include "utility1.h"  // uses UTL_NamedMalloc instead of malloc (for debugging), and to *GUARANTEE* 8-byte alignment
#include "AudioRdr.h"

//***************************************************************************
//  Implementation of methods for the   CAudioFileReader  class
//***************************************************************************


//***************************************************************************
CAudioFileReader::CAudioFileReader()   // constructor
{
  m_hInputFile = INVALID_HANDLE_VALUE;
  // useless here: ChunkInfo_Init( &m_LatestChunkInfo ); // avoid garbage in the audio-chunk-info
} // end CAudioFileReader::CAudioFileReader()    [constructor]

//***************************************************************************
CAudioFileReader::~CAudioFileReader()   // destructor
{
  CAudioFileReader::CloseFile();  // ... if necessary (!)
} // end CAudioFileReader::~CAudioFileReader()    [destructor]


//***************************************************************************
BOOL CAudioFileReader::OpenFile(
                  char *pszSourceFile,  // name of input file
                   int iImportDataType, // usually DATA_TYPE_INT16
             WAVEFORMATEX *pWaveFormat) // if a wave file header shall be produced
{
  CAudioFileReader::CloseFile();  // ... if necessary (!)

  // ChunkInfo_Init( &m_LatestChunkInfo ); // avoid garbage in the audio-chunk-info
  m_iImportDataType = iImportDataType;
  m_lCountBytesRead = 0;
  try
   {
    m_hInputFile = ::CreateFile(
        pszSourceFile,   // LPCTSTR lpFileName,    pointer to name of the file
        GENERIC_READ,  // DWORD dwDesiredAccess, access (read-write) mode
        0,             // DWORD dwShareMode,     share mode
        NULL,          // LPSECURITY_ATTRIBUTES lpSecurityAttributes
        OPEN_EXISTING, // DWORD dwCreationDistribution,  how to "create"
        FILE_ATTRIBUTE_NORMAL, // DWORD dwFlagsAndAttributes, file attributes
        NULL);         // HANDLE hTemplateFile,  handle to file with attributes to copy
   }
  catch(...)
   {
     m_dwErrorCode = GetLastError();
     m_hInputFile = INVALID_HANDLE_VALUE;
     return FALSE;
   }
  if(m_hInputFile==INVALID_HANDLE_VALUE)
   {
     m_dwErrorCode = GetLastError();
     if(m_dwErrorCode == NO_ERRORS) // action failed but 'no error' ?!?
      { // (yes, this happens !)
        m_dwErrorCode = ERROR_FILE_DOESNT_EXIST;
      }
   }

  return m_hInputFile!=INVALID_HANDLE_VALUE;

} // end CAudioFileReader::OpenFile()


//***************************************************************************
long CAudioFileReader::ReadSamplesFromFile(
                         T_Float *pdblDest, // pointer to destination block
                         long lNrSamples)   // number of floating point values (!)
         // not here:   T_ChunkInfo *pChunkInfo )    // [out] chunk info with timestamp, precise SR, etc [optional]
     // Note: the audio reader does not care for the buffer structure.
     //       If you want to read 4 pairs of I/Q samples,
     //       lNrSamples must be 4 * 2 = 8 'values' .
     // The return value is the number of 'single float' values,
     //   NOT the number of BYTES, and NOT the number of "stereo pairs" !
{
 BOOL   fResult;
 long   lNrSamplesRead=0;
 long   l;
 DWORD  dwBytesRead;

  if( (m_hInputFile==INVALID_HANDLE_VALUE) || (lNrSamples<=0) )
      return FALSE;  // oh, shut up

 // if( pChunkInfo != NULL )  // the caller wants to know a bit more...
 //  { // ... like timestamp, precise sampling rate, possibly GPS position, etc:
 //    *pChunkInfo = m_LatestChunkInfo;  // this is not 100% correct !
 //    // At least the TIMESTAMP must be adjusted for the sample count
 //    // between 'input' and 'output' into the internal buffer :
 //  } // end if( pChunkInfo != NULL )

  l = 0;
  switch(m_iImportDataType)  // what data type from the input file ?
   {
    case DATA_TYPE_INT8   :  // read (very)short 8 bit integer values ("BYTES")
       { BYTE *pi8Array = (BYTE*)UTL_NamedMalloc( "AudioRd1", lNrSamples); // allocate temporary array
         BYTE *pi8 = pi8Array;
         if(!pi8Array) { m_dwErrorCode=MEMORY_ERROR; return FALSE; }
         try
          {
           fResult = ReadFile(
                     m_hInputFile, // handle of file to read
                 (LPVOID)pi8Array, // address of buffer that receives data
                       lNrSamples, // number of bytes to read
                     &dwBytesRead, // pointer to number of bytes read
                           NULL ); // pointer to structure for overlapped I/O
           if(fResult)
            { l = lNrSamplesRead = dwBytesRead;
              m_lCountBytesRead += dwBytesRead;
            }

           while(l--)  // Note: the nominal input range is 0..255 (!) ,
            { //  while the NORMALIZED output range is -1.0 ... +1.0 (since 2022-10-19) :
              // *pdblDest++ = (T_Float)(*pi8++) * 256.0 + 32767; // anachronism with output range +/-32767
              *pdblDest++ = (T_Float)(*pi8++) * (2.0/255.0) - 1.0;
            }
           UTL_free(pi8Array);     // free temporary array
           return lNrSamplesRead;
          }catch(...){
           m_dwErrorCode = GetLastError();
           UTL_free(pi8Array);     // free temporary array
           return 0;
          } }
    case DATA_TYPE_INT16     :  // read short 16 bit integer values ("short")
       { SHORT *pi16Array = (SHORT *)UTL_NamedMalloc( "AudioRd2", lNrSamples*sizeof(SHORT));
         SHORT *pi16 = pi16Array;
         if(!pi16Array) { m_dwErrorCode=MEMORY_ERROR; return FALSE; }
         try{
           fResult = ReadFile(
                        m_hInputFile, // handle of file to read
                   (LPVOID)pi16Array, // address of buffer that receives data
            sizeof(SHORT)*lNrSamples, // maximum number of bytes to read
                        &dwBytesRead, // pointer to number of bytes read
                              NULL ); // pointer to structure for overlapped I/O
           if(fResult)
            { l = lNrSamplesRead = dwBytesRead / sizeof(SHORT);
              m_lCountBytesRead += dwBytesRead;
              // 2022-10-19 : With SndInput.exe "generating" these files at the
              //              other end, using a "max file size" of 65536 bytes
              //              (reported when clicking the "Info"-button),
              //     got here with dwBytesRead = 32768 (only!),
              //                   lNrSamplesRead = 16384 (only..),
              //
            }

           while(l--)  // To eliminate the anachronism of +/-32k in floating point samples,
            { // NORMALIZE THE OUTPUT to -1.0 ... +1.0, because that's
              // what we use for the internal DSP processing (or similar) now.
              *pdblDest++ = (T_Float)(*pi16++) * (1.0/32767.0); // <- modified 2022-10-19
            }
           UTL_free(pi16Array);  // free temporary array
           return lNrSamplesRead;
          }catch(...){
           m_dwErrorCode = GetLastError();
           UTL_free(pi16Array);  // free temporary array
           return 0;
          } }
    case DATA_TYPE_FLOAT32 :  // read single precision floating point ("float",  32 bit)
       { float *pfltArray = (float *)UTL_NamedMalloc( "AudioRd3", lNrSamples*sizeof(float)); // allocate temporary array
         float *pflt = pfltArray;
         if(!pfltArray) { m_dwErrorCode=MEMORY_ERROR; return FALSE; }
         try{
           fResult = ReadFile(
                       m_hInputFile, // handle to file to read
                  (LPVOID)pfltArray, // pointer to data to read
            sizeof(float)*lNrSamples, // number of bytes to read
                       &dwBytesRead, // pointer to number of bytes read
                             NULL ); // pointer to structure for overlapped I/O
           if(fResult)
            { l = lNrSamplesRead = dwBytesRead / sizeof(float);
              m_lCountBytesRead += dwBytesRead;
            }

           while(l--)
            { *pdblDest++ = *pflt++;
            }
           UTL_free(pfltArray);    // free temporary array
           return lNrSamplesRead;
          }catch(...){
           m_dwErrorCode = GetLastError();
           UTL_free(pfltArray);    // free temporary array
           return 0;
          } }
    case DATA_TYPE_FLOAT64 :  // write double precision floating point ("double", 64 bit)
       { double *pdblArray = (double *)UTL_NamedMalloc( "AudioRd6", lNrSamples*sizeof(double)); // allocate temporary array
         double *pdbl = pdblArray;
         if(!pdblArray) { m_dwErrorCode=MEMORY_ERROR; return FALSE; }
         try{
           fResult = ReadFile(
                       m_hInputFile, // handle to file to read
                  (LPVOID)pdblArray, // pointer to data to read
            sizeof(double)*lNrSamples, // number of bytes to read
                       &dwBytesRead, // pointer to number of bytes read
                             NULL ); // pointer to structure for overlapped I/O
           if(fResult)
            { l = lNrSamplesRead = dwBytesRead / sizeof(double);
              m_lCountBytesRead += dwBytesRead;
            }

           while(l--)
            { *pdblDest++ = *pdbl++;
            }
           UTL_free(pdblArray);    // free temporary array
           return lNrSamplesRead;
          }catch(...){
           m_dwErrorCode = GetLastError();
           UTL_free(pdblArray);    // free temporary array
           return 0;
          } }
    default:  // unknown data type
         return 0;
   } // end switch(iImportDataType)
} // end CAudioFileReader::ReadSamplesFromFile()

//***************************************************************************
BOOL CAudioFileReader::CloseFile(void)
{
  if(m_hInputFile != INVALID_HANDLE_VALUE)
   {
    try
     {
       CloseHandle( m_hInputFile );
       m_hInputFile = INVALID_HANDLE_VALUE;
       return TRUE;
     }
    catch(...)
     {
       m_dwErrorCode = GetLastError();
       m_hInputFile = INVALID_HANDLE_VALUE;
       return FALSE;
     }
   }
  else  // there was no valid opened file..
   {   return FALSE;
   }
} // end CAudioFileReader::CloseFile()


