/***************************************************************************/
/* AudioMsgHdlr.cpp =  interface for the  Audio Message Handler .          */
/*  Sends and receives audio samples to/from other applications            */
/*                     through WM_COPYDATA messages                        */
/*   - by DL4YHF,  June 2004                                               */
/*   - no VCL, no special runtime libs, only Win32 API used.               */
/*                                                                         */
/* Status:  **UNDER CONSTRUCTION**                                         */
/*                                                                         */
/***************************************************************************/

//---------------------------------------------------------------------------
#ifndef AudioMsgHdlrH
#define AudioMsgHdlrH

#ifndef  SWI_FLOAT_PRECISION
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // 2003-07-07: "float" instead of "double" saves CPU power on stoneage notebooks
#else
 #define T_Float double
#endif

#define AUDIO_HDLR_MAX_BUFFER_SIZE 8192


#include "yhf_type.h"
#include "audiomsg.h"   // info structures passed through this system 

//----------------------- Constants ---------------------------------------
 // DATA_TYPE_INT8  ... DATA_TYPE_FLOAT64  taken from yhf_type.h !

#define AUDIO_HDLR_MAX_RECEIVERS 8
#define AUDIO_HDLR_MAX_SENDERS   1

typedef struct // T_AudioMsgClient
{
  HWND hwnd;       // client's WINDOW HANDLE
  int  iDataType;  // data type required by client, like DATA_TYPE_INT16, defined in "yhf_type.h"
} T_AudioMsgClient;

typedef struct // Audio buffer for RECEIVED(!) samples..
{ DWORD   dwAllocatedBufferSize;
  DWORD   dwBufIndexIn, dwBufIndexOut;
  T_Float *pFltBuffer;
} T_AudioMsg_Buffer;


//***************************************************************************
//  Definition of the  CAudioMessageHandler   class
//***************************************************************************

class CAudioMessageHandler
{
public:
   CAudioMessageHandler();  // constructor w/o parameters
   virtual ~CAudioMessageHandler();
   void SetWindowHandle( HWND hwndMyWindow );

   BOOL ConnectDestination( HWND hwndRcvr ,   // connect to a "receiver"
           int  iRcvdDataType);    // type of data "I" want to send
   BOOL ConnectSource( HWND hwndSender ,      // connect to a "sender"
           int  iSentDataType);    // type of data "I" want to receive
   BOOL Disconnect( HWND hRcvrWindow );  // disconnect from "receiver" or "sender"
   HWND GetReceiverHandle( int iRcvrIndex );

   LONG HandleWmCopydata(     // handles the all-important WM_COPYDATA message
           HWND hwndDestWnd,       // WINDOW HANDLE of destination (should be "mine")
           HWND hwndSendingWnd,    // WINDOW HANDLE of the sender of this message
           COPYDATASTRUCT *pCds ); // pointer to COPYDATASTRUCE, passed in message

   BOOL SendAudio( T_Float *pfltSource, // pointer to source data
           long i32NrSamplePoints,   // count of SAMPLE POINTS, not "single float values"
           int  iChannelsPerSample); // info about the SOURCE: 1=mono, 2=stereo
   DWORD GetNrOfSamplesSent(void);

   BOOL GetReceivedAudio(
           T_Float *pfltDest,        // pointer to destination block, usually single precision float
           long i32NrSamplePoints,   // count of SAMPLE POINTS the caller may read from the buffer
           int  iChannelsPerSample); // info about the caller's DESTINATION: 1=mono, 2=stereo


private:
   HWND   m_hwndMyWindow;
   T_AudioMsgClient  m_Receiver[AUDIO_HDLR_MAX_RECEIVERS];
   T_AudioMsgClient  m_Sender  [AUDIO_HDLR_MAX_SENDERS];
   T_AudioMsg_Buffer m_RxBuffer[AUDIO_HDLR_MAX_SENDERS];

   int    m_iExportDataType;
   DWORD  m_dwErrorCode;
   DWORD  m_dwTotalSamplesSent;

   int GetRcvrIndex( HWND hwndReceiver );
   int GetSenderIndex( HWND hwndSender );

}; // end class CAudioMessageHandler






#endif // AudioSndH
