//---------------------------------------------------------------------------
// File  :  AM_FM_DeMod.h
// Date  :  2002-07-21   (yyyy-mm-dd)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//   Implementation of a class for modulating and demodulating AM + FM signals
//
// Revision history (yyyy-mm-dd):
//   2002-07-21  Written for initial testing purposes.... by DL4YHF
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef AmFmModH
#define AmFmModH

#include "SoundTab.h"   // some often uses tables for audio processing

//----------------------- Constants ---------------------------------------

// Number of cascaded decimation stages for the FFT input (in the "Big Buffer")
//     8 decimation stages may multiply by 3^8  =  6561
//    12 decimation stages may multiply by 3^12 = 531441
#define SoundUps_MAX_UPSAMPLING_STAGES  12

#define SOUND_DEMOD_TYPE_OFF    0
#define SOUND_DEMOD_TYPE_AM_DEM 1
#define SOUND_DEMOD_TYPE_FR_DEM 2
#define SOUND_DEMOD_TYPE_PH_DEM 3
#define SOUND_DEMOD_TYPE_AM_MOD 4
#define SOUND_DEMOD_TYPE_FR_MOD 5
#define SOUND_DEMOD_TYPE_PH_MOD 6
#define SOUND_DEMOD_TYPE_FREQ_SHIFTER 7


#define DEMOD_OPTION_NORMAL 0x0000
#define DEMOD_OPTION_AFC    0x0001

// 2004-10-24: It turned out that certain filters OSCILLATE when using "float"
//             but run properly when using "double" for the internal processing.
#define T_DEMOD_Float double

// ex: #define AM_FM_DEMOD_MAX_FILTER_COEFFS (2+2*20)  // until 2003-01-27
#define AM_FM_DEMOD_MAX_FILTER_COEFFS (2+2*30)



// Other 'often needed' stuff..
#ifndef  K_PI
 #define K_PI  (3.1415926535897932384626)
#endif



//**************************************************************************
//    Structures and Datatypes used in this module
//**************************************************************************
typedef struct
{
  T_Float dblFCenter;
  T_Float dblFSample;
  T_Float dblPhzInc;
  T_Float dblPhase;
} T_DeMod_NCO;


typedef struct
{
  int    iNrOfCoeffs;  // = 2*(filter_order+1)
  T_DEMOD_Float dblCoeffs[AM_FM_DEMOD_MAX_FILTER_COEFFS];  // originally [2 + 2*20]
  T_DEMOD_Float dblDelayZ[AM_FM_DEMOD_MAX_FILTER_COEFFS];
} T_AM_FM_DEMOD_FILTER;


//**************************************************************************
//    Global Vars (yucc)
//**************************************************************************



//**************************************************************************
//    Prototypes (no class methods)
//**************************************************************************

/***************************************************************************/
void SndUtl_InitNCO( T_DeMod_NCO *pNCO,
                    T_Float dblFCenter, T_Float dblFSample );



//***************************************************************************
//  Definition of the  CAmFmDeModulator   class
//***************************************************************************

class CAmFmDeModulator
{
public:
  CAmFmDeModulator();           // constructor without parameters
  virtual ~CAmFmDeModulator();  // destructor (cleans up)


  BOOL Init( int iDeModType,    // SOUND_DEMOD_TYPE_xxx
             int iOptions,      // DEMOD_OPTION_xxx (like AFC, etc)
          T_Float dblSampleRate, // often 11025, 22050 or 44100
          T_Float dblFCenter,    // Modulator or Demodulator Center Frequency [Hz]
          T_Float dblBandwidth,  // Modulator or Demodulator Bandwidth [Hz]
          T_Float dblModulatorFactor,   // relative modulation amplitude (0..1)
          T_Float dblModulatorCarrier); // relative carrier amplitude (0..1)
          // Prepares operation of the AM/FM modulator/demodulator.


  BOOL ProcessSamples( T_Float *pdblSource, T_Float *pdblDest, long lNrSamplePoints);
  // Runs a number of audio samples through a modulator/demodulator.



private:
  T_DeMod_NCO m_NCO;
  int m_iDeModType;
  int m_iDeModOptions;     // bitcombination, DEMOD_OPTION_AFC for example
  T_Float m_FltSamplingRate;
  T_Float m_FltBandwidth;   // for FM: "max. deviation from carrier to instantaneous frequency"
  T_Float m_FltModFactor;   // relative modulation amplitude (0..1)
  T_Float m_FltModCarrier;  // relative carrier amplitude (0..1)
  T_Float m_FltNco2Phase;

  T_Float m_FltPreviousDemodPhase;
  T_Float m_FltPrevI, m_FltPrevQ;
  int    m_iFreqDiscrState;
  T_Float m_FltAfcTuningRangeHz;  // max deviation of AFC'ed BFO frequency
  T_Float m_FltAfcTuningOffsetHz; // current AFC'ed offset, ideally zero

  T_AM_FM_DEMOD_FILTER m_Filter_I;
  T_AM_FM_DEMOD_FILTER m_Filter_Q;
  // The following filter structs contain coeffs and revious (n) values
  // for IIR lowpass (for Weaver method SSB,   and lowpass for phase demodulator, etc).
  // Often two identic filters are used for inphase (I) and quadrature (Q) branch.

}; // end class CAmFmDeModulator


#endif // AmFmModH
