// *****************************************************************************
// GA628.h
// Robert Tyrakowski
// dk7nt@darc.de
// 16.06.2005
// *****************************************************************************

// ACLK       		+: Out     Pin P2.0
// SDA             : In/Out  Pin P3.0
// SCL        	 	 : Out     Pin P3.1
// LCD-RST			 : OUT     Pin P3.2

// Include-Files
#include <msp430x12x2.h>
#include <msp430def.h>

// pin setup
#define aclk 0x01
#define scl  0x02
#define sda  0x01
#define lcd_rst  0x02

// pin functions
#define ACLK_On   P2SEL |= aclk;
#define ACLK_Off  P2SEL &= ~aclk;
#define ACLK_Low  P2OUT &= ~aclk;

#define SCL_L     P3OUT &= ~scl
#define SCL_H     P3OUT |= scl
#define SDA_L     P3OUT &= ~sda
#define SDA_H     P3OUT |= sda
#define SDA_DI    P3IN & sda
#define LCDRst_L  P3OUT &= ~lcd_rst
#define LCDRst_H  P3OUT |= lcd_rst

#define SDA_In    P3DIR &= ~sda
#define SDA_Out   P3DIR |= sda

// GA628 constant
const unsigned char Init_LCD[] = {0x74,0x00,0x31,0x02,0x05,0x08,0x30,0x0C,0x06,
	  		   				   	   0x02};

const unsigned char Clear_LCD[] = {0x74,0x00,0x30,0x01,0x0f};

const unsigned char Icons_ONOff[] = {0x74,0x80,0x4C,0x40,
                                     0x00, // 0x01...0x1F icon feldstrke
                                     0x00, // nix
	  		   					          0x00, // icon 0x10 2,0x08 tel unt., 
	  		   					          0x00, // icon_pfeil 0F -> oben, 0xF0 -> unten
								             0x00, // nix
	  		   					          0x00, // icon melodi
								             0x00, // brief
								             0x00, // nix
								             0x00, // Icon hrer
								             0x00, // nix
								             0x00, // Batterie innen
								             0x00, // Batterie aussen
								             0x0F,
								             0x10
								            };

// GA628 variables

unsigned char icon_feldstaerke;
unsigned char icon_1;
unsigned char icon_2;
unsigned char icon_pfeiloben;
unsigned char icon_pfeilunten;
unsigned char icon_melodie;
unsigned char icon_brief;
unsigned char icon_hoerer;
unsigned char icon_battinnen;
unsigned char icon_battaussen;

unsigned char strength;

unsigned char LCD_Buf[20];

