#ifndef VBI_H
#define VBI_H

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

typedef signed char s8;
typedef signed short s16;
typedef signed long s32;

#define PLL_SAMPLES     4       // number of err vals to collect
#define PLL_ERROR       4       // if this err val is crossed, readjust
#define PLL_ADJUST      4       // max/min adjust (10th of bitlength)

#define BAD_CHAR        0xb8    // substitute for chars with bad parity

struct vt_page
{
    int pgno, subno;    // the wanted page number
    int lang;           // language code
    int flags;          // misc flags (see PG_xxx below)
    int errors;         // number of single bit errors in page
    u32 lines;          // 1 bit for each line received
    u8 data[25][40];    // page contents
    int flof;           // page has FastText links
    struct {
        int pgno;
        int subno;
    } link[6];          // FastText links (FLOF)
};

struct vbi
{
    int fd;
//    struct cache *cache;
//    struct dl_head clients[1];
    int bufsize;		// 32*2k or 38*2k (depending on bttv version)
    u32 seq;
    struct vt_page page[8];	// one for each magazin
    struct vt_page *ppage;	// points to page of previous pkt0
    int pll_fixed;		// 0 = auto, 1..2*PLL_ADJUST+1 = fixed
    int pll_adj;
    int pll_dir;
    int pll_cnt;
    int pll_err, pll_lerr;
};

#define PG_SUPPHEADER   0x01    // C7  row 0 is not to be displayed
#define PG_UPDATE       0x02    // C8  row 1-28 has modified (editors flag)
#define PG_OUTOFSEQ     0x04    // C9  page out of numerical order
#define PG_NODISPLAY    0x08    // C10 rows 1-24 is not to be displayed
#define PG_MAGSERIAL    0x10    // C11 serial trans. (any pkt0 terminates page)
#define PG_ERASE        0x20    // C4  clear previously stored lines
#define PG_NEWSFLASH    0x40    // C5  box it and insert into normal video pict.
#define PG_SUBTITLE     0x80    // C6  box it and insert into normal video pict.
// my flags
#define PG_ACTIVE       0x100   // currently fetching this page

#define ANY_SUB         0x3f7f  // universal subpage number


#endif
