#!/usr/bin/perl -w
# display stock price data extracted from n-tv videotext
#   (c) 1999 Rolf Bleher <dk7in@qsl.net>          V1.16  05.08.99
#            http://www.qsl.net/dk7in
#--------------------------------------------------------------------------
#
# Legal Stuff:
#   shares.cgi is copyright 1999 by Rolf Bleher.
#
#   You may distribute this software to everyone in its unmodified form,
#   upload it to bbs'es, internet ftp sites etc., but you can not sell it.
#
#   I provide you this software on an "as is" basis which means that I give
#   you no warranty at all, and that I can not be held responsible for
#   damage caused to your software or hardware by this script.
#   If you decide to run it on your PC, you do it at your own risk.
#
#--------------------------------------------------------------------------
# 
# you need
#   perl to run this script
#   a supported TV card
#   a webserver (e.g. apache)
#   vbidecode (in bttv package) 
#                http://www.thp.uni-koeln.de/jkm/linux/bttv.html
#             or my patched version (with better decoding)
#                ftp://ftp.qsl.net/dk7in/vbidec-rb.tgz
#   vtx2ascii (in xawtv package)
#                http://www.in-berlin.de/User/kraxel/xawtv.html
#   vtx.cgi (xawtv) for displaying the contents of the adhoc messages
#             or my enhanced version
#                ftp://ftp.qsl.net/dk7in/vtx-rb.tgz
#
# install this script in your cgi directory (SuSE: /usr/local/httpd/cgi-bin)
# and call it with   http://yourserver/cgi-bin/shares.cgi?show=dax  ...
#
#--------------------------------------------------------------------------

use CGI qw(:standard);                   # if you don't have these, you
use CGI::Carp qw(fatalsToBrowser);       #  can download the modules from
use Time::Local;                         #  the perl CPAN archive

# config
$SPOOL="/var/spool/vtx/n-tv";            # vtx pages are stored here
$VTX2ASCII="/usr/local/bin/vtx2ascii";   # decoder program
$vtxhdr = "vtx.cgi/n-tv/";               # prefix for displaying adhoc messages

$debug = 0;
$show = param('show');

#--------------------------------------------------------------------------

if ($show eq '') {
$pagnam = 'Error';                          # display help text
@shares = (("############","######",5,20,"######",    0));
}

#--------------------------------------------------------------------------

if ($show eq 'test') {
$debug  = 1;
$pagnam = 'Test';
@shares = (("AC Service  ","223-01",5,20,"",          0),
           ("Adcon Tele  ","223-01",5,20,"",          0),
           ("Brain Force ","223-02",5,20,"",          0));
}

#--------------------------------------------------------------------------

# bei Seiten mit '-' statt '_' wird die passende Unterseite gesucht
# dies ist notwendig wegen sich ndernder Anzahl von Werbeseiten

if ($show eq 'dax') {
$pagnam = 'DAX';                                        # Stand 12.07.99
@shares = (("Adidas      ","270_00",6,20,"Adidas",    0),
           ("Allianz     ","270_00",6,20,"",          0),
           ("BASF        ","270_00",6,20,"",          0),
           ("Bayer       ","270_00",6,20,"",          0),
           ("BMW St.     ","270_00",6,20,"",          0),
           ("Commerzbank ","270_00",6,20,"",          0),
           ("DaimlerChrys","270_00",6,20,"Daimler",   0),
           ("Degussa     ","270_00",6,20,"Degussa",   0),
           ("Dresdner B  ","270_00",6,20,"",          0),
           ("Dt. Bank    ","270_00",6,20,"",          0),
           ("Dt. Telekom ","270_00",6,20,"",          0),
           ("Henkel Vz.  ","270_00",6,20,"",          0),
           ("Hoechst     ","270_00",6,20,"",          0),
           ("HypoVereinsB","270_00",6,20,"Hypo",      0),
           ("Karstadt    ","270_00",6,20,"",          0),
           ("Linde       ","271_00",6,20,"",          0),
           ("Lufthansa   ","271_00",6,20,"",          0),
           ("MAN St.     ","271_00",6,20,"",          0),
           ("Mannesmann  ","271_00",6,20,"",          0),
           ("Metro       ","271_00",6,20,"",          0),
           ("Mnchener R ","271_00",6,20,"nchener R", 0),
           ("Preussag    ","271_00",6,20,"",          0),
           ("RWE St.     ","271_00",6,20,"",          0),
           ("SAP Vz.     ","271_00",6,20,"",          0),
           ("Schering    ","271_00",6,20,"",          0),
           ("Siemens     ","271_00",6,20,"",          0),
           ("ThyssenKrupp","271_00",6,20,"Thyssen ",  0),
           ("VEBA        ","271_00",6,20,"",          0),
           ("VIAG        ","271_00",6,20,"",          0),
           ("VW St.      ","271_00",6,20,"",          0));
#            Name            page  lines  search      |
#                              0: Prozent, 1: Kassa --'
}

#--------------------------------------------------------------------------

if ($show eq 'depot') {
$pagnam = 'Depot';
@shares = (
           ("------------","------",5,20,"------",    0),
           ("------------","------",5,20,"------",    0),
           ("Dax         ","201_00",5,20,"",          0),
           ("Neuer Markt ","202_00",5,20,"NEMAX All", 0),
           ("S&P Future  ","201_00",5,20,"",          0),
           ("Dow Jones   ","201_00",5,20,"Dow",       0),
           ("Nasdaq      ","201_00",5,20,"Nasdaq",    0));
}

#--------------------------------------------------------------------------

if ($show eq 'idx') {
$pagnam = 'Indizes';
@shares = (("Dax         ","201_00",5,20,"",          0),
           ("NEMAX 50    ","201_00",5,20,"NEMAX50",   0),
           ("Neuer Markt ","202_00",5,20,"NEMAX All", 0),
           ("Euro-Stoxx  ","201_00",5,20,"",          0),
           ("------------","------",5,20,"------",    0),
           ("Dow Jones   ","201_00",5,20,"Dow",       0),
           ("Nasdaq      ","201_00",5,20,"Nasdaq",    0),
           ("S&P Future  ","201_00",5,20,"",          0),
           ("------------","------",5,20,"------",    0),
           ("Tokio       ","204_00",5,20,"Tokio ",    0),
           ("Sydney      ","204_00",5,20,"Sydney ",   0),
           ("Singapur    ","206_00",5,20,"",          0),
           ("Hongkong    ","204_00",5,20,"",          0));
}

#--------------------------------------------------------------------------

if ($show eq 'nemax50') {
$pagnam = 'Neuer Markt 50';                                # Stand 05.08.99
@shares = (("1&1         ","219_00",5,20,"",          0),
           ("Adva Optic  ","219_00",5,20,"",          0),
           ("Aixtron     ","219_00",5,20,"",          0),
           ("Artnet.com  ","219_00",5,20,"",          0),
           ("Basler      ","219_00",5,20,"",          0),
           ("BB Biotech  ","219_00",5,20,"",          0),
           ("BinTec Com  ","219_00",5,20,"",          0),
           ("Brain Inte  ","219_00",5,20,"",          0),
           ("Brokat      ","219_00",5,20,"",          0),
           ("CE Consume  ","219_00",5,20,"",          0),
           ("Cinemedia   ","219_00",5,20,"",          0),
           ("Consors     ","219_00",5,20,"",          0),
           ("CPU Softwa  ","219_00",5,20,"",          0),
           
           ("Cybernet    ","220_00",5,20,"",          0),
           ("Edel Music  ","220_00",5,20,"",          0),
           ("EM-TV       ","220_00",5,20,"",          0),
           ("Endemann    ","220_00",5,20,"",          0),
           ("Fortunecity ","220_00",5,20,"",          0),
           ("Heyde       ","220_00",5,20,"",          0),
           ("Highlight   ","220_00",5,20,"",          0),
           ("I:FAO       ","220_00",5,20,"",          0),
           ("IDS Scheer  ","220_00",5,20,"",          0),
           ("Infomatec   ","220_00",5,20,"",          0),
           ("Infor       ","220_00",5,20,"",          0),
           ("Intershop   ","220_00",5,20,"",          0),
           ("Intertainmen","220_00",5,20,"",          0),
           
           ("Ixos        ","221_00",5,20,"",          0),
           ("Jumptec     ","221_00",5,20,"",          0),
           ("Kinowelt    ","221_00",5,20,"",          0),
           ("LHS         ","221_00",5,20,"",          0),
           ("MB Software ","221_00",5,20,"",          0),
           ("Medion      ","221_00",5,20,"",          0),
           ("Micrologic  ","221_00",5,20,"",          0),
           ("Mobilcom    ","221_00",5,20,"",          0),
           ("Nemetschek  ","221_00",5,20,"",          0),
           ("NSE Softwa  ","221_00",5,20,"",          0),
           ("Pfeiffer V  ","221_00",5,20,"",          0),
           ("Primacom    ","221_00",5,20,"",          0),
           
           ("Qiagen      ","222_00",5,20,"",          0),
           ("Realtech    ","222_00",5,20,"",          0),
           ("SCM Micros  ","222_00",5,20,"SCM Micr",  0),
           ("Senator Film","222_00",5,20,"",          0),
           ("SER System  ","222_00",5,20,"",          0),
           ("Singulus    ","222_00",5,20,"",          0),
           ("Steag Hama  ","222_00",5,20,"",          0),
           ("Teldafax    ","222_00",5,20,"",          0),
           ("Telegate    ","222_00",5,20,"",          0),
           ("Teleplan    ","222_00",5,20,"",          0),
           ("Teles       ","222_00",5,20,"",          0),
           ("Utimaco     ","222_00",5,20,"",          0));
}

#--------------------------------------------------------------------------

if ($show eq 'neumarkt') {
$pagnam = 'Neuer Markt';                                   # Stand 05.08.99
@shares = (("AAP Implant ","223-01",5,20,"",          0),
           ("AC Service  ","223-01",5,20,"",          0),
           ("ACG         ","223-01",5,20,"",          0),
           ("Adcon Tele  ","223-01",5,20,"",          0),
           ("Articon     ","223-01",5,20,"",          0),
           ("AT&S Austr  ","223-01",5,20,"",          0),
           ("Augusta     ","223-01",5,20,"",          0),
           ("B.I.S.      ","223-01",5,20,"",          0),
           ("BB Medtech  ","223-01",5,20,"",          0),
           ("Beko        ","223-01",5,20,"",          0),
           ("Bertrandt   ","223-01",5,20,"",          0),
           ("Beta System ","223-01",5,20,"",          0),
           
           ("Brain Force ","223-02",5,20,"",          0),
           ("Buecher.de  ","223-02",5,20,"",          0),
           ("CE Compute  ","223-02",5,20,"",          0),
           ("Cenit       ","223-02",5,20,"",          0),
           ("Centrotec   ","223-02",5,20,"",          0),
           ("Ceotronics  ","223-02",5,20,"",          0),
           ("Computec M  ","223-02",5,20,"",          0),
           ("Computerli  ","223-02",5,20,"",          0),
           ("COR         ","223-02",5,20,"",          0),
           ("D.Logistic  ","223-02",5,20,"",          0),
           ("Datadesign  ","223-02",5,20,"",          0),
           
           ("Drillisch   ","224-01",5,20,"",          0),
           ("Dt. Entert  ","224-01",5,20,"",          0),
           ("Easy Softw  ","224-01",5,20,"",          0),
           ("Eckert & Z  ","224-01",5,20,"",          0),
           ("Elsa        ","224-01",5,20,"",          0),
           ("Emprise     ","224-01",5,20,"",          0),
           ("Euromed     ","224-01",5,20,"",          0),
           ("Euromicron  ","224-01",5,20,"",          0),
           ("Foris       ","224-01",5,20,"",          0),
           ("Fortec      ","224-01",5,20,"",          0),
           ("GFT Tech.   ","224-01",5,20,"",          0),
           ("Graphisoft  ","224-01",5,20,"",          0),
           
           ("Haitec      ","224-02",5,20,"",          0),
           ("Hancke & P  ","224-02",5,20,"",          0),
           ("Hft & Wes  ","224-02",5,20,"ft & Wes",  0),
           ("Hunzinger   ","224-02",5,20,"",          0),
           ("Internet M  ","224-02",5,20,"",          0),
           ("I-D Media   ","224-02",5,20,"",          0),
           ("Kabel New   ","224-02",5,20,"",          0),
           ("Kleindienst ","224-02",5,20,"",          0),
           ("Lintec Com  ","224-02",5,20,"",          0),
           ("Lobster Te  ","224-02",5,20,"",          0),
           ("LPKF Laser  ","224-02",5,20,"",          0),
           ("Man.Data S  ","224-02",5,20,"",          0),

           ("Mania       ","225-01",5,20,"",          0),
           ("Maxdata     ","225-01",5,20,"",          0),
           ("Mensch & M  ","225-01",5,20,"",          0),
           ("Metabox     ","225-01",5,20,"",          0),
           ("Micronas    ","225-01",5,20,"",          0),
           ("MorphoSys   ","225-01",5,20,"",          0),
           ("Mosaic Sof  ","225-01",5,20,"",          0),
           ("Mhl PS     ","225-01",5,20,"hl PS   ",  0),
           ("Mhlbauer   ","225-01",5,20,"hlbauer ",  0),
           ("MWG Biotec  ","225-01",5,20,"",          0),
           ("Netlife     ","225-01",5,20,"",          0),
           ("Odeon Film  ","225-01",5,20,"",          0),
           ("P & I       ","225-01",5,20,"",          0),
           ("Pankl Racin ","225-01",5,20,"",          0),
           
           ("Parsytec    ","225-02",5,20,"",          0),
           ("Plambeck    ","225-02",5,20,"",          0),
           ("Plenum      ","225-02",5,20,"",          0),
           ("Prodacta    ","225-02",5,20,"",          0),
           ("Prout       ","225-02",5,20,"",          0),
           ("PSB         ","225-02",5,20,"",          0),
           ("PSI         ","225-02",5,20,"",          0),
           ("Refugium    ","225-02",5,20,"",          0),
           ("Rhein Biot  ","225-02",5,20,"",          0),
           ("Ricardo.de  ","225-02",5,20,"",          0),
           ("RTV         ","225-02",5,20,"",          0),
           
           ("Sachsenring ","226-01",5,20,"Sachsenr",  0),
           ("Saltus      ","226-01",5,20,"",          0),
           ("Sanochemia  ","226-01",5,20,"",          0),
           ("SHS Infosys ","226-01",5,20,"",          0),
           ("Silicon Sen ","226-01",5,20,"",          0),
           ("Soft M      ","226-01",5,20,"",          0),
           ("Softmatic   ","226-01",5,20,"",          0),
           ("Sss Micro  ","226-01",5,20,"",          0),
           ("SVC         ","226-01",5,20,"",          0),
           ("SZ Testsyst ","226-01",5,20,"",          0),
           
           ("TDS         ","226-02",5,20,"",          0),
           ("Teamwork    ","226-02",5,20,"",          0),
           ("Technotrans ","226-02",5,20,"",          0),
           ("Tepla       ","226-02",5,20,"",          0),
           ("Tiptel      ","226-02",5,20,"",          0),
           ("Transtec    ","226-02",5,20,"",          0),
           ("Tria Softw  ","226-02",5,20,"",          0),
           ("TTL         ","226-02",5,20,"",          0),
           ("Vectron     ","226-02",5,20,"",          0),
           ("WET         ","226-02",5,20,"",          0),
           ("Wizcom      ","226-02",5,20,"",          0),
           ("WWL Intern  ","226-02",5,20,"",          0));
}

#--------------------------------------------------------------------------

# Array with search text to identify adhoc messages
@adhsrch = ("Adidas",              # interessierende Aktien
            "Allianz",             # Adhoc Messages
            "BASF");

@adhpag = ("460_00","461_00");              # Seiten mit bersicht
@adhloc = (6,17);                           # Datenbereich  -16?

#--------------------------------------------------------------------------

###########################################################################
# main

%seen = ();
@out  = ();

$time = (sprintf "%2d",(localtime)[2]).":".(sprintf "%02d",(localtime)[1]);
$sep = "-------------------------------------------------------\n";
push @out, "Aktien  $time    Kurs    Diff    Proz   Kassa  Zeit Dly\n";
push @out, $sep;

while (@shares >= 6) {                      # fuer alle Aktien
  @share = splice(@shares,0,6);
  if ($share[1] eq '######') {
    disphelp();                             # diplay help
    next
  }
  if ($share[1] eq '------') {
    push @out, $sep;                        # show extra separator line
    next
  }
  $text = $share[0];
  if ($share[4] eq '') {                    # identischer Suchtext
    $share[4] = substr $text, 0, 10;
  }
  @vtxl = getpage($share[1]);               # read vtx page
  if (@vtxl) {
    $delay = dly2str(vtxdelay($vtxl[0]));   # Delay aus VTX header
    @dat = getline('');                     # init
    for ($i = $share[2]-1; $i < $share[3]; $i++) {  # Datenbereich
      if ($vtxl[$i] =~ /($share[4])(.*)/) {
        @dat = getline($vtxl[$i]);          # data separation
        last                                # gefunden, naechste Aktie
      }
    }
    $dat[5] = $delay;
    $line = $text;
    for ($i=0; $i < @dat; $i++) {
      $line .= ' '.$dat[$i];
    }
    $line = linecol($line,$dat[2]);         # colorize lines
    push @out, $line."\n";
  } else {
    push @out, $text."    Page ".$share[1]." is missing!\n";
    next;
  }
}
push @out, $sep;
start_page($pagnam);
print @out;
adhmsg();                                   # process adhoc messages
&finish_page;
exit;

#--------------------------------------------------------------------------

sub getpage ($) {                              # load vtx page
  my ($page) = @_;
  my @vtxl = ();
  my @vtxl2 = ();
  $skip = ($page =~ /-/);                      # skip subpages
  debprt("\n-getpage---- $page\n");
  $page .= ".vtx";
  if ($seen{$page}) {                          # stored page ?
    $vtxp = $seen{$page};
    @vtxl = split(/\n/,$vtxp);
    debprt("-getpage---- $page read from hash\n");
  } elsif (($dupe = $page) =~ s/00.vtx/01.vtx/ && $seen{$dupe} ) {
    $page = $dupe;                             # only 01 instead of 00 available
    $vtxp = $seen{$page};
    @vtxl = split(/\n/,$vtxp);
    debprt("-getpage---- $page read from hash (01 for 00)\n");
  } else {                                     # have to read from disk
    # if single page 00, test subpage 01
    if (($dupe = $page) =~ s/_00.vtx/_01.vtx/) {  # is 00, test 01
      if ( -f "$SPOOL/$dupe") {
        if ( -f "$SPOOL/$page") {              # test age:
           if ( -M "$SPOOL/$station/$page" > -M "$SPOOL/$station/$dupe" ) {
             $page = $dupe;                    # 01 is newer
             debprt("-getpage---- $page (01 is newer than 00)\n");
           }
        } else {
          $page = $dupe;                       # only 01 available
          debprt("-getpage---- $page (only 01 is avaiable)\n");
        }
      }
    }
    ($rpag = $page) =~ s/-/_/;
    debprt("-getpage---- $rpag test\n");
    if ( -f "$SPOOL/$rpag") {                  # page is not missing
      debprt("-getpage---- $rpag read\n");
      open(VTX,"$VTX2ASCII -a $SPOOL/$rpag |");
      undef $/;
      $vtxp = <VTX>;                           # read page
      close(VTX);
      $/ = "\n";
      @vtxl = split(/\n/,$vtxp);

      # if subpage, skip doubled pages
      if ($skip) {
        $rpag =~ /(\d{3})_(\d\d).vtx/;
        $pgnr = $1;
        $sub  = $2 + 0;
        $fpg  = $sub;
        $spg  = subpagnr($vtxl[1]) + 0;        # Sub-Nr aus VTX header
        $vtxp2 = $vtxp;
        $stpg = $rpag;
        while ($spg < $sub) {
          $fpg++;
          $rpag = $pgnr.'_'.(sprintf "%02d",$fpg).'.vtx';
          debprt("--sub------- $rpag test\n");
          last if (!(-f "$SPOOL/$rpag"));
          debprt("--sub------- $rpag read\n");
          open(VTX,"$VTX2ASCII -a $SPOOL/$rpag |");
          undef $/;
          $vtxp2 = <VTX>;                       # read page
          close(VTX);
          $/ = "\n";
          @vtxl2 = split(/\n/,$vtxp2);
          $spg  = subpagnr($vtxl2[1]);
        }
        if ($spg == $sub) {
          $vtxp = $vtxp2;
          @vtxl = split(/\n/,$vtxp);
          debprt("--sub------- $rpag subpage $sub found\n");
        } else {
          $rpag = $stpg;
          debprt("--sub------- $stpg subpage $sub not found\n");
        }
      }
      $seen{$page} = $vtxp;                    # page may be needed again
    }
    else {
      debprt("-getpage---- $rpag not found\n");
    }
  }
  return(@vtxl);
}

#--------------------------------------------------------------------------

@WEEK = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
@MON  = ('Jan','Feb','Mar','Apr','May','Jun',
         'Jul','Aug','Sep','Oct','Nov','Dec');

sub time2str {
    @tm    = gmtime($_[0]);
    sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
            $WEEK[$tm[6]],$tm[3],$MON[$tm[4]],$tm[5]+1900,$tm[2],$tm[1],$tm[0]);
}

#--------------------------------------------------------------------------

sub start_page {
    my ($title) = @_;
#    if ($file ne "") {            # ????
#        @inode = stat $file;
#        printf("Last-modified: %s\n",time2str($inode[9]));
#    }
    print <<EOF;
Content-Type: text/html

<html>
<head>
<title>$title</title>
<META HTTP-EQUIV="refresh" CONTENT="60">
</head>
<style type="text/css"> <!--
font.w0 {background-color:#FFFFEE}
font.wx {background-color:#DDDDDD}
font.g1 {background-color:#CCFFCC}
font.g2 {background-color:#B0FFB0}
font.g3 {background-color:#98FF98}
font.g4 {background-color:#80FF00}
font.r1 {background-color:#FFCCCC}
font.r2 {background-color:#FFB0B0}
font.r3 {background-color:#FF9898}
font.r4 {background-color:#FF8080}
//--> </style>
<body bgcolor=#FFFFDD color=black><pre>
EOF
}

#"
#--------------------------------------------------------------------------

sub finish_page {
    print "</pre></body></html>\n";
}

#--------------------------------------------------------------------------

sub debprt ($) {
    my ($text) = @_;
    if ($debug) {
      print $text;
    }
}

#--------------------------------------------------------------------------

sub panic {
    my ($text) = @_;
    start_page("PANIC");
    print "<h2>PANIC</h2>$text";
    &finish_page;
    exit;
}

#--------------------------------------------------------------------------

sub linecol ($$) {                          # colored lines for +/-
  my ($line,$proz) = @_;
  my $chng = $proz;   
  if ($chng =~ /\s*([+-]?\d+,\d+)%/) {
    ($chng = $1) =~ s/,/./;
    if      ($chng >   0.05) {                # positive -> green
      if    ($chng >=  15.0) { $font = "g4" }
      elsif ($chng >=  10.0) { $font = "g3" }
      elsif ($chng >=   5.0) { $font = "g2" }
      else                   { $font = "g1" }
    } elsif ($chng <  -0.05) {                # negative -> red
      if    ($chng <= -15.0) { $font = "r4" }
      elsif ($chng <= -10.0) { $font = "r3" }
      elsif ($chng <=  -5.0) { $font = "r2" }
      else                   { $font = "r1" }
    } else                   { $font = "w0" } # no change -> white
  } else                     { $font = "wx" } # missing
  return("<font class=$font>".$line."</font>");
}

#--------------------------------------------------------------------------

sub vtxdelay ($) {                            # Delay der VTX page
  my ($head) = @_;                            # aus Header
  my $vhr  = substr $head, 32, 2;
  my $vmin = substr $head, 35, 2;
  my $vsec = substr $head, 38, 2;
  my $vmon = substr $head, 28, 3;
  my $vday = substr $head, 25, 2;
  $vmon = month2nr($vmon);                    # MonName -> Nr
  my $vdif = time()-timelocal($vsec,$vmin,$vhr,$vday,$vmon,(localtime)[5]);
  return $vdif;
}

#--------------------------------------------------------------------------

sub dly2str ($) {                           # convert delay to string
  my ($vdif) = @_;                          # delay in seconds
  my $delay = "   ";
  if ($vdif > 1) {
    if ($vdif < 90)       { $delay = sprintf "%2ds",$vdif }
    else {
      $vdif /= 60;
      if ($vdif < 90)     { $delay = sprintf "%2dm",$vdif }
      else {
        $vdif /= 60;
        if ($vdif < 90)   { $delay = sprintf "%2dh",$vdif }
        else {
          $vdif /= 24;
          if ($vdif < 45) { $delay = sprintf "%2dd",$vdif }
          else            { $delay = ">1M" }
        }
      }
    }
  }
  return $delay;
}

#--------------------------------------------------------------------------

sub month ($) {
  my ($i) = @_;
  return ('Jan','Feb','Mar','Apr','Mai','Jun','Jul','Aug','Sep','Okt','Nov','Dez')[$i];
}

#--------------------------------------------------------------------------

sub month2nr ($) {               # convert month name to index number 0..11
  my ($vmon) = @_;
  for ($i=0;$i<12;$i++) {                   # MonName -> Nr
    if ($vmon eq month($i)) {
      $vmon = $i;
      last;
    }
  }
  return $vmon;
}

#--------------------------------------------------------------------------

sub subpagnr ($) {                            # Subpage der VTX page
  my ($head) = @_;                            # aus Header
  my $sub = 0;
  if ($head =~ /\s*(\d+)\/(\d+)/) {
    $sub = $1;
  }
  return $sub;
}

#--------------------------------------------------------------------------

sub diff2prz ($$) {                  # calculate percentage
  my ($last,$diff) = @_;
  my $proz = "       ";
  if ($last ne '       ') {
    $last =~ s/,/./;
    $diff =~ s/,/./;
    if ($diff =~ /^\s+$/) {
      $diff = 0;
    }
    my $old = $last - $diff;
    if ($old > 0.001) {
      $proz = sprintf "%+5.1f", 100 * $diff / $old;
      $proz =~ s/\./,/;
      $proz .= "%";
    }
  }
  return $proz;
}

#--------------------------------------------------------------------------

sub adhmsg () {
  my @msg = ();
  my @delay = ();
  my ($i,$j,@vtxl,$text);
  for ($i=0; $i<@adhpag; $i++) {                # read all Adhoc messages
    @vtxl = getpage($adhpag[$i]);
    last if (! @vtxl);
    $delay[$i] = vtxdelay($vtxl[0]);            # Delay aus VTX header
    if (($i==0) || ($delay[$i] - $delay[$i-1] lt 10*60)) {
      for ($j=$adhloc[0]-1; $j < $adhloc[1]; $j++) {
        if (!($vtxl[$j] =~ /^\s*$/)) {
          push @msg, $vtxl[$j];
        }
      }
    }
  }
  my @found = ();                               # analyze messages
  for ($i=0; $i < @msg; $i++) {
    for ($j=0; $j < @adhsrch; $j++) {
      if ($msg[$i] =~ /$adhsrch[$j]/) {
        $text = $msg[$i];
        $text =~ s/^\s*(.*)\s?\.+\s*(\d{3})\s*$/$1  <a href=$vtxhdr$2_00.vtx>$2<\/a>/;
        push @found, "Adhoc-Msg  $text ".dly2str($delay[0]);
      }
    }
  }
  for ($i=0; $i < @found; $i++) {
    print "<font class=r4>".$found[$i]."</font>\n";
  }
}

#--------------------------------------------------------------------------
# es mu nicht immer ein Kassa-Kurs geben, dito Diff
# 31: Kassa / Proz
# 23: Diff
# 15: Last
# init data, when called with ''

sub getline ($) {                       # set up array with data
  my ($line) = @_;
  if ($line) {
    $line = substr($line,0,34) . ' ' . substr($line,35);
  }
  my @word = split(/\s+/,$line);
  if (@word < 2) {                      # no valid data
    $last = '';
    $diff = '';
    $kass = '';
    $proz = '';
    $time = '     ';  
  } else {
   if (substr($line,31,1) eq ' ') {      # Kassa / Proz
     splice @word, @word-1, 1, ('',$word[@word-1])
   }
   if (substr($line,23,1) eq ' ') {      # Diff
     splice @word, @word-2, 1, ('',$word[@word-2])
   }
   if (substr($line,15,1) eq ' ') {      # Last
     splice @word, @word-3, 1, ('',$word[@word-3])
   }
    while (@word > 5) {
      my @first = splice(@word,0,1);
    }
    ($last = $word[1]) =~ s/;/,/;
    ($diff = $word[2]) =~ s/;/,/;
    $time  = $word[4];
  
    if ($share[5] > 0) {                # 1: Kassa, 0: Prozent
      ($kass = $word[3]) =~ s/;/,/;
      $proz = diff2prz($last,$diff);    # calc percentage
    } else {
      ($proz = $word[3]) =~ s/;/,/;
      $kass = '';
    }
  }
  while (length($last) < 8) { $last = ' '.$last }
  while (length($diff) < 7) { $diff = ' '.$diff }
  while (length($kass) < 7) { $kass = ' '.$kass }
  while (length($proz) < 7) { $proz = ' '.$proz }
  while (length($time) < 5) { $time = ' '.$time }
  return ($last,$diff,$proz,$kass,$time);
}

#--------------------------------------------------------------------------

sub disphelp {
  push @out, "Parameter missing!\n";
  push @out, "  e.g. shares.cgi?show=dax\n";
  push @out, "       shares.cgi?show=idx\n";
  push @out, "       shares.cgi?show=neumarkt\n";
  push @out, "       shares.cgi?show=nemax50\n";
  push @out, "       shares.cgi?show=depot\n";
  return;
}

#--------------------------------------------------------------------------


