/*
 *   time.c read from serial port.
 *
 *   Copyright 1997        quacks@paula.owl.de (Joerg Krause)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "dcf77.h"

extern char *port;
extern int  cmos;
extern char *version;
extern int rtc;
extern int fd;

void startclock( void )
{
  int count;
  int n=0;
  char c;
  char databuf[61];
  
  /* open the correct port */

  if (( fd = open(port, O_RDWR)) < 0)
  {
    writelog( LOG_ERR, "Failed to open serial port. Quitting.");
    exit(1);
  }

  if ((rtc=open("/dev/rtc", O_RDWR))==-1)
  {
    writelog(LOG_ERR,"Failed to open /dev/rtc. Compile kernel with CONFIG_RTC");
    cmos = FALSE;
    writelog(LOG_ERR,"CMOS update disabled");
  }
  
  /* Initialize Serial Port */
  open_term(fd);

  /* read garbage */
  sleep(2);
  ioctl(fd,FIONREAD, &count);
  while(count-- > 0)
  {
    read(fd,&c,1);
  }

  /* wait for device ready */
  sleep(30);
  ioctl(fd,FIONREAD, &count);
  if (count < 1)           /* there should be clock pulses */
  {
    writelog(LOG_ERR, "Clock isn't responding. Quitting.");
    Done(0);
  }
  
  /* Set the correct timezone */
  tzset();

  while(1)
  {
    nport.c_cc[VMIN]  =0 ;
    nport.c_cc[VTIME] =15;

    ioctl(fd,TCSETS, &nport);
    count=read(fd,&c,1);       /* read next chr from serial port */

    if (count < 0)
    {
      writelog(LOG_ERR,"Clock isn't readable. Quitting.");
      Done(0);
    }
    else
    {
      if (count == 0 || n > 59)    /* Daten auswerten... */
      {
	if (n == 0)
	{
          writelog(LOG_NOTICE,"Received no clock pulse");
        }
	else if (n < 59)      /* missing bits */
	{
	  writelog(LOG_NOTICE,"Received not enough clock pulses.");
	}
	else                  /* n == 59, that's ok */
	{  
	  ParseDCFdata(databuf);
	}
	n=0;                  /* start again collecting bits */
      }
      else
      {
        databuf[n] = c >= 0x20 ? 0: 1;   /* store bit in buffer */
	n++;
      }
    }
  }
  Done(0);
}
        /*
       50 Baud 6,N,1
       
       0  10    30    50    70    90   110   130   150   170   190  [ms]
       +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
       |  0  | B0  | B1  | B2  | B3  | B4  | B5  |  1  |  1  |  1  |
       +-----+-----+-----+-----+-----+-----+-----+-----+-----+-----+
      100000000000000000000001111111111111111111111111111111111111111 > 0x38 0
      100000000000000000000000000000011111111111111111111111111111111 > 0x30 0
      100000000000000000000000000000000000000011111111111111111111111 > 0x20 0
      100000000000000000000000000000000000000000000000000001111111111 > 0x00 1
       */
