/*
 *   termios.c open and close the serial port.
 *
 *   Copyright 1997        quacks@paula.owl.de (Joerg Krause)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "dcf77.h"

void open_term(int fd)
{
  int line;
  
  ioctl(fd, TCGETS, &oport);	/* Get old modes to save later */
  ioctl(fd, TCGETS, &nport);	/* Get old modes to change them */

  nport.c_cflag &=  ~CBAUD;
  nport.c_cflag |=   B50;       /* 50 baud */
  nport.c_cflag &=  ~CSIZE;
  nport.c_cflag |=   CS6;       /* 6 bit/chr */
  nport.c_cflag &=   ~PARENB;
  nport.c_cflag |=   CLOCAL | CREAD;
  nport.c_cflag &=  ~CRTSCTS;   /* hardware handshake ? */
  
  nport.c_lflag &= ~(ICANON|ECHO);
  nport.c_cc[VMIN]  = 1;
  nport.c_cc[VTIME] = 0;	
  
  ioctl(fd, TCSETS, &nport); 	/* Set  new  modes	*/
  
  
  ioctl(fd, TIOCMGET, &line);	
/*  line &= ~TIOCM_DTR;	 */       /* switch DTR off	*/
  line |=  TIOCM_DTR;	        /* switch DTR on	*/
  line |=  TIOCM_RTS; 		/*   "    RTS on	*/
  ioctl(fd, TIOCMSET, &line);
}

void close_term(int fd)
{
  ioctl(fd, TCSETS, &oport);	/* Set  old  modes	*/
  close(fd);
}
