'**********************************************************
'Compiler            : BASCOM-AVR
'Hardware            : TLC549 Data  - an PB.0
'                             Clock - an PB.1
'                             CS    - an PB.2
'Chip type
           : AT90S2313
'**********************************************************

$regfile = "2313def.dat"              'AT90S2313
$crystal = 3579545                    'Quarz 3.579MHz

Ddrb.0 = 0                            'Pin PB0 ist Eingang 
Portb.0 = 1                           'Pullup von PB0 ein
Ddrb.1 = 1                            'Pin PB1 ist Ausgang
Ddrb.2 = 1                            'Pin PB2 ist Ausgang
 
Dat Alias Pinb.0                      'Alias-Namen vergeben fr Ports   
Clk Alias Portb.1                     'Alias-Namen vergeben fr Ports
Cs Alias Portb.2                      'Alias-Namen vergeben fr Ports

Dim I As Byte                         'Variablennamen und Typ festlegen
Dim Adbit As Byte
Dim Ad As Word
Dim U As Integer

Lcd "TLC549 Data-PB.0"               'Ausgabe des Textes auf LCD
Locate 2 , 1                         'LCD-Cursor auf Zeile2, Spalte1
Lcd "CS-PB.2 Clk-PB.1"               'Ausgabe des Textes auf LCD
Wait 3                               'warte 3 Sekunden
Cls                                  'lsche LCD
Set Cs                               'Cs auf High setzen
Do                                   'Beginn der Schleife
  Adbit = 0 : Ad = 0
  Reset Clk                          'Clk auf Low setzen
  Reset Cs                           'Cs auf Low setzen 
  Waitus 2                           '1.4 s Mindestwartezeit bis Daten anliegen
  For I = 1 To 8                     'bis 8 Bits einlesen
    Set Clk                          'Clk auf High setzen
    Shift Ad , Left                  'Schiebe Bits in Ad nach links
    Ad = Ad + Dat                    'hnge empf. Bit an Ad an
    Reset Clk                        'Clk auf Low setzen
  Next                               'nchstes Bit
  Shift Ad , Left                    'AD-Wert*2 (nur fr 5V Referenzspannung) 
  Set Cs                             'Cs auf High setzen
  Set Clk                            'Clk auf High setzen
  Cls                                'lsche LCD
  U = Ad / 100                       'Vorkommawert abtrennen
  Lcd "Spannung: " ; U ; "."         'Vorkommawert auf Lcd ausgeben
  U = Ad Mod 100                     'Nachkommawert abtrennen
  Lcd U ; " V"                       'Nachkommawert auf Lcd ausgeben
  Wait 1                             'warte 3 Sekunden
Loop                                 'zum Beginn der Schleife

End


