;************ < 9.5.00 > **************** < pub_tone.asm > **************
;                                                                       *
;             Beacon for CW  using PIC12C508                            *
;             Antonio Sergio Sena  CT2GPW                               *
;             asena@bigfoot.com                                         *
;                                                                       *
***********************************************************************************
* This software is available only for non-commercial amateur radio or educational *
* applications. All other uses are prohibited. This software may be modified only *
* if the resulting code be made available publicly and the original author given  *
* credit. Contact the author for information on commercial licenses.		  *
* (c) Copyright 2000, Antonio Sergio Sena. CT2GPW. All rights reserved.		  *
***********************************************************************************
;************************************************************************

	list    p=12c508a

	radix   hex

;**********************************************
tmr0    equ     0x01
pc      equ     0x02
status  equ     0x03
osccal	equ	0x05
gpio	equ	0x06
;
	CBLOCK  0x10
		minuto, count, ncount, mcount, cnttmr0
		cnttab, job, valor_letra, count_letra
		n_digitos, letra, cnttmr02, cnt_25segs
	ENDC
;
#define z       status, 2
#define c       status, 0
#define out     gpio, 0
#define out_mon gpio, 1
#define out_ptt	gpio, 5
;
limpar_registos         macro   
	clrf	gpio
	clrf    minuto          ;
	clrf    count           ;
	clrf    mcount          ;
	clrf    ncount          ;
	clrf    cnttmr0         ;
	clrf    cnttmr02
	clrf    cnttab          ;
	clrf    job             ;
	clrf    count_letra     ;
	clrf    valor_letra     ;
	clrf    n_digitos       ;
	clrf    letra           ;
	clrf	cnt_25segs	;
	endm


	__CONFIG 0xfea

;************************************************************************
	org     0x000           ;
	movwf	osccal
	goto    start           ;


;**************************************
table_frase 
	addwf   pc, f           ;


;************************************************************************
;************************************************************************
;                                                                       *
;                                                                       *
;                                                                       *
;       Code zone, where you insert the phrase to be transmited         *
;               in morse. Substitute ???? by the phrase !!  :-)         *
;                                                                       *
;       NOTE !!: use numbers and no capital letters only                *
;                       and insert them into the ""                     *
;                                                                       *
;                                                                       *
	dt      " ???????? "                                           ;*
;                                                                       *
;                                                                       *
;                                                                       *
;************************************************************************
;************************************************************************
	
	retlw   0


;************************************************************************

table_n_digitos
	addwf   pc,f            ;
	retlw   0x02            ;
	retlw   0x04            ;
	retlw   0x04            ;
	retlw   0x03            ;
	retlw   0x01            ;
	retlw   0x04            ;
	retlw   0x03            ;
	retlw   0x04            ;
	retlw   0x02            ;
	retlw   0x04            ;
	retlw   0x03            ;
	retlw   0x04            ;
	retlw   0x02            ;
	retlw   0x02            ;
	retlw   0x03            ;
	retlw   0x04            ;
	retlw   0x04            ;
	retlw   0x03            ;
	retlw   0x03            ;
	retlw   0x01            ;
	retlw   0x03            ;
	retlw   0x04            ;
	retlw   0x03            ;
	retlw   0x04            ;
	retlw   0x04            ;
	retlw   0x04            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;
	retlw   0x05            ;


;*****************************************************

valor_binario
	addwf   pc, f           ;
	retlw   b'00000001'     ;
	retlw   b'00001110'     ;
	retlw   b'00001010'     ;
	retlw   b'00000110'     ;
	retlw   b'00000001'     ;
	retlw   b'00001011'     ;
	retlw   b'00000100'     ;
	retlw   b'00001111'     ;
	retlw   b'00000011'     ;
	retlw   b'00000001'     ;
	retlw   b'00000010'     ;
	retlw   b'00001101'     ;
	retlw   b'00000000'     ;
	retlw   b'00000010'     ;
	retlw   b'00000000'     ;
	retlw   b'00001001'     ;
	retlw   b'00000100'     ;
	retlw   b'00000101'     ;
	retlw   b'00000111'     ;
	retlw   b'00000000'     ;
	retlw   b'00000011'     ;
	retlw   b'00000111'     ;
	retlw   b'00000001'     ;
	retlw   b'00000110'     ;
	retlw   b'00000010'     ;
	retlw   b'00001100'     ;
	retlw   b'00000000'     ;
	retlw   b'00000001'     ;
	retlw   b'00000011'     ;
	retlw   b'00000111'     ;
	retlw   b'00001111'     ;
	retlw   b'00011111'     ;
	retlw   b'00011110'     ;
	retlw   b'00011100'     ;
	retlw   b'00011000'     ;
	retlw   b'00010000'     ;
				  

;************************************************************************
	org     0x060           ;
;************************************************************************

start   clrwdt                  ;
	clrf	gpio
	movlw   0x00            ;
	tris	gpio		;
	movlw   b'11010111'     ;
	option			;



;********************************************

	limpar_registos

;***********************************

main    bsf	out_ptt		;

	goto	morse

back	bcf	out_ptt		;

	call	_seg

	goto	main

;***********************************
morse   movf    count_letra, w  ;
	call    table_frase     ;
	movwf   valor_letra     ;

	movf    valor_letra, f  ;
	btfsc   z
	goto    fim

accao   movlw   0x20            ;
	subwf   valor_letra, w
	btfsc   z
	goto    almost          ;
	
	movlw   0x3a            ;
	subwf   valor_letra, w
	btfsc   c
	goto    _cont           ;
	movlw   0x4b
	addwf   valor_letra, f  ;

_cont   movlw   0x61            ;
	subwf   valor_letra, w
	
	call    table_n_digitos ;
	movwf   n_digitos

	movlw   0x61            ;
	subwf   valor_letra, w

	call    valor_binario   ;
	movwf   letra

;**************************************************
_do     btfss   letra, 0        ;
	goto    dah.
	call    _dih            ;
	goto    next
dah.    call    _dah            ;
next    rrf     letra, f        ;
	call    tdih            ;
	decfsz  n_digitos, f    ;
	goto    _do             ;

almost  call    tdah            ;
	incf    count_letra, f  ;
	goto    morse

;*****************************************
fim     clrf	count_letra
	goto	back		;


;**************************************************************************
tdah    movlw   0x03
	movwf   cnttmr02        ;
	movlw   0xfa            ;
	movwf   cnttmr0         ;
	call    _tmr0           ;
	decfsz  cnttmr0,f       ;
	goto    $-2
	decfsz  cnttmr02,f      ;
	goto    $-6
	retlw	0		;

;**********************
tdih    movlw   0xfa            ;
	movwf   cnttmr0         ;
	call    _tmr0           ;
	decfsz  cnttmr0,f       ;
	goto    $-2
	retlw	0		;

;*************************
_dih    movlw   0xfa            ;
	movwf   cnttmr0         ;
_trex	bcf	out
	bcf	out_mon
	call    _tmr0           ;
	bsf	out
	bsf	out_mon
	decfsz  cnttmr0,f       ;
	goto    _nop
	retlw	0		;
_nop	goto	_trex

;*************************
_dah    movlw   0x03
	movwf   cnttmr02        ;
_reload movlw   0xfa            ;
	movwf   cnttmr0         ;
_trex2	bcf	out
	bcf	out_mon
	call    _tmr0           ;
	bsf	out
	bsf	out_mon
	decfsz  cnttmr0,f       ;
	goto    _nop2
	decfsz  cnttmr02,f
	goto    _reload
	retlw	0		;
_nop2	goto	_trex2

;***************************************
_tmr0   movlw   0xfb            ;
	movwf   tmr0            ;
	movlw   0x00
	subwf   tmr0, w
	btfss   z
	goto    $ - 3
	retlw   0               ;


;************************************************************************
;       Insert here the number of seconds that you want between phrases *
;               (between the '')                                        *
;************************************************************************

_seg    movlw   d'3'            ;

;************************************************************************
;************************************************************************

	movwf   minuto          ;
delay   movlw   0x0a            ;
	movwf   count           ;
inicio  movlw   0xff            ;
	movwf   mcount          ;
loadn   movlw   0x82            ;
	movwf   ncount          ;
decn    decfsz  ncount,f        ;
	goto    decn            ;
	decfsz  mcount,f        ;
	goto    loadn           ;
	decfsz  count,f         ;
	goto    inicio          ;
	decfsz  minuto,f        ;
	goto    delay           ;
	retlw   0               ;


;************************************************************************
	end                     ;
;************************************************************************
