;**********************************************************************

	list    p=16F84, r=hex	; list directive to define processor

;**********************************************************************
tmr0	equ	0x01
pcl	equ	0x02
status  equ     0x03
porta   equ     0x05        
portb   equ     0x06        
intcon  equ     0x0b
;
        CBLOCK	0x10
	count, count1, count2, minutos, dez_minutos, horas, dez_horas
	flag_minutos, flag_horas, _minutos, _horas, _segundos
	w_temp, status_temp, dp_flag, flag_do_segundo
        ENDC
;
optreg	equ	0x81
trisa   equ     0x85
trisb   equ     0x86
;
#define z       status, 2
#define rp0     status, 5
#define	carry	status, 0
#define	dp	porta, 3	; seconds led !!
#define dp_f	dp_flag,0
#define	acerto	porta, 0
;
limpar_registos	macro
	clrf	_segundos
	clrf	_minutos
	clrf	_horas
	clrf	flag_do_segundo
	clrf	flag_horas
	clrf	flag_minutos
	clrf	minutos
	clrf	dez_minutos
	clrf	horas
	clrf	dez_horas
	clrf	porta
	clrf	portb
	clrf	dp_flag
	endm
;
	__CONFIG   0x3ff1	;_CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC

;**********************************************************************
	ORG     0x000           ; processor reset vector
	goto	main

	ORG     0x004           ; interrupt vector location
	goto	interrupt_routine

;*********************************************************************
	org	0x008           ;program start
;*********************************************************************
main	bsf     rp0		;escolhe bank 1
	movlw	b'10111111'	;
	movwf	optreg		;watchdog with maximum delay
	movlw   0x00            ;int/rb0 being used
	movwf   trisb           ;
	movlw   b'00010001'     ;ra4/tmr0 input for 50Hz
	movwf   trisa           ;
	bcf     rp0		;retorna ao bank 0
	bcf	intcon, 2	;ra4/tmr0 flag
	bsf	intcon, 5	;ra4/tmr0 interrupt
	bsf	intcon, 7	;enable global interrupts

        limpar_registos	        ;clean registers
	
	movlw	d'00'
	movwf	_minutos
	movlw	d'12'
	movwf	_horas
	movlw	0xce		;50Hz to count...
	movwf	tmr0


start
	call	decimal_bcd	;routine to make decimal into bcd
	call	mux		;routine to mux the digits

	btfss	acerto		;adjust time ??
	 call	acertar_horas	;yes

	goto	start		;rotate forever
				; 
;**********************************************************************
decimal_bcd

	movf	_minutos, w	;move int _minutos into
	movwf	flag_minutos	;working flag_minutos
	movf	_horas, w	; ... ... _horas ...
	movwf	flag_horas	;... ..  flag_horas

	clrf	minutos         ;That's it of course...
	clrf	dez_minutos	;initialize registers again  :))
	clrf	horas
	clrf	dez_horas

sub10	movlw	d'10'
	subwf	flag_minutos, f		;sutract 10 minutes to flag_minutos
	btfss	carry		; <0 ??
	goto	outsub10
	incf	dez_minutos, f	;increment in dez_minutos
	goto	sub10		;loop
outsub10
	movlw	d'10'
	addwf	flag_minutos, f	;sum 10 to flag_minutos
	bcf	carry


sub1	movlw	0x01
	subwf	flag_minutos, f	;subtract 1 flag_minutos
	btfss	carry		; <0 ??
	goto	outsub1
	incf	minutos, f	;increment in minutos
	goto	sub1		;loop
outsub1	incf	flag_minutos, f	;sum 1 to flag_minutos
	bcf	carry	


sub1000	movlw	d'10'
	subwf	flag_horas, f	;subtract 1 in flag_horas
	btfss	carry		; <0 ??
	goto	outsub1000
	incf	dez_horas, f	;increment in dez_horas
	goto	sub1000		;loop
outsub1000
	movlw	d'10'
	addwf	flag_horas, f	;sum 10 to flag_horas
	bcf	carry


sub100	movlw	0x01		
	subwf	flag_horas, f	;subtract 1 to flag_horas
	btfss	carry		; <0 ??
	goto	outsub100
	incf	horas, f	;increment in horas
	goto	sub100		;loop
outsub100
	incf	flag_horas, f	;increment flag_horas

	return

;**********************************************************************
mux	movf	minutos, w	;get digit minutos and show it
	andlw	0x0f
	iorlw	0x10
	movwf	portb		;free for 50hz input
	call	delay_1ms

	movf	dez_minutos, w	;get digit dez_minutos and show it
	andlw	0x0f
	iorlw	0x20
	movwf	portb
	call	delay_1ms

	movf	horas, w	;get digit horas and show it
	andlw	0x0f
	iorlw	0x40
	movwf	portb
	call	delay_1ms

	movf	dez_horas, f
	btfsc	z
	goto	finale
	movf	dez_horas, w	;get digit dez_horas and show it
	andlw	0x0f
	iorlw	0x80
	movwf	portb
	call	delay_1ms

finale	return

;*********************************************************************
del_100 movlw   0x21            ;delay rotines 100 usegs
	movwf   count
repeat  decfsz  count,f
	goto    repeat
	return
delay_1ms
        movlw   0x0a		;atenao.....delay of 1 ms +- !!!!            
	movwf   count1
delay   call    del_100
	decfsz  count1,f
	goto    delay
	return
delay_20
	movlw	d'30'
	movwf	count2
	call	delay_1ms
	call	delay_1ms
	decfsz	count2, f
	goto	$ - 2
	return
;*********************************************************************
interrupt_routine

	movwf   w_temp            ; save off current W register contents
	swapf	status,w          ; move status register into W register
	movwf	status_temp       ; save off contents of STATUS register

	bcf	rp0		;return to bank 0 if not there          
	bcf	intcon, 2	;tmr0 overflow flag

	incf	_segundos, f
	movlw	d'60'		;60 seconds
	subwf	_segundos, w
	btfss	z		;already 60segs ??
	goto	fim	

	clrf	_segundos
	incf	_minutos, f
	movlw	d'60'		;60 minuts
	subwf	_minutos, w
	btfss	z		;already 60mins ??
	goto	fim

	clrf	_minutos
	incf	_horas, f
	movlw	d'24'		;24 hours
	subwf	_horas, w
	btfss	z		;already 24h ??
	goto	fim   

	clrf	_horas

fim	movlw	0xce		;50Hz to count...
	movwf	tmr0
	
	btfsc	dp_f		;test blink led flag
	bcf	dp		; set it
	btfss	dp_f
	bsf	dp		; clear it
	comf	dp_flag, f	;complement to next loop

	swapf	status_temp,w     ; retrieve copy of STATUS register
	movwf	status            ; restore pre-isr STATUS register 
	swapf   w_temp,f
	swapf   w_temp,w          ; restore pre-isr W register contents

	retfie	

;*********************************************************************
acertar_horas

	incf	_minutos, f
	movlw	d'60'		;60 minuts
	subwf	_minutos, w
	btfss	z		;already 60mins ??
	goto	fim_acerto

	clrf	_minutos
	incf	_horas, f
	movlw	d'24'		;24 hours
	subwf	_horas, w
	btfss	z		;already 24h ??
	goto	fim_acerto   

	clrf	_horas

fim_acerto	
	clrf	_segundos
	call	delay_20
	return

;*********************************************************************
	END                     ; directive 'end of program'
;*********************************************************************





