;***********************************************  01.05.2005  ***
;								*
;	Receptor/Controlador por DTMF				*
;	Configuravel atraves de computador.			*
;								*
;		Antonio Sergio Sena	ham: CT2GPW		*
;		ct2gpw@amsat.org				*
;								*
;****************************************************************
 
	list    p=16f628
	radix   hex

	include	"p16f628a.inc"

;****************************************************************
indf	equ	0x00
pcl	equ	0x02
tmr0    equ     0x01
status  equ     0x03
fsr	equ	0x04
porta   equ     0x05
portb   equ     0x06
eedata  equ    	0x08
eeadr   equ    	0x09
intcon  equ     0x0b
optreg  equ     0x81
trisa   equ     0x85
trisb   equ     0x86
eecon1  equ    	0x88
eecon2  equ    	0x89
;****************************************************************
	CBLOCK	0x0c
	count, count3, mcount, ncount, temp_1st, temp_2nd
	temp_3rd, digi, temp_msb, temp_lsb, temp_digi, w_temp
	status_temp, e2address, e2data, cnt_e2p, count1, count2
	_1_msb, _1_lsb, _2_msb, _2_lsb, _3_msb, _3_lsb
	_4_msb, _4_lsb, _5_msb, _5_lsb, _6_msb, _6_lsb
	_7_msb, _7_lsb, _8_msb, _8_lsb, _all_msb, _all_lsb
	_11_msb, _11_lsb, _22_msb, _22_lsb, _33_msb, _33_lsb
	_44_msb, _44_lsb, _55_msb, _55_lsb, _66_msb, _66_lsb
	_77_msb, _77_lsb, _88_msb, _88_lsb, _sleep_msb, _sleep_lsb
	ENDC
;****************************************************************
zero    equ     2		;status zero
c       equ     0		;status carry
rp0     equ     5		;status bank
wr      equ	1		;eeprom write initiate flag
wren    equ	2		;eeprom write enable flag
rd	equ	0		;eeprom read enable flag  
#define	z	status, zero
;****************************************************************
initialize	macro
	movlw	0x0c		;initialize pointer
	movwf	fsr		;into RAM
next	clrf	indf		;clear indirect register
	incf	fsr, f		;inc pointer
	movlw	0x4f
	subwf	fsr, w
	btfss	z		;completed ??
	goto	next
	set_digi
	endm
set_digi	macro
	movlw	0x03
	movwf	digi
	endm


;	__CONFIG 0x3f42		;RC osc, PWRTE on, CP off, WDTE off


;****************************************************************
;	Where code is...
;****************************************************************

	org     0x000
	goto	start

	org	0x004           	; interrupt vector location
	goto	interrupt_routine


;****************************************************************
;	Table for e2prom readings...
;****************************************************************
table	addwf	pcl, f		;add to PC
	goto	read_1_msb
	goto	read_1_lsb
	goto	read_11_msb
	goto	read_11_lsb
	goto	read_2_msb
	goto	read_2_lsb
	goto	read_22_msb
	goto	read_22_lsb
	goto	read_3_msb
	goto	read_3_lsb
	goto	read_33_msb
	goto	read_33_lsb
	goto	read_4_msb
	goto	read_4_lsb
	goto	read_44_msb
	goto	read_44_lsb
	goto	read_5_msb
	goto	read_5_lsb
	goto	read_55_msb
	goto	read_55_lsb
	goto	read_6_msb
	goto	read_6_lsb
	goto	read_66_msb
	goto	read_66_lsb
	goto	read_7_msb
	goto	read_7_lsb
	goto	read_77_msb
	goto	read_77_lsb
	goto	read_8_msb
	goto	read_8_lsb
	goto	read_88_msb
	goto	read_88_lsb
	goto	read_all_msb
	goto	read_all_lsb
	goto	read_sleep_msb
	goto	read_sleep_lsb
	
read_1_msb
	movf	eedata, w
	movwf	_1_msb
	return
read_1_lsb
	movf	eedata, w
	movwf	_1_lsb
	return
read_11_msb
	movf	eedata, w
	movwf	_11_msb
	return
read_11_lsb
	movf	eedata, w
	movwf	_11_lsb
	return
read_2_msb
	movf	eedata, w
	movwf	_2_msb
	return
read_2_lsb
	movf	eedata, w
	movwf	_2_lsb
	return
read_22_msb
	movf	eedata, w
	movwf	_22_msb
	return
read_22_lsb
	movf	eedata, w
	movwf	_22_lsb
	return
read_3_msb
	movf	eedata, w
	movwf	_3_msb
	return
read_3_lsb
	movf	eedata, w
	movwf	_3_lsb
	return
read_33_msb
	movf	eedata, w
	movwf	_33_msb
	return
read_33_lsb
	movf	eedata, w
	movwf	_33_lsb
	return
read_4_msb
	movf	eedata, w
	movwf	_4_msb
	return
read_4_lsb
	movf	eedata, w
	movwf	_4_lsb
	return
read_44_msb
	movf	eedata, w
	movwf	_44_msb
	return
read_44_lsb
	movf	eedata, w
	movwf	_44_lsb
	return
read_5_msb
	movf	eedata, w
	movwf	_5_msb
	return
read_5_lsb
	movf	eedata, w
	movwf	_5_lsb
	return
read_55_msb
	movf	eedata, w
	movwf	_55_msb
	return
read_55_lsb
	movf	eedata, w
	movwf	_55_lsb
	return
read_6_msb
	movf	eedata, w
	movwf	_6_msb
	return
read_6_lsb
	movf	eedata, w
	movwf	_6_lsb
	return
read_66_msb
	movf	eedata, w
	movwf	_66_msb
	return
read_66_lsb
	movf	eedata, w
	movwf	_66_lsb
	return
read_7_msb
	movf	eedata, w
	movwf	_7_msb
	return
read_7_lsb
	movf	eedata, w
	movwf	_7_lsb
	return
read_77_msb
	movf	eedata, w
	movwf	_77_msb
	return
read_77_lsb
	movf	eedata, w
	movwf	_77_lsb
	return
read_8_msb
	movf	eedata, w
	movwf	_8_msb
	return
read_8_lsb
	movf	eedata, w
	movwf	_8_lsb
	return
read_88_msb
	movf	eedata, w
	movwf	_88_msb
	return
read_88_lsb
	movf	eedata, w
	movwf	_88_lsb
	return
read_all_msb
	movf	eedata, w
	movwf	_all_msb
	return
read_all_lsb
	movf	eedata, w
	movwf	_all_lsb
	return
read_sleep_msb
	movf	eedata, w
	movwf	_sleep_msb
	return
read_sleep_lsb
	movf	eedata, w
	movwf	_sleep_lsb
	return


;****************************************************************
;	Program starts here with setings
;****************************************************************
start   clrwdt			;change prescaler to TMR0
	clrf	portb		;switch off ports for security
	movlw	0x07		;disable comparadores
	movwf	cmcon
	bsf     status,rp0      ;change page to define ports
	movlw   0x1f
	movwf   trisa
	movlw   0x00
	movwf   trisb
	movlw   b'10000111'     ;prescaler for 256
	movwf   optreg
	bcf     status,rp0      ;back to page 0
	clrf	portb
	bcf	intcon, 2	;clear tmr0 int flag
	bcf	intcon, 5	;disable tmr0 int 
	bsf	intcon, 7	;enable global interrupts	

	initialize		;clear entire RAM

	call	programming			;program tones, if you wish

	call	read_tones_from_e2prom		;read tones to work


;****************************************************************
;	Start of real control
;****************************************************************
	set_digi		

begin	btfss	porta, 4	;valid tone ??
	goto	$-1		;no
	btfsc	porta, 4	;yes, wait until ends
	goto	$-1		;still active

	movf	porta, w	;get signals from port A
	movwf	temp_digi	;save them

	bcf	intcon, 2	;clear tmr0 flag
	bsf	intcon, 5	;enable tmr0 interrupt
	clrf	tmr0		;clear tmr0
	bsf	status, rp0
	movlw   b'10000111'     ;load prescaler again with 256
	movwf   optreg
	bcf	status, rp0

	call	check_digito_temp	;save tone to chain

	movf	digi, f		;already 3 tones ??
	btfsc	z		
	call	procedure	;yes, act as the tone says

	goto	begin		;missing some tones


;****************************************************************
;	Check with digit is to save
;****************************************************************
check_digito_temp

	movlw	0x03		;1st tone??
	subwf	digi, w
	btfsc	z
	goto	_1st		;yes
	movlw	0x02		;2nd tone ??
	subwf	digi, w	
	btfsc	z
	goto	_2nd		;yes
	movlw	0x01		;3dr tone ??
	subwf	digi, w
	btfsc	z
	goto	_3rd		;yes
	return
	
_3rd	movf	temp_digi, w	;save 3rd tone
	movwf	temp_3rd
	goto	_fim
_2nd	movf	temp_digi, w
	movwf	temp_2nd	;save 2nd tone
	goto	_fim
_1st	movf	temp_digi, w
	movwf	temp_1st	;save 1st tone
	goto	_fim
_fim	decf	digi, f		;next tone to save
	return


;****************************************************************
;	Switch on or off the outputs acording to tone string
;****************************************************************
procedure
	
	bcf	intcon, 2	;clear tmr0 flag
	bcf	intcon, 5	;disable tmr0 interrupt
	set_digi		;reload counter
		
	movf	temp_2nd, w	;construct flag of tones
	andlw	0x0f		;last 4 bits = temp_1st
	movwf	temp_msb	;first 4 bits = temp_2nd
	swapf	temp_1st, w	;swap lsb for msb to construct tone flag
	andlw	0xf0		;
	iorwf	temp_msb, f	;msb flag completed
	movf	temp_3rd, w	;load lsb flag too with temp_3rd
	andlw	0x0f
	movwf	temp_lsb	;ok

ligar_1	movf	_1_msb, w	;code for input 1		trocado PIC Isel
	subwf	temp_msb, w
	btfss	z
	goto	desligar_1	;out of here
	movf 	_1_lsb, w	;switch on input 1 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_4		;yes please !
desligar_1
	movf	_11_msb, w	;code for input 1
	subwf	temp_msb, w
	btfss	z
	goto	ligar_2		;out of here
	movf	_11_lsb, w	;switch off input 1 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_4		;yes please !

ligar_2	movf	_2_msb, w	;code for input 2
	subwf	temp_msb, w
	btfss	z
	goto	desligar_2	;out of here
	movf	_2_lsb, w	;switch on input 2 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_2		;yes please !
desligar_2
	movf	_22_msb, w	;code for input 2
	subwf	temp_msb, w
	btfss	z
	goto	ligar_3		;out of here
	movf	_22_lsb, w	;switch off input 2 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_2		;yes please !

ligar_3	movf	_3_msb, w	;code for input 3
	subwf	temp_msb, w
	btfss	z
	goto	desligar_3	;out of here
	movf	_3_lsb, w	;switch on input 3 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_3		;yes please !
desligar_3
	movf	_33_msb, w	;code for input 3
	subwf	temp_msb, w
	btfss	z
	goto	ligar_4		;out of here
	movf	_33_lsb, w	;switch off input 3 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_3		;yes please !

ligar_4	movf	_4_msb, w	;code for input 4		trocado PIC Isel
	subwf	temp_msb, w
	btfss	z
	goto	desligar_4	;out of here
	movf	_4_lsb, w	;switch on input 4 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_1		;yes please !
desligar_4
	movf	_44_msb, w	;code for input 4
	subwf	temp_msb, w
	btfss	z
	goto	ligar_5		;out of here
	movf	_44_lsb, w	;switch off input 4 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_1		;yes please !
 

ligar_5	movf	_5_msb, w	;code for input 5
	subwf	temp_msb, w
	btfss	z
	goto	desligar_5	;out of here
	movf	_5_lsb, w	;switch on input 5 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_5		;yes please !
desligar_5
	movf	_55_msb, w	;code for input 5
	subwf	temp_msb, w
	btfss	z
	goto	ligar_6		;out of here
	movf	_55_lsb, w	;switch off input 5 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_5		;yes please !

ligar_6	movf	_6_msb, w	;code for input 6
	subwf	temp_msb, w
	btfss	z
	goto	desligar_6	;out of here
	movf	_6_lsb, w	;switch on input 6 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_6		;yes please !
desligar_6
	movf	_66_msb, w	;code for input 6
	subwf	temp_msb, w
	btfss	z
	goto	ligar_7		;out of here
	movf	_66_lsb, w	;switch off input 6 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_6		;yes please !

ligar_7	movf	_7_msb, w	;code for input 7
	subwf	temp_msb, w
	btfss	z
	goto	desligar_7	;out of here
	movf	_7_lsb, w	;switch on input 7 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_7		;yes please !
desligar_7
	movf	_77_msb, w	;code for input 7
	subwf	temp_msb, w
	btfss	z
	goto	ligar_8		;out of here
	movf	_77_lsb, w	;switch off input 7 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_7		;yes please !

ligar_8	movf	_8_msb, w	;code for input 8
	subwf	temp_msb, w
	btfss	z
	goto	desligar_8	;out of here
	movf	_8_lsb, w	;switch on input 8 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	on_8		;yes please !
desligar_8
	movf	_88_msb, w	;code for input 8
	subwf	temp_msb, w
	btfss	z
	goto	desligar_all	;out of here
	movf	_88_lsb, w	;switch off input 8 ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_8		;yes please !

desligar_all
	movf	_all_msb, w	;code for to all
	subwf	temp_msb, w
	btfss	z
	goto	sleep_all	;out of here
	movf	_all_lsb, w	;clear all ??
	subwf	temp_lsb, w
	btfsc	z
	goto	off_all		;yes please !

sleep_all
	movf	_sleep_msb, w	;code for sleep
	subwf	temp_msb, w
	btfss	z
	goto	_sair		;out of here
	movf	_sleep_lsb, w	;clear all ??
	subwf	temp_lsb, w
	btfsc	z
	goto	_sleep_all	;yes please !

_sair	return


;****************************************************************
;	Subroutines to switch outputs
;****************************************************************
on_1	bsf	portb, 0	;switch on output 1
	return
off_1	bcf	portb, 0	;switch off output 1
	return
on_2	bsf	portb, 1	;switch on output 2
	return
off_2	bcf	portb, 1	;switch off output 2
	return
on_3	bsf	portb, 2	;switch on output 3
	return
off_3	bcf	portb, 2	;switch off output 3
	return
on_4	bsf	portb, 3	;switch on output 4
	return
off_4	bcf	portb, 3	;switch off output 4
	return
on_5	bsf	portb, 4	;switch on output 5
	return
off_5	bcf	portb, 4	;switch off output 5
	return
on_6	bsf	portb, 5	;switch on output 6
	return
off_6	bcf	portb, 5	;switch off output 6
	return
on_7	bsf	portb, 6	;switch on output 7
	return
off_7	bcf	portb, 6	;switch off output 7
	return
on_8	bsf	portb, 7	;switch on output 8
	return
off_8	bcf	portb, 7	;switch off output 8
	return
off_all	clrf	portb		;switch off all ports
	return
_sleep_all
	clrf	portb
	call	del_10
	sleep
	sleep
	return


;****************************************************************
;	Interrupt routine that reset the counters
;****************************************************************
interrupt_routine

	movwf   w_temp          ; save off current W register contents
	swapf	status,w        ; move status register into W register
	movwf	status_temp	; save off contents of STATUS register

	bcf	status, rp0	;return to bank 0 if not there          
	bcf	intcon, 2	;tmr0 overflow flag

	set_digi		;reset counter for number of tones
				;to start a new string
	bcf	intcon, 5	;disable tmr0 interrupt

	swapf	status_temp,w	; retrieve copy of STATUS register
	movwf	status		; restore pre-isr STATUS register 
	swapf   w_temp,f
	swapf   w_temp,w	; restore pre-isr W register contents

	retfie	


;****************************************************************
;	Routine to read tones from e2prom
;****************************************************************
read_tones_from_e2prom
	
	clrf	cnt_e2p		;clear e2prom counter
_ciclo	movf	cnt_e2p, w	;load W with e2prom counter
	movwf	e2address	;address to read
	call	prmget		;read it
	movf	cnt_e2p, w	;load W again with counter
	call	table		;table to save readings
	incf	cnt_e2p, f	;next cycle
	movlw	0x24		;18 tones already ??
	subwf	cnt_e2p, w
	btfss	z
	goto	_ciclo		;no
	return			;yes, get out of here


;****************************************************************
;	Routine to program tones to e2prom
;****************************************************************
programming

	bcf	intcon, 2	;clear tmr0 flag
	bcf	intcon, 5	;disable tmr0 interrupt
	clrf	tmr0		;clear tmr0
	bsf	status, rp0	;page1
	movlw   b'10000111'     ;load prescaler again with 256
	movwf   optreg
	bcf	status, rp0	;page0

	bcf	intcon, 2	;clear tmr0 flag
_duh	btfsc	porta, 4	;valid tone ??
	goto	_dah		;yes
	btfss	intcon, 2	;tmr0 ended ??
	goto	_duh		;no, scan key tone
	goto	_end		;yes, dont program
 
_dah	bcf	intcon, 2	;clear tmr0 flag
	movf	porta, w	;get signals from port A
	andlw	0x0f
	sublw	b'00001011'	;check if it is an "*"
	btfss	z		;is it ??
	goto	_end	

	btfsc	porta, 4	;yes, wait until keystroke ends
	goto	$-1		;still active
	call	on_1		;switch on output 1 to confirm
	
wait	btfss	porta, 4	;valid tone ??
	goto	$-1		;no
	btfsc	porta, 4	;yes, wait until ends
	goto	$-1		;still active
	movf	porta, w	;get signals from port A
	movwf	temp_digi	;save them
	call	check_digito_temp	;save tone to chain
	movf	digi, f		;already 3 tones ??
	btfss	z		
	goto	wait		;missing some tones

	set_digi		;reload counter
		
	movf	temp_2nd, w	;construct flag of tones
	andlw	0x0f		;last 4 bits = temp_1st
	movwf	temp_msb	;first 4 bits = temp_2nd
	swapf	temp_1st, w	;swap lsb for msb to construct tone flag
	andlw	0xf0		;
	iorwf	temp_msb, f	;msb flag completed
	movf	temp_3rd, w	;load lsb flag too with temp_3rd
	andlw	0x0f
	movwf	temp_lsb	;ok
	
	call	e2prom_grava_correspondente	;grava e2p com tone

	movlw	0x24		;18 tones allready ?
	subwf	cnt_e2p, w
	btfss	z
	goto	wait		;no

_end	call	off_1		;switch off output 1, work is done
	clrf	cnt_e2p
	bcf	intcon, 2
	bcf	intcon, 5
	return


;*************************************************************
;       rotinas de acesso 'a e2prom
;*************************************************************
e2prom_grava_correspondente

	movf	cnt_e2p, w	;load address to save
	movwf	e2address
	movf	temp_msb, w	;load tone to save in address
	movwf	e2data
	call	setprm
	call	del_10		;relax...

	incf	cnt_e2p, f	;save last tone
	movf	cnt_e2p, w
	movwf	e2address
	movf	temp_lsb, w
	movwf	e2data
	call	setprm
	call	del_10		;relax...

	incf	cnt_e2p, f	;next round
	return


;*************************************************************
;       rotinas de acesso 'a e2prom
;*************************************************************
setprm  bcf	status, rp0
	movf    e2address, w
	movwf   eeadr           ;now copy w into eeadr to set eeprom address
	movf    e2data, w       ;get data value from e2data and hold in w
	movwf   eedata          ;copy w into eeprom data byte register
	
	bsf	status, rp0
	bsf     eecon1, wren    ;enable write

manual  movlw   h'55'           ;microchip manual dictated factors
	movwf   eecon2          ;they cause the action required by
	movlw   h'aa'           ;by the eeprom to store the data in eedata
	movwf   eecon2          ;at the address held by eeadr.
	bsf     eecon1, wr      ;perform write

chkwrt	btfss   eecon1, wr      ;wait until bit 1 of eecon1 is set
	goto	chkwrt
	bcf     eecon1, wren    ;disable write
	bcf     eecon1, wr      ;clear bit 1 of eecon1
	bcf	status, rp0
	return                  ;and return
;..........
prmget  bcf	status, rp0
	movf    e2address, w
	movwf   eeadr           ;now copy w into eeadr to set eeprom address
	bsf	status, rp0
	bsf     eecon1, rd      ;enable read flag
	bcf	status, rp0
	movf    eedata, w       ;read eeprom data now in eedata into w
	return                  ;and return


;****************************************************************
;	Delay routine
;****************************************************************
del_10  movlw   0x54            ;delay subroutine that gives
	movwf   count1		;less more than 10ms
repeat2 decfsz  count1,f
	goto    repeat2
	return



;****************************************************************
	org	0x2100						;starting values for e2prom
	de	11, 01, 11, 0a, 22, 01, 22, 0a, 33, 01, 33, 0a
	de	44, 01, 44, 0a, 55, 01, 55, 0a, 66, 01, 66, 0a
	de	77, 01, 77, 0a, 88, 01, 88, 0a, 12, 03, 45, 06
;****************************************************************
;	End of program
;****************************************************************

	end                     ;end all program and shutt of this thing...

