;#################################################################################
;
;	Este programa recebe um BYTE pela USART, e envia-o por SPI
;
;	v1.0	05/04/2009	PIC16F88x
;
;	Autor: Antnio Srgio Sena, www.senaeng.com
;
;#################################################################################


	processor	16F886		;configura o tipo de CPU usado
	radix		hex			;pre-definicao do tipo de valores numericos usados
	
	include	"P16F886.inc"	;inclui pre-definicoes do processador

	__config	_CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_OFF & _IESO_OFF & _BOR_OFF & _CPD_OFF & _CP_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	__config	_CONFIG2, _WRT_OFF & _BOR40V


;---------------------------

temp	equ		0x20		;define endereco 0x20 com o nome de TEMP
temp2	equ		0x21		;define endereco 0x21 com o nome de TEMP2
temp3	equ		0x22		;define endereco 0x22 com o nome de TEMP3

;---------------------------



		org		0x0000

	goto	principal



		org		0x0030

principal

	;configura toda a porta A para entrada/saida DIGITAL
	banksel	ANSEL		;muda para o banco onde est o registo ANSEL
	clrf	ANSEL		;limpa o registo ANSEL
	clrf	ANSELH		;limpa o registo ANSELH

	clrf	PORTA		;desliga porta antes de configurar
	clrf	PORTB		;desliga porta antes de configurar
;	clrf	PORTC		;limpa tristate da porta C
	clrf	PORTE		;desactiva todos os drivers de sada da porta E

	;configura portas A e B como entradas/saidas
	banksel	TRISA			;muda para banco onde est o registo TRISA

	clrf	TRISA			;porta A toda como saida
	clrf	TRISB			;porta B toda como saida
	movlw	b'00000000'
	movwf	TRISC			;porta C toda como saida
	clrf	TRISE			;porta E toda como saida

	clrf	OPTION_REG		;limpa registo OPTION
	
	movlw	b'00100100'		;liga TX da USART, liga alta velocidade
	movwf	TXSTA
	movlw	.25				;gerador de velocidade :: 9k6bps - 25 ; 19k2bps - 12
	movwf	SPBRG

	movlw	0
	movwf	SSPSTAT			;sample at middle, falling SCK




	banksel	RCSTA			;muda para banco onde est o registo RCSTA

	movlw	b'10010000'		;liga USART, liga RX da USART, 
	movwf	RCSTA			;liga alta velocidade do gerador baud rate

	movlw	b'00100010'		;SPI Master, idle low, Fosc/64
	movwf	SSPCON



	movf	RCREG, w		;carrega W com byte recebido pela porta serie, limpeza antes de iniciar recepcao

repete

	bcf		RCSTA, CREN		;desliga a porta serie, para limpar erro de Overrun
	btfsc	RCSTA, OERR
	 goto	$-2
	bsf		RCSTA, CREN		;liga a porta serie de novo


	movf	RCREG, w		;carrega W com byte recebido pela porta serie
	btfsc	RCSTA, FERR		;l dados recebidos, para limpar erro de Framing
	 goto	$-2



	btfss	PIR1, RCIF		;testa se chegou byte
	 goto	$-1
	nop


	movf	RCREG, w		;carrega W com byte recebido pela porta serie
	movf	RCREG, w		;carrega W com byte recebido pela porta serie
	nop
	nop
	nop
	nop
	nop


	movwf	PORTB			;mostra na porta B
	movwf	SSPBUF			;envia por SPI	

	movwf	TXREG			;envio eco do caracter recebido
	nop



	call	atraso_100m		;	espera

	goto	repete			;volta ao inicio do programa



;---------------------------


atraso_100m
	movlw	0xC6		;carrega W com o valor 0xC6
	movwf	temp2		;move valor em W para TEMP

	call	atraso_500u	;
	
	decfsz	temp2, f	;decrementa TEMP em uma unidade, coloca resultado em TEMP
						;e salta a instrucao seguinte, se o resultado for zero
	 goto	$-2

	return				;sai fora da rotina de ATRASO

;---------------------------

atraso_500u
	movlw	0xA5		;carrega W com o valor 0xA5
	movwf	temp		;move valor em W para TEMP

	decfsz	temp, f		;decrementa TEMP em uma unidade, coloca resultado em TEMP
						;e salta a instrucao seguinte, se o resultado for zero
	 goto	$-1		;
	
	return				;sai fora da rotina de ATRASO

;---------------------------
	end













