;#################################################################################
;
;	Este programa envia um byte por SPI a cada XXXms
;
;	v1.0	05/04/2009	PIC16F88x
;
;	Autor: Antnio Srgio Sena, www.senaeng.com
;
;#################################################################################


	processor	16F886		;configura o tipo de CPU usado
	radix		hex			;pre-definicao do tipo de valores numericos usados
	
	include	"P16F886.inc"	;inclui pre-definicoes do processador

	__config	_CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_OFF & _IESO_OFF & _BOR_OFF & _CPD_OFF & _CP_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	__config	_CONFIG2, _WRT_OFF & _BOR40V


;---------------------------

temp	equ		0x20		;define endereco 0x20 com o nome de TEMP
temp2	equ		0x21		;define endereco 0x21 com o nome de TEMP2
temp3	equ		0x22		;define endereco 0x22 com o nome de TEMP3

;---------------------------



		org		0x0000

	goto	principal



		org		0x0030

principal

	;configura toda a porta A para entrada/saida DIGITAL
	banksel	ANSEL		;muda para o banco onde est o registo ANSEL
	clrf	ANSEL		;limpa o registo ANSEL
	clrf	ANSELH		;limpa o registo ANSELH

	clrf	PORTA		;desliga porta antes de configurar
	clrf	PORTB		;desliga porta antes de configurar
;	clrf	PORTC		;limpa tristate da porta C
	clrf	PORTE		;desactiva todos os drivers de sada da porta E

	;configura portas A e B como entradas/saidas
	banksel	TRISA			;muda para banco onde est o registo TRISA

	clrf	TRISA			;porta A toda como saida
	clrf	TRISB			;porta B toda como saida
	movlw	b'00000000'
	movwf	TRISC			;porta C toda como saida
	clrf	TRISE			;porta E toda como saida

	clrf	OPTION_REG		;limpa registo OPTION
	
	movlw	0
	movwf	SSPSTAT			;sample at middle, falling SCK


	banksel	SSPCON			;muda para banco onde est o registo SSPCON
	movlw	b'00100010'		;SPI Mater, idle low, Fosc/64
	movwf	SSPCON




repete


	movlw	0xAA
	movwf	SSPBUF			;envia por SPI	

	call	atraso_100m		;	espera

	goto	repete			;volta ao inicio do programa




;---------------------------


atraso_100m
	movlw	0xC6		;carrega W com o valor 0xC6
	movwf	temp2		;move valor em W para TEMP

	call	atraso_500u	;
	
	decfsz	temp2, f	;decrementa TEMP em uma unidade, coloca resultado em TEMP
						;e salta a instrucao seguinte, se o resultado for zero
	 goto	$-2

	return				;sai fora da rotina de ATRASO

;---------------------------

atraso_500u
	movlw	0xA5		;carrega W com o valor 0xA5
	movwf	temp		;move valor em W para TEMP

	decfsz	temp, f		;decrementa TEMP em uma unidade, coloca resultado em TEMP
						;e salta a instrucao seguinte, se o resultado for zero
	 goto	$-1		;
	
	return				;sai fora da rotina de ATRASO

;---------------------------
	end













