/* Satstruc.h     12/6/95 CDG - Revised 11/7/96 for v 3.0

   Type definitions for Satellite data structures

*/

typedef double FAR * lpdouble;  // long pointer to double float

typedef struct {        // Standard 3-Vector
    double X;
    double Y;
    double Z;
} Vector;

typedef Vector FAR * lpVector;

typedef struct {
    float Latitude;
    float Longitude;
} LatLong;

typedef LatLong FAR * lpLatLong;

typedef struct {             // Numerical contents of NORAD 2-line ElSets
    double Epoch;
    double MeanAnomaly;      //    radians
    double MeanMotion;
    double MeanMotionDeriv;
    double SemiMajorAxis;
    double Inclination;      //    radians
    double Eccentricity;
    double ArgPerigee;       //    radians
    double RAAN;             //    radians
    double MeanMotion2Deriv;
    double Bstar;
    long OrbitNum;
} KeplerianElements;

typedef KeplerianElements FAR * lpKeplerianElements;

typedef struct {           // Results of calculations:
    Vector OrbitPlane;       //   Position rel to arg of perigee
    double R;                //   Orbital radius (instantaneous)
    Vector ECI;              //   Inertial position (Aries = X)
    Vector ECIVelocity;      //   Velocity in ECI coords
    Vector Geocentric;       //   Geocentric (Greenwich = X) position
    LatLong Map;             //   Map coordinates
    float Altitude;
    float Azimuth;          //   Relative to Observer
    float Elevation;
    Vector AntECI;           //   Antenna in ECI coords
    Vector AntGeo;
    Vector AxisECI;          //   Axis  --- NEW 2/1/97
    Vector AxisGeo;          //         --- NEW 2/1/97
    float Squint;            // degrees
    float Range;
    float Velocity;
//    float DopplerShift;    // deleted 2/1/97
    float LastRange;
    double LastTime;
    double C[4][4];         // NEW 2/1/97  (formerly local variable)
                            // elements [0] are unused.
                            // note reversal of index order relative to BASIC
} ComputedValues;

typedef ComputedValues FAR * lpComputedValues;

typedef struct {      // Descriptive information about satellite
    char SatelliteName[32];
    char Description[256];
    long ElSetNum;
    BOOL ElSetMod;
    char NORADNum[8];
    char IntlDes[8];
    int EphemType;
    double BeaconFreq;
    double UplinkFreq;
    double DownlinkFreq;
    BOOL TransponderInverting;
    char Mode[256];
//    BOOL DragFlag;        // // deleted 2/1/97
    BOOL AttitudeFlags;     //    CHANGED 2/1/97
    float Alon;             // radians
    float Alat;             // radians
    float BeamWidth;        // NEW  2/1/97
    float OffsetAngle;      // NEW  2/1/97
} SatelliteDescription;

typedef SatelliteDescription FAR * lpSatelliteDescription;

typedef struct  {           // Completely revised 2/1/97
    int ElsetIndex;
    SatelliteDescription Descr;
    KeplerianElements Ref;
    KeplerianElements Current;
    ComputedValues Pos;
    int CalcType;
    BOOL IgnoreDecay;
    int DragMult;
//    BOOL SatWasVisible;    // May be extended in future!
//    Vector SatViewPoint;
//    int RFDisplayMode;
} TrackingData;

typedef TrackingData FAR * lpTrackingData;


