#!/bin/bash

WD=$(dirname $0)
APP_NAME="ACOM Terminal S"

REQUIRED_MAJOR=3
REQUIRED_MINOR=4
VERSION_TITLE="Cannot launch $APP_NAME"
VERSION_MSG="$APP_NAME requires the Mono Framework version $REQUIRED_MAJOR.$REQUIRED_MINOR or later."

MONO_VERSION="$(mono --version 2>/dev/null| grep 'Mono JIT compiler version ' |  cut -f5 -d\ )"
MONO_VERSION_MAJOR="$(echo $MONO_VERSION | cut -f1 -d.)"
MONO_VERSION_MINOR="$(echo $MONO_VERSION | cut -f2 -d.)"
if [ -z "$MONO_VERSION" ] \
        || [ $MONO_VERSION_MAJOR -lt $REQUIRED_MAJOR ] \
        || [ $MONO_VERSION_MAJOR -eq $REQUIRED_MAJOR -a $MONO_VERSION_MINOR -lt $REQUIRED_MINOR ]
then
        if [[ $(which zenity 2>/dev/null) ]]; then
          zenity --error --text="$VERSION_TITLE. $VERSION_MSG"
        elif  [[ $(which kdialog 2>/dev/null) ]]; then
          kdialog --sorry "$VERSION_TITLE. $VERSION_MSG"
        elif  [[ $(which xmessage 2>/dev/null) ]]; then
          xmessage -center  "$VERSION_TITLE. $VERSION_MSG"
        else
          echo "$VERSION_TITLE"
          echo "$VERSION_MSG"
        fi
        exit 1
fi

exec `which mono`  "$WD/ACOM.Terminal.exe"
