/* SP12: A serial programmer for working with Atmel AT90S uCs        */
/* Copyright (C) 1997-2003 Ken Huntington, Kevin Towers, Pitronics.  */

/* This program is free software; you can redistribute it and/or     */
/* modify it under the terms of the GNU General Public License       */
/* as published by the Free Software Foundation; either version 2    */
/* of the License, or (at your option) any later version.            */

/* This program is distributed in the hope that it will be useful,   */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/* GNU General Public License for more details.                      */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software       */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston,            */
/* MA  02111-1307, USA.                                              */

/* Pitronics can be reached by email: sbolt@xs4all.nl                */
/* Kevin Towers can be reached by email: ktowers@omnexcontrols.com   */
/* Ken Huntington can be reached by email: kenh@compmore.net         */

#ifdef LINUX

#include <sys/io.h>
#include <unistd.h>

#define inportb(a) inb(a)
#define outportb(a,b) outb(b,a)

#define delay(a) usleep(a*1000)

#else

#ifdef WIN32

// these functions are in winnt.c
void win_giveio(void);
void delay(int mseconds);
inline unsigned char inportb (const unsigned short port);
inline void outportb (unsigned short port, const unsigned char val);

#else

#include <dos.h>

#endif  // WIN32
#endif  // LINUX





