/*********************************************
***     AVROT DDE Client for WinOrbit      ***
***     compiled by Visual C++ 6.0         ***
***         (c) OK1DX 2002                 ***
***     HAMWARE - free for HAM radio       ***
***     amateur (non commercial use)       ***
**********************************************/
//

#include "stdafx.h"
#include "AVROT1.h"
#include "AVROT1Dlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

DWORD WINAPI ComPortThread2(LPVOID par);
DWORD WINAPI ComPortThread(LPVOID par);
HDDEDATA CALLBACK DxDdeCallback(UINT utype, UINT ufmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwdata1, DWORD dwdata2);
CAVRDDE* g_pdde;
CRITICAL_SECTION g_cs;


/////////////////////////////////////////////////////////////////////////////
// CAVROT1Dlg dialog

CAVROT1Dlg::CAVROT1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAVROT1Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAVROT1Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_comport = 0;
	m_ThreadID = NULL;
	m_hCom = INVALID_HANDLE_VALUE;
	m_manual = FALSE;
	m_Az = m_El = -1000;
	m_rxin = m_rxout = m_rxbuf;
	m_wo.Offset = m_wo.OffsetHigh = 0;
	InitializeCriticalSection(&g_cs);
	m_wo.hEvent = CreateEvent( NULL, TRUE, FALSE, NULL );
}

void CAVROT1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAVROT1Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAVROT1Dlg, CDialog)
	//{{AFX_MSG_MAP(CAVROT1Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SETAZ, OnSetaz)
	ON_BN_CLICKED(IDC_SETEL, OnSetel)
	ON_BN_CLICKED(IDC_MANUAL, OnManual)
	ON_WM_TIMER()
	ON_CBN_SELCHANGE(IDC_COMPORT, OnSelchangeComport)
	ON_BN_CLICKED(IDC_STPEL, OnStpel)
	ON_BN_CLICKED(IDC_STPAZ, OnStpaz)
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
	ON_COMMAND(IDX_RXCOM, RxCom)
	ON_COMMAND(IDX_AZEL, RxAzEl)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAVROT1Dlg message handlers

BOOL CAVROT1Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CheckAllComPorts();
	if (!m_comport)
	{
		MessageBox("No available COM ports detected","Error");
		exit(0);
	}

	ComConnect(m_comport);
	m_dde.m_hWndDlg=m_hWnd;  //where to send messages
	m_dde.Con();

	SetTimer(1,2000,NULL);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAVROT1Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


HCURSOR CAVROT1Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CAVROT1Dlg::OnSetaz() 
{
	char buf[21];
	int deg;

	CEdit* pe = (CEdit*)GetDlgItem(IDC_CMDAZ);
	pe->GetWindowText(buf,20);
	deg = atoi(buf);
	if (deg <0)
		deg=0;
	if (deg >360)
		deg=360;
	m_Az = deg;
	sprintf(buf,"A\r\n%d\r\n",deg);
	ComSend(buf);
}


void CAVROT1Dlg::OnSetel() 
{
	char buf[21];
	int deg;

	CEdit* pe = (CEdit*)GetDlgItem(IDC_CMDEL);
	pe->GetWindowText(buf,20);
	deg = atoi(buf);
	if (deg <0)
		deg=0;
	if (deg >180)
		deg=180;
	m_El = deg;
	sprintf(buf,"E\r\n%d\r\n",deg);
	ComSend(buf);
}



void CAVROT1Dlg::OnStpel() 
{
	char cmd[]="E\r\nS\r\n";
	ComSend(cmd);
}


void CAVROT1Dlg::OnStpaz() 
{
	char cmd[]="A\r\nS\r\n";
	ComSend(cmd);
}


void CAVROT1Dlg::OnSelchangeComport() 
{

	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_COMPORT);
	int item = cb->GetCurSel();
	int xport = (int)cb->GetItemData(item);

	if (xport != m_comport)
	{
		ComDisconect();
		ComConnect(xport);
		m_comport = xport;
	}
}


void CAVROT1Dlg::OnManual() 
{
	CButton* az = (CButton*)GetDlgItem(IDC_SETAZ);
	CButton* el = (CButton*)GetDlgItem(IDC_SETEL);
	CButton* cb = (CButton*)GetDlgItem(IDC_MANUAL);
	m_manual = cb->GetCheck();
	if (m_manual)
	{
		az->EnableWindow(TRUE);
		el->EnableWindow(TRUE);
	}
	else
	{
		az->EnableWindow(FALSE);
		el->EnableWindow(FALSE);
		CheckUpdate();
	}
}


int CAVROT1Dlg::ComConnect(int port)
{
	char scom[10];
	DCB dcb;
	
	if (m_hCom == INVALID_HANDLE_VALUE)
	{
		sprintf(scom,"COM%d",port);
		m_hCom = CreateFile(scom,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,NULL);  //overlapped
		if (m_hCom == INVALID_HANDLE_VALUE)
			return 0;
		if (!GetCommState(m_hCom, &dcb))
			return 0;
		dcb.BaudRate = CBR_9600;
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.EvtChar = 0;
		dcb.fOutxCtsFlow = FALSE;
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrControl = DTR_CONTROL_DISABLE;
		dcb.fOutX = FALSE;
		dcb.fInX = FALSE;

		if (SetCommState(m_hCom, &dcb))
		{
			if (!m_ThreadID)
			{
				m_stpthread = FALSE;
				CreateThread(NULL,0, ComPortThread,this,0,&m_ThreadID);
				return 1;
			}
		}
	}
	return 0;
}


int CAVROT1Dlg::ComDisconect()
{
	if (m_hCom != INVALID_HANDLE_VALUE)
	{
		PurgeComm(m_hCom, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR ) ;
		m_stpthread = TRUE;
		SetCommMask(m_hCom, EV_RING);	//to break WaitCommEvent
		while (m_hCom != INVALID_HANDLE_VALUE);			//wait till thread finishes
	}
	return 1;
}


DWORD WINAPI ComPortThread(LPVOID par)
{
	DWORD	evmask;
	OVERLAPPED o,ro;

	CAVROT1Dlg* dlg = (CAVROT1Dlg*) par;

	memset( &o, 0, sizeof( OVERLAPPED ) ) ;

	o.hEvent = CreateEvent( NULL, TRUE, FALSE, NULL );

	if (o.hEvent == NULL)
	{
		MessageBox( NULL, "Failed to create event for thread!", "Error",
                  MB_ICONEXCLAMATION | MB_OK ) ;
		return ( FALSE ) ;
	}

	if (!SetCommMask(dlg->m_hCom, EV_RXCHAR ))
		return ( FALSE ) ;

	char buf[20];

	while ( !dlg->m_stpthread )
	{
		evmask = 0 ;
		WaitCommEvent( dlg->m_hCom, &evmask, NULL );

		if ((evmask & EV_RXCHAR) == EV_RXCHAR)
		{
			COMSTAT cstat;
			DWORD errflg;
			ClearCommError (dlg->m_hCom, &errflg, &cstat);
			DWORD length = min( (DWORD) 20, cstat.cbInQue );

			ro.Offset=0;
			ro.OffsetHigh=0;
			ro.hEvent=NULL;
 
			if (length > 0)
			{

				BOOL rf = ReadFile(dlg->m_hCom,buf,length,&length,&ro);
				if (!rf)
				{
					DWORD lerr = GetLastError();
					if (lerr == ERROR_IO_PENDING)
					{
						while(!GetOverlappedResult( dlg->m_hCom,&ro, &length, TRUE ))
						{
							if(GetLastError() == ERROR_IO_INCOMPLETE)
								// normal result if not finished
								continue;
							else
							{
								 // an error occurred, try to recover
								ClearCommError(dlg->m_hCom, &errflg, &cstat);
								break;
							}
						}
					}
					else
					{
						// some other error occurred
						length = 0 ;
						ClearCommError(dlg->m_hCom, &errflg, &cstat);
					}
				}
				if (length < 20)
				{
					char* bp = buf;
					char* bpm = dlg->m_rxin;
					EnterCriticalSection(&g_cs);
					while(length)
					{
						*bpm++ = *bp++;
						if (bpm >= dlg->m_rxbuf+RXBUFLEN)
							bpm = dlg->m_rxbuf;
	
						if (bpm == dlg->m_rxout)  //buffer full, reset it to zero!! ERROR
							break;
						length--;
					}
					dlg->m_rxin = bpm;
					LeaveCriticalSection(&g_cs);
					if (!length)
						::SendMessage(dlg->m_hWnd,WM_COMMAND,IDX_RXCOM,0);
				}
			}
		}
	}
	CloseHandle(dlg->m_hCom);
	dlg->m_hCom = INVALID_HANDLE_VALUE;
	dlg->m_ThreadID = 0;
	dlg->m_stpthread = FALSE;
	return 0;
}



void CAVROT1Dlg::RxCom()  //verze bez overlapped s kruhovym bufferem
{
	char buf[RXBUFLEN];
	char* bp;
	char *bpm;
	BOOL azflg, moving, go;
	int degs;

	do
	{
		bpm = m_rxout;
		bp = buf;
		*buf=0;
		go=FALSE;
		EnterCriticalSection(&g_cs);
		while (m_rxin != bpm)
		{
			if ((*bpm == 10) || (*bpm == 13))
			{
				*bp=0;
				go=TRUE;
				bpm++;
				if (bpm >= m_rxbuf + RXBUFLEN)
					bpm=m_rxbuf;
				m_rxout = bpm;
			}
			else
			{
				*bp++ = *bpm++;
				if (bpm >= m_rxbuf+RXBUFLEN)
					bpm = m_rxbuf;
			}
		}
		LeaveCriticalSection(&g_cs);

		if (go)
		{
			if (strlen(buf) > 11)  //minumum length of tlg from AVROT; shorter tlgs are ignored
			{
				bp = buf;
				if (*bp == 'E')
					azflg=FALSE;
				else
					azflg=TRUE;
				if ((*bp == 'A') || (*bp == 'E'))
				{
					bp+=2;			//example A P=123 S=9 MV
					if (*bp == 'P')
					{
						bp+=2;
						degs = atoi(bp);
						moving = FALSE;
						if (strstr(bp,"MV"))
							moving  = TRUE;
							int idc;
						if (azflg)
							idc= IDC_DEGAZ;
						else
							idc = IDC_DEGEL;
						CStatic* cs=(CStatic*)GetDlgItem(idc);
						char csb[8];
						if (moving)
							sprintf(csb,"<%03d>",degs);
						else
							sprintf(csb,"%03d",degs);
						cs->SetWindowText(csb);
					}
				}
			}
			if (strlen(buf))
			{
				ComPrint(buf);
				ComPrint("\r\n");
			}
		}
	}
	while (go);
}


void CAVROT1Dlg::RxAzEl()
{
	char buf[30];
	CStatic* cs;
	
	if ((m_dde.Azimuth >= -360) && (m_dde.Elevation >= -180))
	{
		cs = (CStatic*) GetDlgItem(IDC_DDEAZ);
		sprintf(buf,"%03d",m_dde.Azimuth);
		cs->SetWindowText(buf);

		cs = (CStatic*) GetDlgItem(IDC_DDEEL);
		sprintf(buf,"%03d",m_dde.Elevation);
		cs->SetWindowText(buf);

		CheckUpdate();
	}
	cs = (CStatic*) GetDlgItem(IDC_DDESAT);
	cs->SetWindowText(m_dde.SatName);
}


void CAVROT1Dlg::CheckUpdate()
{
	char buf[30];

	if ((m_dde.Elevation >= -5) && !m_manual)
	{
		if (m_dde.Azimuth != m_Az)
		{
			m_Az = m_dde.Azimuth;
			sprintf(buf,"A\r\n%03d\r\n",m_Az);
			ComSend(buf);
			Sleep(100);
		}	
			if (m_dde.Elevation != m_El)
		{
			if (m_dde.Elevation<0)
				m_dde.Elevation = 0;
			m_El = m_dde.Elevation;
			sprintf(buf,"E\r\n%03d\r\n",m_El);
			ComSend(buf);
		}
	}
}


int CAVROT1Dlg::ComSend(char *cmd)
{

   BOOL        res;
   DWORD       wb;
   DWORD       errflg;
   DWORD   		dwError;
   COMSTAT     cstat;

   res = WriteFile(m_hCom, cmd, strlen(cmd), &wb, &m_wo ) ;

   if (!res)
   {
      if(GetLastError() == ERROR_IO_PENDING)
      {
         while(!GetOverlappedResult( m_hCom, &m_wo, &wb, TRUE ))
         {
            dwError = GetLastError();
            if(dwError == ERROR_IO_INCOMPLETE)
            {
               // normal result if not finished
				continue;
            }
            else
            {
               // an error occurred, try to recover
				ClearCommError( m_hCom, &errflg, &cstat ) ;
				break;
            }
         }
      }
      else
      {
         // some other error occurred
         ClearCommError( m_hCom, &errflg, &cstat ) ;
         return 0;
      }
   }
   ComPrint(cmd);
   return 1 ;
}


void CAVROT1Dlg::ComPrint(char *txt)
{
	char* bp;
	CEdit* cs = (CEdit*)GetDlgItem(IDC_RXTEXT);
	char buf[301];
	cs->GetWindowText(buf,200);
	bp = strchr(buf,'\n');
	while (strlen(buf) > 150)
	{
		strcpy(buf,bp+1);
		bp = strchr(buf,'\n');
	}
	if (strlen(txt)<100)
		strcat(buf,txt);

	cs->SetWindowText(buf);
	int x = strlen(buf);
	cs->SetSel(x,x);
}


void CAVROT1Dlg::OnTimer(UINT nIDEvent) 
{
	static BOOL azel=FALSE;
	char azs[]="A\r\n";
	char els[]="E\r\n";
	char* txs = els;
	if (azel)
	{
		txs = azs;
		if (!m_dde.m_hconv)
			m_dde.Con();
	}
	ComSend(txs);
	azel = !azel;
	
	CDialog::OnTimer(nIDEvent);
}


void CAVROT1Dlg::CheckAllComPorts()
{
	char scom[10];
	HANDLE hCom;
	int sel = 0;

	CComboBox* cb = (CComboBox*) GetDlgItem(IDC_COMPORT);
	if (!cb)
		return;
	for(int i=1;i<4;i++)
	{
		sprintf(scom,"COM%d",i);
		hCom = CreateFile(scom,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
		if (hCom != INVALID_HANDLE_VALUE)
		{
			int item = cb->AddString(scom);
			cb->SetItemData(item,i);
			if (i == m_comport)
				sel = item;
			CloseHandle(hCom);
		}
	}
	if(cb->GetCount())
	{
		cb->SetCurSel(sel);
		m_comport = cb->GetItemData(sel);
	}
}



//////////////////////////////////////////////////////////////////////
// CAVRDDE Class
//////////////////////////////////////////////////////////////////////

CAVRDDE::CAVRDDE()
{
	m_inst=0L;
	DdeInitialize(&m_inst,(PFNCALLBACK)DxDdeCallback,APPCMD_CLIENTONLY,0L);
	g_pdde=this;
	m_szSatName = m_szAzEl= m_szApp1 = 0;
	Azimuth = Elevation = -1000;
	strcpy(SatName,"none");
}

CAVRDDE::~CAVRDDE()
{
	Disc();
}


HDDEDATA CALLBACK DxDdeCallback(UINT utype, UINT ufmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hdata, DWORD dwdata1, DWORD dwdata2)
{
	switch (utype)
	{
		case XTYP_ADVDATA:
			g_pdde->Update(hdata,hsz2);
			return (HDDEDATA)DDE_FACK;
		case XTYP_DISCONNECT:
			g_pdde->Disc(TRUE);
			return NULL;
		case XTYP_REGISTER:
			if(!DdeCmpStringHandles(hsz1,g_pdde->m_szApp1))
				g_pdde->Con();
			return NULL;
	}
	return NULL;
}

int CAVRDDE::Con()
{

	HSZ	szTopic;
	DWORD lResult;
	HDDEDATA   hDdeData;


	if (!m_szApp1)
		m_szApp1 = DdeCreateStringHandle(m_inst,"WinOrbit",CP_WINANSI);
	szTopic = DdeCreateStringHandle(m_inst,"TrackingInfo",CP_WINANSI);
	m_hconv = DdeConnect(m_inst,m_szApp1,szTopic,NULL);
	DdeFreeStringHandle(m_inst,szTopic);

	if (m_hconv)
	{
		m_szAzEl = DdeCreateStringHandle(m_inst,"AzEl",CP_WINANSI);
		m_szSatName = DdeCreateStringHandle(m_inst,"SatelliteName",CP_WINANSI);
		hDdeData = DdeClientTransaction(NULL, 0L, m_hconv, m_szAzEl, CF_TEXT, XTYP_REQUEST, 1000, &lResult);
		Update(hDdeData,m_szAzEl);
		DdeFreeDataHandle (hDdeData);
		hDdeData = DdeClientTransaction(NULL, 0L, m_hconv, m_szSatName, CF_TEXT, XTYP_REQUEST, 1000, &lResult);
		Update(hDdeData,m_szSatName);
		DdeFreeDataHandle (hDdeData);
		hDdeData = DdeClientTransaction(NULL, 0L, m_hconv, m_szAzEl, CF_TEXT, XTYP_ADVSTART, 1000, &lResult);
		hDdeData = DdeClientTransaction(NULL, 0L, m_hconv, m_szSatName, CF_TEXT, XTYP_ADVSTART, 1000, &lResult);
	}
	return NULL;
}


int CAVRDDE::Disc(BOOL ext)
{
	DdeFreeStringHandle(m_inst,m_szApp1);
	DdeFreeStringHandle(m_inst,m_szAzEl);
	DdeFreeStringHandle(m_inst,m_szSatName);
	m_szSatName = m_szAzEl = m_szApp1 = 0;
	if (!ext)
		DdeDisconnect(m_hconv);
	m_hconv = 0;
	Azimuth = Elevation = 0;
	strcpy (SatName,"none");
	SendMessage(m_hWndDlg,WM_COMMAND,IDX_AZEL,0);
	return 0;
}

void CAVRDDE::Update(HDDEDATA hdata, HSZ item)
{
	LPBYTE lpByte;
	DWORD datalen;
	char buffer[250];
	char* bp;


	lpByte = DdeAccessData (hdata, &datalen);

	if (datalen <250)
	{
		memcpy (buffer, lpByte, datalen);	
		if (item == m_szAzEl)
		{
			Azimuth = Elevation = 0;
			Azimuth=atoi(buffer);
			if(bp = strstr(buffer,"|"))
				Elevation=atoi(++bp);
		}
		else if (item == m_szSatName)
		{
			strcpy(SatName,buffer);
		}
		SendMessage(m_hWndDlg,WM_COMMAND,IDX_AZEL,0);
	}


	DdeUnaccessData (hdata);
}



void CAVROT1Dlg::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CAbout about;
	about.DoModal();
	
	CDialog::OnLButtonDblClk(nFlags, point);
}
/////////////////////////////////////////////////////////////////////////////
// CAbout dialog


CAbout::CAbout(CWnd* pParent /*=NULL*/)
	: CDialog(CAbout::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAbout)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CAbout::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAbout)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAbout, CDialog)
	//{{AFX_MSG_MAP(CAbout)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAbout message handlers
