;Mini-Stromversorgungsprogramm fr den AVR-Bastelstecker
;(C) Mrz 2000, Roland Walter (DL7UNO), roland@rowalt.de, www.rowalt.de
;Dieses kleine Programm legt die Pins 1-6 der parallelen Schnittstelle auf High.
;Dies sind die Stromversorgungs-Pins des AVR-Bastelsteckers, wie ich ihn in der
;Zeitschrift "Funkamateur" vorgestellt habe.
;
;WICHTIG:
;Die jeweilige parallele Schnittstelle (LPT1 bis LPT3) mu im Quelltext angepat
;werden, da das Programm nicht interaktiv ist. Das ist mit zwei kleinen nderungen
;unter dem Label "Start" getan - zwei, weil man auch den Text ndern sollte ;-)
;Die Compilierung kann mit TASM.EXE erfolgen (ist im Internet zu finden). Damit
;wird zunchst nur die Datei LPTON.OBJ erzeugt. Diese mu anschlieend in eine
;COM-Datei gelinkt werden. Dazu nimmt man am besten das Programm TLINK.EXE, das
;ebenfalls im Internet zu finden sein sollte.
;Hier sind die beiden Kommandozeilen zum Erzeugen des Programms:
;TASM.EXE LPTON.ASM
;TLINK LPTON.OBJ,LPTON.COM /t
;
;NOCH WICHTIGER:	Nein, ich mache keine Einfhrung in Assembler!!!!!!!!!!!!!
;
;*********************************************************************************
.MODEL TINY	;COM-Datei erzeugen, Programm und Daten in einem 64K-Segment
.CODE		;Ab hier beginnt der Code
ORG 100h	;COM-Dateien mssen das Programm bei Offset 100h starten
;*********************************************************************************
Start:
 jmp UndLos	;Daten berspringen und zum eigentlichen Programm gehen
 LPT dw 00h	;LPT-Port festlegen (00h ist LPT1, 01h ist LPT2 und 02h ist LPT3)
 Msg db "AVR an LPT1: Spannung liegt an <Beenden mit beliebiger Taste>$"
;*********************************************************************************
UndLos:
 ;
 Call Cls	;Prozedur ClearScreen aufrufen (ist weiter unten)
 ;
 mov ah,02h	;Kursor-Position setzen - dazu ah auf 02h...
 mov bh,0	;...Page 1 in bh setzen...
 mov dh,11	;...Y...
 mov dl,8	;...X...
 int 10h	;...und Int10 lst die Aktion aus
 ;
 mov ah,09h	;Textfarbe setzen...
 mov al,' '	;...Leerzeichen nehmen (ist eigentlich egal)...
 mov bh,00h	;...Page 1...
 mov bl,10	;...Farbe hellgrn setzen...
 mov cx,80	;...80 Zeichen mit der Farbe versehen...
 int 10h	;...und das Ganze mit Int10 ausfhren
 ;
 mov dx,OFFSET Msg ;Text setzen, Offset der Textadresse in dx
 mov ah,9	;...und Funktion 9 des...
 int 21h	;...Interrupts 21h zeigt den Text an
 ;
 mov al,01111110b ;Binrwert, der zum LPT-Port soll...
 mov ah,00h	;...ah auf Null setzen...
 mov dx,LPT	;...den LPT-Port setzen...
 int 17h	;...und nun LPT-Interrupt Int17 auslsen
 ;
 mov ah,00h	;Funktion 00h von...
 int 16h	;...Int16 wartet auf Keyboard-Zeichen
 ;
 mov al,00000000b ;Alle Bits des LPT-Ports wieder auf 0 zurcksetzen...
 mov ah,00h	;...ah auf Null setzen...
 mov dx,LPT	;...den LPT-Port setzen...
 int 17h	;...und LPT-Interrupt Int17 auslsen
 ;
 Call Cls	;Prozedur ClearScreen aufrufen (ist weiter unten)
 ;
 mov ah,02h	;Kursor-Position auf normale setzen - dazu ah auf 02h...
 mov bh,0	;...Page 1 in bh setzen...
 mov dh,2	;...Y...
 mov dl,0	;...X...
 int 10h	;...und Int10 lst die Aktion aus
 ;
 MOV AX,4C00h	;Funktion 4Ch von...
 int 21h	;...Int21 beendet das Programm
;*********************************************************************************
Cls PROC	;Start der Prozedur Cls (Clear Screen)
 mov ah,07h	;Clear screen - dazu ah auf 07h...
 mov al,00h	;...Null in al heit ALLES lschen...
 mov bh,7	;...Attribut (7=Farbe grau) frs Lschen in bh...
 mov ch,0	;...Bildschirmausschnitt, Y1...
 mov cl,0	;...X1...
 mov dh,25	;...Y2...
 mov dl,80	;...X1...
 int 10h	;...und Int10 lst die Aktion aus
 ret		;Mu hier sein (Return)
Cls ENDP	;Ende der Prozedur
;*********************************************************************************
END Start
