/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef UTILS_H
#define UTILS_H     1

#include <locale.h>
#include "common.h"
#include "shared.h"

/* File name data */
#define STATION_LOG_FILE    "station_log.txt"   /* Station text log name */
#define STATION_QSL_FILE    "station_qsl.ps"    /* Station adif log name */
#define STATION_ADIF_FILE   "station_log.adif"  /* Station adif log name */

/* Special characters */
#define LF      0x0A /* Line Feed */
#define CR      0x0D /* Carriage Return */
#define HT      0x09 /* Horizontal Tab  */

#define RECORD_SIZE         616 /* Size in bytes of QSO Records in station log */
#define REC_BUFF_SIZE       617 /* Size in bytes of QSO Records buffer (+'\0') */
#define CARDS_PER_PAGE      6   /* QSL cards per "page" in the postscipt file  */
#define LINE_LEN            77  /* Limit of line length in text files */
#define QSL_BUFF_SIZE       610 /* Size of buffer used to produce QSL PS file */

#endif
