/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "main.h"
#include "shared.h"

/* Signal handler */
static void sig_handler( int signal );

/*------------------------------------------------------------------------*/

int
main (int argc, char *argv[])
{
  /* Command line option returned by getopt() */
  int option;

  /* New and old actions for sigaction() */
  struct sigaction sa_new, sa_old;


  gtk_set_locale ();
  gtk_init (&argc, &argv);
  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /* Initialize new actions */
  sa_new.sa_handler = sig_handler;
  sigemptyset( &sa_new.sa_mask );
  sa_new.sa_flags = 0;

  /* Register function to handle signals */
  sigaction( SIGINT,  &sa_new, &sa_old );
  sigaction( SIGSEGV, &sa_new, 0 );
  sigaction( SIGFPE,  &sa_new, 0 );
  sigaction( SIGTERM, &sa_new, 0 );
  sigaction( SIGABRT, &sa_new, 0 );

  /* Process command line options */
  while( (option = getopt(argc, argv, "hv") ) != -1 )
	switch( option )
	{
	  case 'h': /* Print usage and exit */
		Usage();
		exit( 0 );

	  case 'v': /* Print version */
		puts( PACKAGE_STRING );
		exit( 0 );

	  default: /* Print usage and exit */
		Usage();
		exit( -1 );

	} /* End of switch( option ) */

  /* Initialize (clear) file pointers */
  rc_data.station_log_fp = NULL;
  rc_data.station_qsl_fp = NULL;
  rc_data.log_adif_fp    = NULL;

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  main_window = create_main_window ();
  gbl_popup_menu = create_main_menu();
  gtk_widget_show (main_window);

  SetFlag( CAPITALIZE | NEW_DATE | NEW_FREQ | NEW_MODE );
  gtk_idle_add( Load_Config, main_window );

  gtk_main ();

  return 0;
}

/*------------------------------------------------------------------------*/


/*  Load_Config()
 *
 *  Loads the xhamlogrc configuration file
 */

  gboolean
Load_Config( gpointer idata )
{
  char
    rc_fpath[50], /* File path to xhamlogrc */
    line[81];     /* Buffer for Load_Line  */

  /* Config file pointer */
  FILE *xhamlogrc;

  GtkWidget *entry;


  /* Setup path to xhamlog home dir */
  snprintf( rc_data.home_dir, sizeof(rc_data.home_dir),
	  "%s/%s", getenv("HOME"), "xhamlog" );

  /* Setup xhamlog file paths */
  snprintf( rc_fpath, sizeof(rc_fpath),
	  "%s/%s", rc_data.home_dir, RC_FILE );
  snprintf( rc_data.stn_log_file, sizeof(rc_data.stn_log_file),
	  "%s/%s", rc_data.home_dir, STATION_LOG_FILE );
  snprintf( rc_data.stn_qsl_file, sizeof(rc_data.stn_qsl_file),
	  "%s/%s", rc_data.home_dir, STATION_QSL_FILE );
  snprintf( rc_data.stn_adif_file, sizeof(rc_data.stn_adif_file),
	  "%s/%s", rc_data.home_dir, STATION_ADIF_FILE );

  /* Open xhamlogrc file */
  xhamlogrc = fopen( rc_fpath, "rw" );
  if( xhamlogrc == NULL )
  {
    perror( rc_fpath );
    Error_Dialog(
	_("Failed to open "RC_FILE" file\n"\
	  "Quit xhamlog and correct"), TRUE );
    return( FALSE );
  }

  /*** Read runtime configuration data ***/
  /* Read Capitalize enable flag, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Capitalize Enable")) != SUCCESS )
    return( FALSE );

  if( strcmp(line, "yes") == 0 )
	SetFlag( CAPITALIZE );
  else if( strcmp(line, "no") != 0 )
  {
	fclose( xhamlogrc );
	Error_Dialog(
		_("Error reading "RC_FILE"\n"\
		  "Unrecognized menu option\n"\
		  "Quit xhamlog and correct"), TRUE );
	return( FALSE );
  }

  /* Read operator callsign, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Operator Callsign")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.my_call, line, sizeof(rc_data.my_call) );

  /* Read operator name, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Operator Name")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_name, line, sizeof(rc_data.my_name) );

  /* Read operator surname, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Operator Surname")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_srname, line, sizeof(rc_data.my_srname) );

  /* Read operator address line 1, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Operator Address")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_addr1, line, sizeof(rc_data.my_addr1) );

  /* Read operator address line 2, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Operator Address")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_addr2, line, sizeof(rc_data.my_addr2) );

  /* Read Zone, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("ITU Zone")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_zone, line, sizeof(rc_data.my_zone) );

  /* Read QTH, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("QTH Name")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_qth, line, sizeof(rc_data.my_qth) );

  /* Read QTH locator, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("QTH Locator")) != SUCCESS )
    return( FALSE );
  Strlcpy( rc_data.my_loc, line, sizeof(rc_data.my_loc) );

  /* Read Transmitter name, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Transmitter Name")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.tx, line, sizeof(qso_record.tx) );
  Strlcpy( rc_data.tx, qso_record.tx, sizeof(rc_data.tx) );

  /* Read Transmitter power, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Transmitter Power")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.tx_power, line, sizeof(qso_record.tx_power) );
  Strlcpy( rc_data.tx_power, qso_record.tx_power, sizeof(rc_data.tx_power) );

  /* Read Transmitter antenna, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Transmitter Antenna")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.tx_ant, line, sizeof(qso_record.tx_ant) );
  Strlcpy( rc_data.tx_ant, qso_record.tx_ant, sizeof(rc_data.tx_ant) );

  /* Read Receiver name, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Receiver Name")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.rx, line, sizeof(qso_record.rx) );
  Strlcpy( rc_data.rx, qso_record.rx, sizeof(rc_data.rx) );

  /* Read Receiver N.Fig, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Receiver Noise Figure")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.rx_nfig, line, sizeof(qso_record.rx_nfig) );
  Strlcpy( rc_data.rx_nfig, qso_record.rx_nfig, sizeof(rc_data.rx_nfig) );

  /* Read Receiver antenna, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Receiver Antenna")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.rx_ant, line, sizeof(qso_record.rx_ant) );
  Strlcpy( rc_data.rx_ant, qso_record.rx_ant, sizeof(rc_data.rx_ant) );

  /* Read default remarks on QSO */
  if( Load_Line(line, xhamlogrc, _("Default Remarks")) != SUCCESS )
    return( FALSE );
  Strlcpy( qso_record.remarks, line, sizeof(qso_record.remarks) );

  /* Read log file viewer command */
  if( Load_Line(line, xhamlogrc, _("Log File Viewer")) != SUCCESS )
    return( FALSE );
  line[25] = '\0';
  snprintf( rc_data.log_viewer, sizeof(rc_data.log_viewer),
	  "%s %s/%s", line, rc_data.home_dir, STATION_LOG_FILE );

  /* Read log file printer command */
  if( Load_Line(line, xhamlogrc, _("Log File Printer")) != SUCCESS )
    return( FALSE );
  line[25] = '\0';
  snprintf( rc_data.log_print, sizeof(rc_data.log_print),
	  "%s %s/%s", line, rc_data.home_dir, STATION_LOG_FILE );

  /* Read qsl card file viewer command */
  if( Load_Line(line, xhamlogrc, _("QSL Card Viewer")) != SUCCESS )
    return( FALSE );
  line[25] = '\0';
  snprintf( rc_data.qsl_viewer, sizeof(rc_data.qsl_viewer),
	  "%s %s/%s", line, rc_data.home_dir, STATION_QSL_FILE );

  /* Read qsl card file printer command */
  if( Load_Line(line, xhamlogrc, _("QSL Card Printer")) != SUCCESS )
    return( FALSE );
  line[25] = '\0';
  snprintf( rc_data.qsl_print, sizeof(rc_data.qsl_print),
	  "%s %s/%s", line, rc_data.home_dir, STATION_QSL_FILE );

  /*** Setup default CAT items ***/
  /* Read serial port device, abort if EOF */
  if( Load_Line(line, xhamlogrc, _("Serial Port device")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cat_serial, line, sizeof(rc_data.cat_serial) );

  /* Read transceiver type */
  if( Load_Line(line, xhamlogrc, _("Transceiver Type")) != SUCCESS )
	return( FALSE );
  if( strncmp(line, "FT847", strlen(line)) == 0 )
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "ft847")), TRUE );
	rc_data.tcvr_type = FT847;
  }
  else if( strncmp(line, "FT857", strlen(line)) == 0 )
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "ft857")), TRUE );
	rc_data.tcvr_type = FT857;
  }
  else if( strncmp(line, "K3", strlen(line)) == 0 )
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "k3")), TRUE );
	rc_data.tcvr_type = K3;
  }
  else
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "none")), TRUE );
	rc_data.tcvr_type = NONE;
  }

  /* Enter default data to main window */
  entry = lookup_widget( main_window, "my_call" );
  gtk_entry_set_text( GTK_ENTRY(entry), rc_data.my_call );
  entry = lookup_widget( main_window, "my_name" );
  gtk_entry_set_text( GTK_ENTRY(entry), rc_data.my_name );
  entry = lookup_widget( main_window, "my_zone" );
  gtk_entry_set_text( GTK_ENTRY(entry), rc_data.my_zone );
  entry = lookup_widget( main_window, "my_qth" );
  gtk_entry_set_text( GTK_ENTRY(entry), rc_data.my_qth );
  entry = lookup_widget( main_window, "my_loc" );
  gtk_entry_set_text( GTK_ENTRY(entry), rc_data.my_loc );
  entry = lookup_widget( main_window, "tx" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.tx );
  entry = lookup_widget( main_window, "tx_power" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.tx_power );
  entry = lookup_widget( main_window, "tx_ant" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.tx_ant );
  entry = lookup_widget( main_window, "rx" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.rx );
  entry = lookup_widget( main_window, "rx_nfig" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.rx_nfig );
  entry = lookup_widget( main_window, "rx_ant" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.rx_ant );
  entry = lookup_widget( main_window, "remarks" );
  gtk_entry_set_text( GTK_ENTRY(entry), qso_record.remarks );

  fclose( xhamlogrc );

  return( FALSE );

} /* End of Load_Config() */

/*------------------------------------------------------------------*/

/*  sig_handler()
 *
 *  Signal Action Handler function
 */

static void sig_handler( int signal )
{
  /* Wrap up and quit */
  Cleanup();
  fprintf( stderr, "\n" );
  switch( signal )
  {
    case SIGINT :
      fprintf( stderr, "%s\n",  _("xhamlog: Exiting via User Interrupt") );
      exit( signal );

    case SIGSEGV :
      fprintf( stderr, "%s\n",  _("xhamlog: Segmentation Fault") );
      exit( signal );

    case SIGFPE :
      fprintf( stderr, "%s\n",  _("xhamlog: Floating Point Exception") );
      exit( signal );

    case SIGABRT :
      fprintf( stderr, "%s\n",  _("xhamlog: Abort Signal received") );
      exit( signal );

    case SIGTERM :
      fprintf( stderr, "%s\n",  _("xhamlog: Termination Request received") );
      exit( signal );
  }

} /* End of sig_handler() */

/*------------------------------------------------------------------------*/

