/* xhamlog: A logging program for radio amateurs.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CAT_H
#define CAT_H	1

#include "common.h"
#include "support.h"

/* Mask for Rx S-Meter status */
#define FT847_SMETER	0x1F
#define FT857_SMETER	0x0F

/* Don't hide OK button in error dialog */
#define OK	FALSE

/* Definitions for Transceiver CAT control */
/* Operating mode names (usb/lsb/cw etc) and op-codes */
#define TCVR_MODE_NAMES \
  "LSB", "USB", "CW", "CW(R)", "CW(N)", "CW(NR)", "AM", "FM",\
  "AM(N)", "FM(N)", "DATA", "DATA(R)", "DIG", "PKT","???"
#define K3_MODE_CODES \
  (char)0x01, (char)0x02, (char)0x03, (char)0x07, (char)0x13, (char)0x17, (char)0x05, \
  (char)0x04, (char)0x15, (char)0x14, (char)0x06, (char)0x09, (char)0x06, (char)0x06
#define FT847_MODE_CODES \
  (char)0x00, (char)0x01, (char)0x02, (char)0x03, (char)0x82, (char)0x83, (char)0x04, \
  (char)0x08, (char)0x84, (char)0x88, (char)0x01, (char)0x00, (char)0x0A, (char)0x0C
#define FT857_MODE_CODES \
  (char)0x00, (char)0x01, (char)0x02, (char)0x03, (char)0x02, (char)0x03, (char)0x04, \
  (char)0x08, (char)0x04, (char)0x88, (char)0x01, (char)0x00, (char)0x0A, (char)0x0C

/* Number of mode codes above */
#define NUM_MODE_CODES		14

#endif

