/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef UTILS_H
#define UTILS_H     1

#include <locale.h>
#include <sys/stat.h>
#include "common.h"
#include "cat.h"
#include "shared.h"

/* For opening files */
#define FILE_NEW    1
#define FILE_OPEN   2
#define FILE_FAIL   4

/* Some character definitions */
#define CR      0x0d /* Carriage Return */
#define LF      0x0a /* Line Feed       */

#define RECORD_SIZE     616 /* Size in bytes of QSO Records in station log */
#define REC_BUFF_SIZE   617 /* Size in bytes of QSO Records buffer (+'\0') */
#define CARDS_PER_PAGE  6   /* QSL cards per "page" in the postscipt file  */
#define LINE_LEN        77  /* Limit of line length in text files */

/* Baud rate definitions. They are slightly different
 * from nominal to make integer arithmetic more accurate */
#define BAUD122     122.5
#define BAUD105     105.0
#define BAUD61       61.25
#define BAUD30       30.625
#define BAUD15       15.3125
#define BAUD7         7.65625
#define BAUD14       14.0
#define BAUD2         2.45
#define BAUD1         1.225
#define BAUD06        0.6125
#define BAUD_RATES    10

/* Default normal and low-res (FM105) font file */
#define FONT_NRMRES "FeldFatEn.bdf"
#define FONT_LOWRES "FMFatLoEn.bdf"

#endif

