/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CODEC_H
#define CODEC_H     1

#include <math.h>
#include "common.h"

#define MAXSEG_AVE_WIN      4 /* Max seg ave window len (samples)*/
#define ROW_AVE_WIN         3 /* Length of row averaging window  */

/* Tone control flags */
#define SILENT_TONE     0x01
#define RAISE_TONE      0x02
#define LOWER_TONE      0x03
#define KEEP_TONE       0x04

/* Definitions for ascii to Morse code conversion */
#define NUM_MORSE_CHARS    55 /* Number of chars in Morse table */

/* ASCII equivalents to Morse hex code. Last */
/* one ( ) used for unrecognized characters. */
#define ASCII_CHAR { \
  'A','B','C','D','E','F','G','H','I','J','K','L','M', \
  'N','O','P','Q','R','S','T','U','V','W','X','Y','Z', \
  '1','2','3','4','5','6','7','8','9','0','.',',',':', \
  '?','\'','-','/','(','"',';','$','#','<','!','@',']',\
  '=','~',' ' }

/* Hex equivalents to Morse code chars above. Formed   */
/* by starting with a 1 and following with a 0 for     */
/* dash and 1 for dit e.g: A = ditdah = 101 = Hex 0x06 */
#define MORSE_CODE { \
  0x06,0x17,0x15,0x0b,0x03,0x1d,0x09,0x1f,0x07,0x18,0x0a,0x1b,0x04,\
  0x05,0x08,0x19,0x12,0x0d,0x0f,0x02,0x0e,0x1e,0x0c,0x16,0x14,0x13,\
  0x30,0x38,0x3c,0x3e,0x3f,0x2f,0x27,0x23,0x21,0x20,0x6a,0x4c,0x47,\
  0x73,0x61,0x5e,0x2d,0x52,0x6d,0x55,0xf6,0x35,0x7a,0x2a,0x37,0x29,\
  0x2e,0xff,0x01 }

/* Arc tan correction table */
#define ARC_TAN_TABLE \
{ \
   0,  1,  3,  4,  5,  6,  8,  9, 10, 11, 13, 14, \
  15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, \
  28, 29, 30, 31, 32, 33, 34, 35, 35, 36, 37, 38, \
  39, 39, 40, 41, 42, 42, 43, 44, 44, 45          \
}

#endif

