/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"

/* Global widgets */
GtkWidget
  *main_window		 = NULL,
  *drawingarea		 = NULL,
  *scope			 = NULL,
  *popup_menu		 = NULL,
  *tx_scrolledwindow = NULL,
  *scope_label		 = NULL,
  *xmit_status		 = NULL,
  *rcve_status		 = NULL;

GtkBuilder *main_window_builder = NULL;
GtkBuilder *popup_menu_builder  = NULL;

/* Receive window and waterfall pixbuffs */
pixbuf_data_t
  wfall_pixbuf,
  receive_pixbuf;

/* Text buffers for text viewers */
GtkTextBuffer *tx_text_buffer = NULL;

/* QSO data record */
qso_record_t qso_record;

/* Runtime config data */
rc_data_t rc_data;

/* Index to macros */
int macro_idx = 0;

/* Keyboard entry buffer */
guint keybd_buff[KEY_BUFF_SIZE];

/* Receive text contrast request */
int contrast = 0;

int deskew = 0;

/* Average bin values */
int *bin_ave = NULL;

/* Signal/DSP samples buffer */
short *xmit_buffer = NULL;

/* Macros attached to F1-F9  */
char *macro[NUM_OF_LABELS];

/* IFFT data buffer*/
int16_t
  *ifft_data = NULL,
  ifft_data_length = 0;

int
  txch_ptr,		/* Pointer to character for transmission */
  space_cnt,	/* Count of spaces typed in */
  tx_buff_idx;	/* Index to signal samples buffer for tx */

/*------------------------------------------------------------------------*/

