/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CAT_H
#define CAT_H	1

#include <sys/ioctl.h>
#include <termios.h>
#include "common.h"

/* Transceiver type */
enum
{
  NONE = 0,
  FT847,
  FT857,
  K2,
  K3,
  RTS_DTR /* Control by RS232 RTS signal */
};

/* Mask for Rx S-Meter status */
#define FT847_SMETER	0x1F
#define FT857_SMETER	0x0F

#define GET_TCVR_STATUS	0
#define SET_TCVR_STATUS	1

/* Sound playback level preset for K2/K3 transceiver */
#define K3_PBK_LEVEL	80

/* Maximum number of serial port retries before error condition */
#define MAX_SERIAL_RETRIES	10

/* Range (+/-) in pixels to look for IFFT maximum
 * when click-to-tune on waterfall by user */
#define CLICK_TUNE_RANGE	10

#endif

