/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef UTILS_H
#define UTILS_H		1

#include "common.h"
#include "demodulate.h"

/* Special characters */
#define LF  0x0A /* Line Feed */
#define CR  0x0D /* Carriage Return */
#define HT  0x09 /* Horizontal Tab  */

#define MODULATION_MODES \
  _("FM-WB"), _("FM-MB"), _("FM-N25"), _("FM-N12"), _("AM-W"),  _("AM-N"),  _("AMS-U"), \
  _("AMS-L"), _("USB-W"), _("USB-M"),  _("USB-N"),  _("LSB-W"), _("LSB-M"), _("LSB-N"), \
  _("CW-UW"), _("CW-UM"), _("CW-UN"),  _("CW-LW"),  _("CW-LM"), _("CW-LN")
#define MODULATION_MODES_NUM	20

#define WEAVER_FREQUENCIES \
  "NONE", "500Hz", "600Hz", "800Hz", "1.0k", \
  "1.2k", "1.5k",  "1.6k",  "2.0k",  "2.4k"
#define WEAVER_FREQUENCIES_NUM	 10

#define DEMOD_BAND_WIDTHS \
  "100Hz", "200Hz", "400Hz", "650Hz", "950Hz", "1.0k", "1.5k", "1.9k", "2.2k", \
  "2.8k",  "3k",    "3.8k",  "4.5k",  "8k",    "12k",  "25k",  "50k",  "100k",  "200k"
#define DEMOD_BAND_WIDTHS_NUM	19

#define RTLSDR_SAMPLE_RATES "288", "1008", "2016", "3024"
#define RTLSDR_SAMPLE_RATES_NUM		4

#define SDRPLAY_SAMPLE_RATES "384", "768", "1536", "2000", "4000", "8000"
#define SDRPLAY_SAMPLE_RATES_NUM	6

#define PERSEUS_SAMPLE_RATES_NUM	10

#define SDRX_BUF_SIZE		"16", "32", "64", "128", "256"
#define SDRX_BUF_SIZE_NUM	5
#define FFT_MIN_BANDWIDTH	10.0

#define LINE_BUF_LEN		80

#endif

