/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef TIME_SIGNAL_H
#define TIME_SIGNAL_H	1

#include "common.h"
#include "filters.h"

/* Scale factor to reduce averaged I/Q
 * samples to a reasonable value */
#define AVERAGE_IQ_SCALE	1.0E6

/* Prime minimum variables to search for minima */
#define MINIMUM_PRIME	1000000000

/* One minute in seconds */
#define ONE_MINUTE_SECS		60

/* DCF77 sample rate. Same as sound card only for
 * future compatibility, in case CW decoding of the
 * carrier is implemented for audible monitoring */
#define DCF77_SAMPLE_RATE	48000

/* DCF77 pulse width (0.1 sec) in ADC samples */
#define DCF77_PULSE_WIDTH		4800
#define DCF77_SECOND_PULSES		10

/* 1/10 of DCF77 pulse (10 msec) in ADC samples. This
 * is used to refine the search for DCF77 time pulses */
#define DCF77_TICK_WIDTH	480
#define DCF77_PULSE_TICKS	10

/* Number of trailing pulses saved in FIFO */
#define DCF77_TRAIL_PULSES		2

/* Number of ticks per second */
#define DCF77_SECOND_TICKS	100

/* Number of pulse buffers in ring samples buffer */
#define DCF77_SAMPLES_BUFFERS	3

/* DCF77 data bit array index for Parity Bits */
#define DCF77_P1	28
#define DCF77_P2	35
#define DCF77_P3	58

/* ALL162 sample rate. Same as sound card only for
 * future compatibility, in case CW decoding of the
 * carrier is implemented for audible monitoring */
#define ALL162_SAMPLE_RATE	48000

/* Number of buffers in ring samples buffer */
#define ALL162_SAMPLES_BUFFERS	3

/* ALL162 data bit width (0.1sec) in ADC samples */
#define ALL162_PULSE_WIDTH	4800

/* Upscale factor to allow use of int's */
#define ALL162_UPSCALE		1000.0

/* Sliding window average of pulse levels */
#define ALL162_PULSE_AVE_MUL	49
#define ALL162_PULSE_AVE_DIV	50

/* Points of phase reversal during data bits 0 or 1.
 * 1/4 of data bit has +ve phase change, 1/2 has
 * negative and last 1/4 has positive phase change.
 * Measures are in samples, fractions of data bit length */
#define ALL162_RAMP_A	1200
#define ALL162_RAMP_B	3600
#define ALL162_RAMP_C	4800

/* Allouis ALL162 'ticks' (10 msec) per data bit (0.1 sec) */
#define ALL162_PULSE_TICKS		10

/* ALL162 number of pulses per second */
#define ALL162_SECOND_PULSES	10

/* Number of ticks per second */
#define ALL162_SECOND_TICKS		100

/* Number of trailing pulses saved in FIFO */
#define ALL162_TRAIL_PULSES		2

/* Allouis ALL162 'tick' width in samples */
#define ALL162_TICK_WIDTH		480

/* Offset from seconds marker to look for data bits */
#define ALL162_SEC_MARKER_OFFSET	11

/* Offset from minutes marker to zero seconds */
#define ALL162_MIN_MARKER_OFFSET	30

/* Factors for sliding window average of sec markers */
#define ALL162_SEC_MARKER_MUL	9
#define ALL162_SEC_MARKER_DIV	10

/* RBU66 sample rate. Same as sound card only for
 * future compatibility, in case CW decoding of the
 * carrier is implemented for audible monitoring */
#define RBU66_SAMPLE_RATE	48000

/* RBU66 pulse width (0.1 sec) in ADC samples */
#define RBU66_PULSE_WIDTH	4800

/* RBU66 'ticks' (10 msec) per pulse (0.1 sec) */
#define RBU66_PULSE_TICKS	10

/* Number of trailing pulses saved in FIFO */
#define RBU66_TRAIL_PULSES	4

/* Number of data bit combinations (00 to 11) */
#define RBU66_DATA_BITS		4

/* RBU66 'tick' width in samples */
#define RBU66_TICK_WIDTH	480

/* RBU66 number of pulses per second */
#define RBU66_SECOND_PULSES		10

/* PM tone frequencies (Hz) for 0 and 1 bits */
#define RBU66_TONE_0	100.0
#define RBU66_TONE_1	312.5

/* Factors for sliding window averaging */
#define RBU66_AVERAGE_MUL	1999.0
#define RBU66_AVERAGE_DIV	2000.0

/* Number of buffers in ring samples buffer */
#define RBU66_SAMPLES_BUFFERS	3

/* MSF60 sample rate. Same as sound card only for
 * future compatibility, in case CW decoding of the
 * carrier is implemented for audible monitoring */
#define MSF60_SAMPLE_RATE	48000

/* MSF60 pulse width (0.1 sec) in ADC samples */
#define MSF60_PULSE_WIDTH	4800

/* MSF60 'ticks' (10 msec) per pulse (0.1 sec) */
#define MSF60_PULSE_TICKS	10

/* MSF60 'tick' width in samples */
#define MSF60_TICK_WIDTH	480

/* Number of trailing pulses saved in FIFO */
#define MSF60_TRAIL_PULSES	4

/* Number of data bit combinations (00 to 11) */
#define MSF60_DATA_BITS		4

/* MSF60 number of pulses per second */
#define MSF60_SECOND_PULSES		10

/* Factors for sliding window averaging */
#define MSF60_AVERAGE_MUL	1999.0
#define MSF60_AVERAGE_DIV	2000.0

/* Number of buffers in ring samples buffer */
#define MSF60_SAMPLES_BUFFERS	3


/* Error and Message Flags to return */
#define HOUR_ERROR			0x000001
#define MINUTE_ERROR		0x000002
#define DATE_ERROR			0x000004
#define YEAR_ERROR			0x000008
#define MONTH_ERROR			0x000010
#define MDAY_ERROR			0x000020
#define RBU66_DUT_ERROR		0x000040
#define RBU66_TJD_ERROR		0x000080
#define DCF77_TX_ABNL		0x000200
#define DCF77_A1_CEST		0x000400
#define DCF77_Z1_CEST		0x000800
#define DCF77_Z1_Z2_ERROR	0x001000
#define DCF77_Z2_CET		0x002000
#define DCF77_A2_LEAP_SEC	0x004000
#define MSF60_SMTM_WARN		0x008000
#define MSF60_SMTM_EFFC		0x010000
#define MSF60_SMTM_ERROR	0x020000

/* DCF77 data bit array index for other Flags */
enum
{
  DCF77_R_ST = 15,
  DCF77_A1,
  DCF77_Z1,
  DCF77_Z2,
  DCF77_A2
};

/* DCF77 data bit array index for Minutes */
enum
{
  DCF77_MIN1 = 21,
  DCF77_MIN2,
  DCF77_MIN4,
  DCF77_MIN8,
  DCF77_MIN10,
  DCF77_MIN20,
  DCF77_MIN40
};

/* DCF77 data bit array index for Hours */
enum
{
  DCF77_HOUR1 = 29,
  DCF77_HOUR2,
  DCF77_HOUR4,
  DCF77_HOUR8,
  DCF77_HOUR10,
  DCF77_HOUR20
};

/* DCF77 data bit array index for Day of the Month */
enum
{
  DCF77_MDAY1 = 36,
  DCF77_MDAY2,
  DCF77_MDAY4,
  DCF77_MDAY8,
  DCF77_MDAY10,
  DCF77_MDAY20
};

/* DCF77 data bit array index for Day of the Week */
enum
{
  DCF77_WDAY1 = 42,
  DCF77_WDAY2,
  DCF77_WDAY4
};

/* DCF77 data bit array index for Month of the Year */
enum
{
  DCF77_MON1 = 45,
  DCF77_MON2,
  DCF77_MON4,
  DCF77_MON8,
  DCF77_MON10
};

/* DCF77 data bit array index for Year in Century */
enum
{
  DCF77_YEAR1 = 50,
  DCF77_YEAR2,
  DCF77_YEAR4,
  DCF77_YEAR8,
  DCF77_YEAR10,
  DCF77_YEAR20,
  DCF77_YEAR40,
  DCF77_YEAR80
};


/* RBU66 data bits for DUT1 */
#define RBU66_PDUT1		1
#define RBU66_MDUT1		9
#define RBU66_NDUT1		8
#define RBU66_WDUT1		0.1

/* RBU66 data bits for dUT1 */
#define RBU66_PdUT1		3
#define RBU66_MdUT1		11
#define RBU66_NdUT1		5
#define RBU66_WdUT1		0.02

/* Parity bit indices */
#define RBU66_P1	49
#define RBU66_P2	50
#define RBU66_P3	53
#define RBU66_P4	54
#define RBU66_P5	55
#define RBU66_P6	56
#define RBU66_P7	57
#define RBU66_P8	58

/* Default DUT of Moscow (3 hrs) */
#define DUT_MOSCOW	3

/* RBU66 data bit array index for Truncated Julian Day */
enum
{
  RBU66_TJD8000 = 18,
  RBU66_TJD4000,
  RBU66_TJD2000,
  RBU66_TJD1000,
  RBU66_TJD800,
  RBU66_TJD400,
  RBU66_TJD200,
  RBU66_TJD100,
  RBU66_TJD80,
  RBU66_TJD40,
  RBU66_TJD20,
  RBU66_TJD10,
  RBU66_TJD8,
  RBU66_TJD4,
  RBU66_TJD2,
  RBU66_TJD1
};

/* RBU66 data bit array index for Moscow Time - UTC (DeltaUT) */
enum
{
  RBU66_DLTUTS = 18,
  RBU66_DLTUT10,
  RBU66_DLTUT8,
  RBU66_DLTUT4,
  RBU66_DLTUT2,
  RBU66_DLTUT1
};

/* RBU66 data bit array index for Year in Century */
enum
{
  RBU66_YEAR80 = 25,
  RBU66_YEAR40,
  RBU66_YEAR20,
  RBU66_YEAR10,
  RBU66_YEAR8,
  RBU66_YEAR4,
  RBU66_YEAR2,
  RBU66_YEAR1
};

/* RBU66 data bit array index for Month of the Year */
enum
{
  RBU66_MONTH10 = 33,
  RBU66_MONTH8,
  RBU66_MONTH4,
  RBU66_MONTH2,
  RBU66_MONTH1
};

/* RBU66 data bit array index for Day of the Week */
enum
{
  RBU66_WDAY4 = 38,
  RBU66_WDAY2,
  RBU66_WDAY1
};

/* RBU66 data bit array index for Day of the Month */
enum
{
  RBU66_MDAY20 = 41,
  RBU66_MDAY10,
  RBU66_MDAY8,
  RBU66_MDAY4,
  RBU66_MDAY2,
  RBU66_MDAY1
};

/* RBU66 data bit array index for Hours */
enum
{
  RBU66_HOUR20 = 47,
  RBU66_HOUR10,
  RBU66_HOUR8,
  RBU66_HOUR4,
  RBU66_HOUR2,
  RBU66_HOUR1
};

/* RBU66 data bit array index for Minutes */
enum
{
  RBU66_MIN40 = 53,
  RBU66_MIN20,
  RBU66_MIN10,
  RBU66_MIN8,
  RBU66_MIN4,
  RBU66_MIN2,
  RBU66_MIN1
};


/* MSF60 data bits for DUT1 */
#define MSF60_PDUT1		1
#define MSF60_MDUT1		9
#define MSF60_NDUT1		8
#define MSF60_WDUT1		0.1

/* Parity bit indices */
#define MSF60_P1	54
#define MSF60_P2	55
#define MSF60_P3	56
#define MSF60_P4	57

/* Summer Time Flags */
#define MSF60_ST_WARN		53
#define MSF60_ST_EFFECT		58

/* MSF60 data bit array index for Year in Century */
enum
{
  MSF60_YEAR80 = 17,
  MSF60_YEAR40,
  MSF60_YEAR20,
  MSF60_YEAR10,
  MSF60_YEAR8,
  MSF60_YEAR4,
  MSF60_YEAR2,
  MSF60_YEAR1
};

/* MSF60 data bit array index for Month of the Year */
enum
{
  MSF60_MONTH10 = 25,
  MSF60_MONTH8,
  MSF60_MONTH4,
  MSF60_MONTH2,
  MSF60_MONTH1
};

/* MSF60 data bit array index for Day of the Month */
enum
{
  MSF60_MDAY20 = 30,
  MSF60_MDAY10,
  MSF60_MDAY8,
  MSF60_MDAY4,
  MSF60_MDAY2,
  MSF60_MDAY1
};

/* MSF60 data bit array index for Day of the Week */
enum
{
  MSF60_WDAY4 = 36,
  MSF60_WDAY2,
  MSF60_WDAY1
};

/* MSF60 data bit array index for Hours */
enum
{
  MSF60_HOUR20 = 39,
  MSF60_HOUR10,
  MSF60_HOUR8,
  MSF60_HOUR4,
  MSF60_HOUR2,
  MSF60_HOUR1
};

/* MSF60 data bit array index for Minutes */
enum
{
  MSF60_MIN40 = 45,
  MSF60_MIN20,
  MSF60_MIN10,
  MSF60_MIN8,
  MSF60_MIN4,
  MSF60_MIN2,
  MSF60_MIN1
};

#endif

