/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SOUND_H
#define SOUND_H		1

#include "common.h"

#define SND_PERIOD_SIZE		4096	/* PCM period size */
#define SND_NUM_PERIODS		4		/* Number of periods */
#define SND_BUF_STRIDE		8192	/* Sound buffer stride. Must be 2 * PERIOD_SIZE */
#define SND_DSP_RATE		48000	/* Sound Card DSP Rate - samples/sec */
#define SND_NUM_CHANNELS	2		/* 1 = MONO, 2 = STEREO <- only accepted */
#define SND_EXACT_VALUE		0
#define SND_PCM_MODE		SND_PCM_ASYNC
#define SND_PCM_ACCESS		SND_PCM_ACCESS_RW_INTERLEAVED
#define SND_PCM_FORMAT		SND_PCM_FORMAT_S16_LE

#endif

