/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H	1

#include "common.h"

/* Runtime config data */
extern rc_data_t rc_data;

/* Global widgets */
extern GtkWidget
  *sdrx_main_window,
  *spectrum_window,
  *stations_window,
  *time_window,
  *smeter_drawingarea,
  *smeter_progbar,
  *signal_display,
  *spectrum_display,
  *center_freq_entry,
  *freq_offset_label,
  *afc_checkbutton,
  *fft_bw_combobox,
  *demod_bw_combobox,
  *smp_rate_combobox,
  *sdrx_buf_combobox,
  *weaver_combobox;

/* Tree list store and treeview for stations window */
extern GtkListStore *stations_list_store;
extern GtkTreeView  *stations_treeview;

/* Spectrum window pixbuf */
extern GdkPixbuf *spectrum_pixbuf;
extern guchar    *spectrum_pixels;

/* Spectrum window pixbuf */
extern GdkPixmap *signal_pixmap;

/* Common between callbacks.c and callback_func.c */
extern GtkWidget
  *quit_dialog,
  *error_dialog;

/* fft in/out buffers */
extern double
  *fft_in_i,
  *fft_in_q;

/* Sound Playback Buffer has to be a ring
 * buffer to allow for the differences in the
 * SDR ADC and Sound card ADC sampling rates */
#define PLAYBACK_BUF_LEN	4096
extern short **playback_buf;
extern int   sound_buf_num;
extern int   demod_buf_num;

/* Sdrx Samples Buffer */
extern double *sdrx_buf_i;
extern double *sdrx_buf_q;

/* Playback control semaphore */
extern sem_t pback_semaphore;

/* Filter data for the main filter */
extern filter_data_t fft_filter_data_i;
extern filter_data_t fft_filter_data_q;

#endif

